/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.coordinates;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.AppName;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.StringUtils;
import java.util.Objects;

public class ImageCoordinates
implements Comparable<ImageCoordinates> {
    private final AppCoordinates appCoordinates;
    private final Version version;

    public static boolean validate(String coordinates, Owner defaultOwner) {
        if (coordinates == null) {
            return false;
        }
        try {
            ImageCoordinates imageCoordinates = new ImageCoordinates(coordinates, defaultOwner);
            return imageCoordinates.getVersion() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ImageCoordinates of(String coordinates, Owner defaultOwner) {
        if (coordinates == null) {
            return null;
        }
        return new ImageCoordinates(coordinates, defaultOwner);
    }

    public ImageCoordinates(String coordinates) {
        this(coordinates, null);
    }

    public ImageCoordinates(String coordinates, Owner defaultOwner) {
        if (!StringUtils.hasLength(coordinates)) {
            throw new BoxfuseException("Missing Image coordinates");
        }
        int versionSplit = coordinates.indexOf(":");
        this.appCoordinates = versionSplit > 0 ? new AppCoordinates(coordinates.substring(0, versionSplit), defaultOwner) : new AppCoordinates(coordinates, defaultOwner);
        this.version = versionSplit > 0 ? new Version(coordinates.substring(versionSplit + 1)) : null;
    }

    public ImageCoordinates(AppCoordinates appCoordinates, Version version) {
        this.appCoordinates = appCoordinates;
        this.version = version;
    }

    public ImageCoordinates(Owner owner, AppName name, Version version) {
        this.appCoordinates = new AppCoordinates(owner, name);
        this.version = version;
    }

    public Owner getOwner() {
        return this.appCoordinates.getOwner();
    }

    public AppName getName() {
        return this.appCoordinates.getName();
    }

    public AppCoordinates getAppCoordinates() {
        return this.appCoordinates;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageCoordinates that = (ImageCoordinates)o;
        return this.appCoordinates.equals(that.appCoordinates) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.appCoordinates.hashCode();
        if (this.version != null) {
            result = 31 * result + this.version.hashCode();
        }
        return result;
    }

    public String toString() {
        return this.getCoordinates();
    }

    public String getCoordinates() {
        if (this.version == null) {
            return this.appCoordinates.toString();
        }
        return this.appCoordinates + ":" + this.version;
    }

    @Override
    public int compareTo(ImageCoordinates o) {
        int result = this.appCoordinates.compareTo(o.appCoordinates);
        if (result == 0) {
            result = this.version == null && o.version == null ? 0 : (this.version != null && o.version != null ? this.version.compareTo(o.version) : (this.version != null ? 1 : -1));
        }
        return result;
    }
}

