/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.enums;

import com.boxfuse.base.exception.BoxfuseException;

public enum ScalingType {
    FIXED("fixed", "fixed"),
    ALARM_CPU("cpu", "CPU usage"),
    ALARM_NET_IN("netin", "inbound network traffic"),
    ALARM_NET_OUT("netout", "outbound network traffic");

    private final String code;
    private final String metric;

    private ScalingType(String code, String metric) {
        this.code = code;
        this.metric = metric;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getCode() {
        return this.code;
    }

    public static ScalingType fromCode(String code) {
        for (ScalingType scalingType : ScalingType.values()) {
            if (!scalingType.code.equals(code)) continue;
            return scalingType;
        }
        throw new BoxfuseException("Unknown scaling metric: " + code);
    }
}

