/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.logs;

import com.boxfuse.base.logs.Logs;
import com.boxfuse.base.logs.LogsListener;

public abstract class AsyncLogs
implements Logs {
    private final String name;
    private boolean running;
    private Thread thread;

    public AsyncLogs(String name) {
        this.name = name;
    }

    @Override
    public final void start(boolean tail, LogsListener logsListener) {
        if (!this.running) {
            this.thread = new Thread(new AsyncLogsRunnable(tail, logsListener));
            this.thread.setName(this.name);
            this.thread.setDaemon(!tail);
            this.thread.start();
            this.running = true;
        }
    }

    protected void init(boolean tail, LogsListener logsListener) throws Exception {
    }

    protected abstract void poll(boolean var1, LogsListener var2) throws Exception;

    protected void finish(boolean tail, LogsListener logsListener) throws Exception {
    }

    protected void cleanup(boolean tail, LogsListener logsListener) {
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void waitForStop() {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncLogs asyncLogs = (AsyncLogs)o;
        return this.running == asyncLogs.running && (this.thread != null ? this.thread.equals(asyncLogs.thread) : asyncLogs.thread == null);
    }

    public int hashCode() {
        int result = this.running ? 1 : 0;
        result = 31 * result + (this.thread != null ? this.thread.hashCode() : 0);
        return result;
    }

    private class AsyncLogsRunnable
    implements Runnable {
        private final boolean tail;
        private final LogsListener logsListener;

        AsyncLogsRunnable(boolean tail, LogsListener logsListener) {
            this.tail = tail;
            this.logsListener = logsListener;
        }

        @Override
        public void run() {
            try {
                AsyncLogs.this.init(this.tail, this.logsListener);
                while (AsyncLogs.this.running) {
                    AsyncLogs.this.poll(this.tail, this.logsListener);
                }
                AsyncLogs.this.finish(this.tail, this.logsListener);
            }
            catch (Exception e) {
                this.logsListener.onException(e);
            }
            finally {
                AsyncLogs.this.cleanup(this.tail, this.logsListener);
            }
        }
    }
}

