/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.coordinates;

import com.boxfuse.base.exception.BoxfuseException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.regex.Pattern;

public class Owner
implements Comparable<Owner> {
    private static final Pattern REGEX = Pattern.compile("[a-z0-9]+");
    private final String owner;

    @JsonCreator
    public Owner(String owner) {
        if (!REGEX.matcher(owner).matches()) {
            throw new BoxfuseException("Invalid App owner: " + owner);
        }
        this.owner = owner;
    }

    @JsonValue
    public String getOwner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Owner owner1 = (Owner)o;
        return this.owner.equals(owner1.owner);
    }

    public int hashCode() {
        return this.owner.hashCode();
    }

    public String toString() {
        return this.owner;
    }

    @Override
    public int compareTo(Owner o) {
        return this.owner.compareTo(o.owner);
    }
}

