/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.crypto;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;

public class PKCS1 {
    private int pos;
    private byte[] data;
    private KeySpec keySpec;

    public PKCS1(byte[] data) throws InvalidKeyException {
        this.data = data;
        if (this.data[this.pos] != 48) {
            throw new InvalidKeyException("invalid private key leading tag " + this.data[this.pos]);
        }
        this.pos = 1;
        this.rdLen();
        if (this.data[this.pos] != 2) {
            throw new InvalidKeyException("encountered invalid integer tag " + this.data[this.pos] + " at " + this.pos);
        }
        ++this.pos;
        int len = this.rdLen();
        this.pos += len;
        BigInteger[] ints = new BigInteger[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            ints[i2] = this.rdInteger();
        }
        this.keySpec = new RSAPrivateCrtKeySpec(ints[0], ints[1], ints[2], ints[3], ints[4], ints[5], ints[6], ints[7]);
    }

    private int rdLen() {
        int t;
        if ((this.data[this.pos] & 0x80) == 128) {
            int n = this.data[this.pos] & 0x7F;
            ++this.pos;
            t = this.rdLongLen(n);
        } else {
            t = this.data[this.pos];
            ++this.pos;
        }
        return t;
    }

    private int rdLongLen(int n) {
        int r = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            r = r << 8 | this.data[this.pos] & 0xFF;
            ++this.pos;
        }
        return r;
    }

    private BigInteger rdInteger() throws InvalidKeyException {
        if (this.pos >= this.data.length) {
            throw new InvalidKeyException("end of file at " + this.pos);
        }
        if (this.data[this.pos] != 2) {
            throw new InvalidKeyException("encountered invalid integer tag " + this.data[this.pos] + " at " + this.pos);
        }
        ++this.pos;
        int len = this.rdLen();
        byte[] x = new byte[len];
        System.arraycopy(this.data, this.pos, x, 0, len);
        this.pos += len;
        return new BigInteger(x);
    }

    public KeySpec getKeySpec() {
        return this.keySpec;
    }
}

