/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.aws.AwsInstanceType;
import com.boxfuse.base.enums.ScalingType;
import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B7\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rBQ\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0005J\r\u0010\u0016\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0017J\r\u0010\u0018\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0017J\r\u0010\u0019\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u001a\u001a\u00020\nR\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/boxfuse/base/types/Capacity;", "", "instances", "", "instanceType", "Lcom/boxfuse/base/aws/AwsInstanceType;", "(ILcom/boxfuse/base/aws/AwsInstanceType;)V", "instanceMin", "instanceMax", "scalingType", "Lcom/boxfuse/base/enums/ScalingType;", "scalingAlarmUp", "scalingAlarmDown", "(IILcom/boxfuse/base/aws/AwsInstanceType;Lcom/boxfuse/base/enums/ScalingType;II)V", "scalingAlarmDuration", "(IILcom/boxfuse/base/aws/AwsInstanceType;Lcom/boxfuse/base/enums/ScalingType;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getDescriptor", "", "getInstanceMax", "getInstanceMin", "getInstanceType", "getScalingAlarmDown", "()Ljava/lang/Integer;", "getScalingAlarmDuration", "getScalingAlarmUp", "getScalingType", "Companion", "boxfuse-base-core"})
public final class Capacity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int instanceMin;
    private final int instanceMax;
    @NotNull
    private final AwsInstanceType instanceType;
    @NotNull
    private final ScalingType scalingType;
    @Nullable
    private final Integer scalingAlarmUp;
    @Nullable
    private final Integer scalingAlarmDown;
    @Nullable
    private Integer scalingAlarmDuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(Capacity.class);
    private static final int DEFAULT_SCALING_ALARM_DURATION = 300;
    private static final int MAX_INSTANCES = 100;
    @NotNull
    public static final String FORMAT_HELP = " => change it to one of the following formats:\n  5:t2.small                        => ensure there are always 5 t2.small instances running\n  2-10:r6i.large:cpu30-70           => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon average CPU load over the last 300 seconds\n                                         scale in at 30% and below, scale out at 70% and above\n  2-10:r6i.large:cpu30-70:60        => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon average CPU load over the last 60 seconds\n                                         scale in at 30% and below, scale out at 70% and above\n  2-10:r6i.large:netin1024-8300     => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon incoming network traffic per instance over the last 300 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above\n  2-10:r6i.large:netin1024-8300:60  => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon incoming network traffic per instance over the last 60 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above\n  2-10:r6i.large:netout1024-8300    => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon outgoing network traffic per instance over the last 300 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above\n  2-10:r6i.large:netout1024-8300:60 => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon outgoing network traffic per instance over the last 60 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above";
    @NotNull
    private static final String PATTERN_INSTANCE_COUNT = "\\d{1,3}";
    @NotNull
    private static final String PATTERN_INSTANCE_TYPE = "[a-z]\\d[a-z]*\\.[0-9]*[a-z]+";
    @NotNull
    private static final String PATTERN_AUTOSCALING = "\\d{1,3}-\\d{1,3}:[a-z]\\d[a-z]*\\.[0-9]*[a-z]+:(cpu|netin|netout)\\d{1,9}-\\d{1,9}";

    public Capacity(int instanceMin, int instanceMax, @NotNull AwsInstanceType instanceType, @NotNull ScalingType scalingType, @Nullable Integer scalingAlarmUp, @Nullable Integer scalingAlarmDown, @Nullable Integer scalingAlarmDuration) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)instanceType, "instanceType");
        Intrinsics.checkNotNullParameter((Object)scalingType, "scalingType");
        this.instanceMin = instanceMin;
        this.instanceMax = instanceMax;
        this.instanceType = instanceType;
        this.scalingType = scalingType;
        this.scalingAlarmUp = scalingAlarmUp;
        this.scalingAlarmDown = scalingAlarmDown;
        this.scalingAlarmDuration = scalingAlarmDuration;
        if (this.instanceMin > 100) {
            throw new BoxfuseException("Invalid capacity: The number of instances (" + this.instanceMin + ") may not be larger than the maximum allowed (100)");
        }
        if (this.instanceMax > 100) {
            throw new BoxfuseException("Invalid capacity: The number of instances (" + this.instanceMax + ") may not be larger than the maximum allowed (100)");
        }
        if (this.instanceMin > this.instanceMax) {
            throw new BoxfuseException("Invalid capacity: The minimum number of instances (" + this.instanceMin + ") may not be larger than the maximum (" + this.instanceMax + ')');
        }
        if (this.instanceMin == this.instanceMax && ScalingType.FIXED != this.scalingType) {
            throw new BoxfuseException("Invalid capacity: Minimum and maximum number of instances are identical (" + this.instanceMin + "), but scaling triggers are present.\n=> configure a variable capacity or remove the scaling triggers.");
        }
        if (ScalingType.FIXED != this.scalingType) {
            n = this.scalingAlarmDown;
            Intrinsics.checkNotNull(n);
            int n2 = n;
            n = this.scalingAlarmUp;
            Intrinsics.checkNotNull(n);
            if (n2 >= n) {
                throw new BoxfuseException("Invalid capacity: The " + this.scalingType.getMetric() + " for scaling down (" + this.scalingAlarmDown + ") must be smaller than the one for scaling up (" + this.scalingAlarmUp + ')');
            }
        }
        if (ScalingType.ALARM_CPU == this.scalingType) {
            n = this.scalingAlarmDown;
            Intrinsics.checkNotNull(n);
            if (n > 99) {
                throw new BoxfuseException("Invalid capacity: The " + this.scalingType.getMetric() + " for scaling down (" + this.scalingAlarmDown + ") may not be greater than 99");
            }
            n = this.scalingAlarmUp;
            Intrinsics.checkNotNull(n);
            if (n > 100) {
                throw new BoxfuseException("Invalid capacity: The " + this.scalingType.getMetric() + " for scaling up (" + this.scalingAlarmUp + ") may not be greater than 100");
            }
        }
        if (this.scalingAlarmDuration != null) {
            n = this.scalingAlarmDuration;
            Intrinsics.checkNotNull(n);
            this.scalingAlarmDuration = Capacity.Companion.sanitizeScalingAlarmDuration(n);
        }
    }

    public /* synthetic */ Capacity(int n, int n2, AwsInstanceType awsInstanceType, ScalingType scalingType, Integer n3, Integer n4, Integer n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = 1;
        }
        if ((n6 & 2) != 0) {
            n2 = n;
        }
        if ((n6 & 4) != 0) {
            awsInstanceType = AwsInstanceType.T2_MICRO;
        }
        if ((n6 & 8) != 0) {
            scalingType = ScalingType.FIXED;
        }
        if ((n6 & 0x10) != 0) {
            n3 = null;
        }
        if ((n6 & 0x20) != 0) {
            n4 = null;
        }
        if ((n6 & 0x40) != 0) {
            n5 = scalingType == ScalingType.FIXED ? null : Integer.valueOf(300);
        }
        this(n, n2, awsInstanceType, scalingType, n3, n4, n5);
    }

    public Capacity(int instances, @NotNull AwsInstanceType instanceType) {
        Intrinsics.checkNotNullParameter((Object)instanceType, "instanceType");
        this(instances, instances, instanceType, ScalingType.FIXED, null, null, null);
    }

    public Capacity(int instanceMin, int instanceMax, @NotNull AwsInstanceType instanceType, @NotNull ScalingType scalingType, int scalingAlarmUp, int scalingAlarmDown) {
        Intrinsics.checkNotNullParameter((Object)instanceType, "instanceType");
        Intrinsics.checkNotNullParameter((Object)scalingType, "scalingType");
        this(instanceMin, instanceMax, instanceType, scalingType, scalingAlarmUp, scalingAlarmDown, 300);
    }

    @NotNull
    public final String getDescriptor() {
        return this.instanceMin + (this.scalingType == ScalingType.FIXED ? "" : Intrinsics.stringPlus("-", this.instanceMax)) + ':' + (Object)((Object)this.instanceType) + ':' + (this.scalingType == ScalingType.FIXED ? "" : this.scalingType.getCode() + this.scalingAlarmDown + '-' + this.scalingAlarmUp + ':' + this.scalingAlarmDuration);
    }

    public final int getInstanceMin() {
        return this.instanceMin;
    }

    public final int getInstanceMax() {
        return this.instanceMax;
    }

    @NotNull
    public final AwsInstanceType getInstanceType() {
        return this.instanceType;
    }

    @NotNull
    public final ScalingType getScalingType() {
        return this.scalingType;
    }

    @Nullable
    public final Integer getScalingAlarmUp() {
        return this.scalingAlarmUp;
    }

    @Nullable
    public final Integer getScalingAlarmDown() {
        return this.scalingAlarmDown;
    }

    @Nullable
    public final Integer getScalingAlarmDuration() {
        return this.scalingAlarmDuration;
    }

    public Capacity() {
        this(0, 0, null, null, null, null, null, 127, null);
    }

    @JvmStatic
    @Nullable
    public static final Capacity of(@Nullable String descriptor) {
        return Companion.of(descriptor);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/boxfuse/base/types/Capacity$Companion;", "", "()V", "DEFAULT_SCALING_ALARM_DURATION", "", "FORMAT_HELP", "", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAX_INSTANCES", "PATTERN_AUTOSCALING", "PATTERN_INSTANCE_COUNT", "PATTERN_INSTANCE_TYPE", "extractScalingAlarmDuration", "part", "of", "Lcom/boxfuse/base/types/Capacity;", "descriptor", "parseInt", "str", "sanitizeScalingAlarmDuration", "duration", "boxfuse-base-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Capacity of(@Nullable String descriptor) {
            Capacity capacity;
            if (descriptor == null) {
                return null;
            }
            if (!StringUtils.hasLength(descriptor)) {
                throw new BoxfuseException("Invalid capacity info: Missing capacity info => change it to one of the following formats:\n  5:t2.small                        => ensure there are always 5 t2.small instances running\n  2-10:r6i.large:cpu30-70           => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon average CPU load over the last 300 seconds\n                                         scale in at 30% and below, scale out at 70% and above\n  2-10:r6i.large:cpu30-70:60        => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon average CPU load over the last 60 seconds\n                                         scale in at 30% and below, scale out at 70% and above\n  2-10:r6i.large:netin1024-8300     => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon incoming network traffic per instance over the last 300 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above\n  2-10:r6i.large:netin1024-8300:60  => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon incoming network traffic per instance over the last 60 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above\n  2-10:r6i.large:netout1024-8300    => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon outgoing network traffic per instance over the last 300 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above\n  2-10:r6i.large:netout1024-8300:60 => auto-scale between 2 (min) and 10 (max) r6i.large instances\n                                         based upon outgoing network traffic per instance over the last 60 seconds\n                                         scale in at 1024 KB and below, scale out at 8300 KB and above");
            }
            String[] parts = StringUtils.tokenizeToStringArray(descriptor, ":");
            Object object = descriptor;
            Regex regex = new Regex(Capacity.PATTERN_INSTANCE_COUNT);
            boolean bl = false;
            if (regex.matches((CharSequence)object)) {
                capacity = new Capacity(this.parseInt(descriptor), 0, null, null, null, null, null, 126, null);
            } else {
                object = descriptor;
                regex = new Regex(Capacity.PATTERN_INSTANCE_TYPE);
                bl = false;
                if (regex.matches((CharSequence)object)) {
                    object = AwsInstanceType.fromName(descriptor);
                    Intrinsics.checkNotNullExpressionValue(object, "fromName(descriptor)");
                    Capacity capacity2 = new Capacity(0, 0, (AwsInstanceType)((Object)object), null, null, null, null, 123, null);
                    capacity = capacity2;
                } else {
                    object = descriptor;
                    regex = new Regex("\\d{1,3}:[a-z]\\d[a-z]*\\.[0-9]*[a-z]+");
                    bl = false;
                    if (regex.matches((CharSequence)object)) {
                        object = parts[0];
                        Intrinsics.checkNotNullExpressionValue(object, "parts[0]");
                        int n = this.parseInt((String)object);
                        object = AwsInstanceType.fromName(parts[1]);
                        Intrinsics.checkNotNullExpressionValue(object, "fromName(parts[1])");
                        Capacity capacity3 = new Capacity(n, 0, (AwsInstanceType)((Object)object), null, null, null, null, 122, null);
                        capacity = capacity3;
                    } else {
                        int min2;
                        Object i2;
                        object = descriptor;
                        regex = new Regex(Capacity.PATTERN_AUTOSCALING);
                        bl = false;
                        if (regex.matches((CharSequence)object)) {
                            int n;
                            Object object2;
                            int alarmDuration = 300;
                            i2 = StringUtils.tokenizeToStringArray(parts[0], "-");
                            String string = i2[0];
                            Intrinsics.checkNotNullExpressionValue(string, "i[0]");
                            min2 = this.parseInt(string);
                            Object object3 = i2[1];
                            Intrinsics.checkNotNullExpressionValue(object3, "i[1]");
                            int max = this.parseInt((String)object3);
                            AwsInstanceType type = AwsInstanceType.fromName(parts[1]);
                            String part = parts[2];
                            while (true) {
                                CharSequence charSequence = part;
                                Intrinsics.checkNotNullExpressionValue(charSequence, "part");
                                charSequence = charSequence;
                                object2 = new Regex("\\d.*");
                                n = 0;
                                if (((Regex)object2).matches(charSequence)) break;
                                charSequence = part;
                                Intrinsics.checkNotNullExpressionValue(charSequence, "part");
                                int n2 = 1;
                                n = 0;
                                Intrinsics.checkNotNullExpressionValue(((String)charSequence).substring(n2), "(this as java.lang.String).substring(startIndex)");
                            }
                            object2 = parts[2];
                            Intrinsics.checkNotNullExpressionValue(object2, "parts[2]");
                            n = 0;
                            String string2 = parts[2];
                            Intrinsics.checkNotNullExpressionValue(string2, "parts[2]");
                            CharSequence charSequence = string2;
                            string2 = part;
                            Intrinsics.checkNotNullExpressionValue(string2, "part");
                            int n3 = StringsKt.indexOf$default(charSequence, string2, 0, false, 6, null);
                            boolean bl2 = false;
                            String string3 = ((String)object2).substring(n, n3);
                            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            ScalingType scaling = ScalingType.fromCode(string3);
                            String[] s = StringUtils.tokenizeToStringArray(part, "-");
                            String string4 = s[0];
                            Intrinsics.checkNotNullExpressionValue(string4, "s[0]");
                            int alarmDown22 = this.parseInt(string4);
                            String string5 = s[1];
                            Intrinsics.checkNotNullExpressionValue(string5, "s[1]");
                            int alarmUp = this.parseInt(string5);
                            Intrinsics.checkNotNullExpressionValue((Object)type, "type");
                            Intrinsics.checkNotNullExpressionValue((Object)scaling, "scaling");
                            capacity = new Capacity(min2, max, type, scaling, alarmUp, alarmDown22, alarmDuration);
                        } else {
                            CharSequence alarmDuration = descriptor;
                            i2 = new Regex("\\d{1,3}-\\d{1,3}:[a-z]\\d[a-z]*\\.[0-9]*[a-z]+:(cpu|netin|netout)\\d{1,9}-\\d{1,9}:\\d{1,9}");
                            min2 = 0;
                            if (((Regex)i2).matches(alarmDuration)) {
                                int alarmUp;
                                Object alarmDown22;
                                String[] parts1 = StringUtils.tokenizeToStringArray(descriptor, ":");
                                String min2 = parts1[3];
                                Intrinsics.checkNotNullExpressionValue(min2, "parts1[3]");
                                int alarmDuration2 = this.extractScalingAlarmDuration(min2);
                                String[] i3 = StringUtils.tokenizeToStringArray(parts1[0], "-");
                                String type = i3[0];
                                Intrinsics.checkNotNullExpressionValue(type, "i[0]");
                                int min3 = this.parseInt(type);
                                String part = i3[1];
                                Intrinsics.checkNotNullExpressionValue(part, "i[1]");
                                int max = this.parseInt(part);
                                AwsInstanceType type2 = AwsInstanceType.fromName(parts1[1]);
                                String part2 = parts1[2];
                                while (true) {
                                    CharSequence s = part2;
                                    Intrinsics.checkNotNullExpressionValue(s, "part");
                                    s = s;
                                    alarmDown22 = new Regex("\\d.*");
                                    alarmUp = 0;
                                    if (((Regex)alarmDown22).matches(s)) break;
                                    s = part2;
                                    Intrinsics.checkNotNullExpressionValue(s, "part");
                                    int alarmDown22 = 1;
                                    alarmUp = 0;
                                    Intrinsics.checkNotNullExpressionValue(((String)s).substring(alarmDown22), "(this as java.lang.String).substring(startIndex)");
                                }
                                alarmDown22 = parts[2];
                                Intrinsics.checkNotNullExpressionValue(alarmDown22, "parts[2]");
                                alarmUp = 0;
                                String string = parts[2];
                                Intrinsics.checkNotNullExpressionValue(string, "parts[2]");
                                CharSequence charSequence = string;
                                string = part2;
                                Intrinsics.checkNotNullExpressionValue(string, "part");
                                int n = StringsKt.indexOf$default(charSequence, string, 0, false, 6, null);
                                boolean bl3 = false;
                                String string6 = ((String)alarmDown22).substring(alarmUp, n);
                                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                ScalingType scaling = ScalingType.fromCode(string6);
                                String[] s = StringUtils.tokenizeToStringArray(part2, "-");
                                String string7 = s[0];
                                Intrinsics.checkNotNullExpressionValue(string7, "s[0]");
                                int alarmDown = this.parseInt(string7);
                                String string8 = s[1];
                                Intrinsics.checkNotNullExpressionValue(string8, "s[1]");
                                int alarmUp2 = this.parseInt(string8);
                                Intrinsics.checkNotNullExpressionValue((Object)type2, "type");
                                Intrinsics.checkNotNullExpressionValue((Object)scaling, "scaling");
                                capacity = new Capacity(min3, max, type2, scaling, alarmUp2, alarmDown, alarmDuration2);
                            } else {
                                throw new BoxfuseException("Invalid capacity info: " + descriptor + Capacity.FORMAT_HELP);
                            }
                        }
                    }
                }
            }
            return capacity;
        }

        private final int extractScalingAlarmDuration(String part) {
            return this.sanitizeScalingAlarmDuration(this.parseInt(part));
        }

        private final int sanitizeScalingAlarmDuration(int duration) {
            if (duration < 60) {
                LOGGER.warn("Measurement period (" + duration + " seconds) has been corrected to the minimum value of 60 seconds (1 minute)");
                return 60;
            }
            if (duration > 86400) {
                LOGGER.warn("Measurement period (" + duration + " seconds) has been corrected to the maximum value of 86400 seconds (1 day)");
                return 86400;
            }
            if (duration % 60 != 0) {
                int newDuration = duration / 60 * 60;
                LOGGER.warn("Measurement period (" + duration + " seconds) must be a multiple of 60 seconds and has been corrected to the value of " + newDuration + " seconds");
                return newDuration;
            }
            return duration;
        }

        private final int parseInt(String str) {
            try {
                String string = str;
                boolean bl = false;
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                throw new BoxfuseBugException(Intrinsics.stringPlus("Invalid capacity definition: not an int: ", str));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

