/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;

public class Domain
implements Comparable<Domain> {
    public static final Domain AUTO = new Domain("auto");
    private final String domain;

    private Domain(String domain) {
        this.domain = domain.toLowerCase(Locale.ENGLISH);
    }

    @JsonCreator
    public static Domain of(String domain) {
        if (domain == null) {
            return null;
        }
        if (Domain.AUTO.domain.equals(domain)) {
            return AUTO;
        }
        if (!domain.matches("[A-Za-z0-9\\-.]+") || domain.startsWith(".") || domain.endsWith(".") || domain.startsWith("-") || domain.endsWith("-") || domain.contains("..") || domain.contains("--") || domain.contains("-.") || domain.contains(".-")) {
            throw new BoxfuseException("Invalid domain (may only contain a-z, 0-9, - and .): " + domain);
        }
        return new Domain(domain);
    }

    public static Domain ofSubdomain(String a, Domain b) {
        return Domain.of((StringUtils.hasLength(a) ? a + "." : "") + b.getDomain());
    }

    @JsonValue
    public String getDomain() {
        return this.domain;
    }

    public String toString() {
        return this.domain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain domain1 = (Domain)o;
        return this.domain.equals(domain1.domain);
    }

    public int hashCode() {
        return this.domain.hashCode();
    }

    @Override
    public int compareTo(Domain o) {
        return this.domain.compareTo(o.domain);
    }

    public boolean matches(String wildcardDomain) {
        return this.domain.equals(wildcardDomain) || wildcardDomain.startsWith("*.") && this.domain.endsWith(wildcardDomain.substring(1)) && !this.domain.substring(0, this.domain.indexOf(wildcardDomain.substring(1))).contains(".");
    }
}

