/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class IpAddress
implements Comparable<IpAddress> {
    public static final IpAddress AUTO = new IpAddress("auto");
    public static final IpAddress LOCALHOST = new IpAddress("127.0.0.1");
    private static final int PART_COUNT = 4;
    private final String ipAddress;

    @JsonCreator
    public static IpAddress of(String ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        if (IpAddress.AUTO.ipAddress.equals(ipAddress)) {
            return AUTO;
        }
        if (!ipAddress.matches("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}")) {
            throw new BoxfuseException("Invalid ip address: " + ipAddress);
        }
        int[] parts = IpAddress.getParts(ipAddress);
        if (parts.length != 4) {
            throw new BoxfuseException("Invalid ip address: " + ipAddress);
        }
        for (int part : parts) {
            if (part <= 255) continue;
            throw new BoxfuseException("Invalid ip address: " + ipAddress);
        }
        return new IpAddress(ipAddress);
    }

    private IpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public IpAddress applyCidrMask(int bits) {
        if (this == AUTO) {
            throw new BoxfuseBugException("Unable to apply CIDR mask to 'auto' elastic IP");
        }
        if (bits == 0) {
            return new IpAddress("0.0.0.0");
        }
        String[] parts = StringUtils.tokenizeToStringArray(this.ipAddress, ".");
        int[] ip = new int[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            ip[i2] = Integer.parseInt(parts[i2]);
        }
        long ipNumbers = 0L;
        for (int i3 = 0; i3 < 4; ++i3) {
            ipNumbers += (long)(ip[i3] << 24 - 8 * i3);
        }
        long mask = -1 << 32 - bits;
        long result = ipNumbers & mask;
        byte[] bytes = ByteBuffer.allocate(8).putLong(result).array();
        return new IpAddress((bytes[4] & 0xFF) + "." + (bytes[5] & 0xFF) + "." + (bytes[6] & 0xFF) + "." + (bytes[7] & 0xFF));
    }

    @JsonValue
    public String getIpAddress() {
        return this.ipAddress;
    }

    public String toString() {
        return this.ipAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpAddress ipAddress1 = (IpAddress)o;
        return this.ipAddress.equals(ipAddress1.ipAddress);
    }

    public int hashCode() {
        return this.ipAddress.hashCode();
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByName(this.ipAddress);
        }
        catch (UnknownHostException e) {
            throw new BoxfuseException("Invalid ip address: " + this.ipAddress, e);
        }
    }

    @Override
    public int compareTo(IpAddress o) {
        int[] parts = IpAddress.getParts(this.ipAddress);
        int[] oParts = IpAddress.getParts(o.ipAddress);
        for (int i2 = 0; i2 < 4; ++i2) {
            int result = parts[i2] - oParts[i2];
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private static int[] getParts(String ipAddress) {
        String[] parts = StringUtils.tokenizeToStringArray(ipAddress, ".");
        int[] intParts = new int[parts.length];
        for (int i2 = 0; i2 < parts.length; ++i2) {
            intParts[i2] = Integer.parseInt(parts[i2]);
        }
        return intParts;
    }
}

