/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.types;

import com.boxfuse.base.exception.BoxfuseException;
import com.fasterxml.jackson.annotation.JsonValue;

public abstract class RegexRestrictedString<T extends RegexRestrictedString>
implements Comparable<T> {
    private final String value;

    protected RegexRestrictedString(String value) {
        this.value = value;
    }

    protected RegexRestrictedString(String value, String field, String regex) {
        this.value = this.validateRegex(value, field, regex);
    }

    private String validateRegex(String value, String field, String regex) {
        if (!value.matches(regex)) {
            throw new BoxfuseException("Invalid " + field + ": " + value + " => ensure it matches " + regex);
        }
        return value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexRestrictedString that = (RegexRestrictedString)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(T o) {
        return this.value.compareTo(((RegexRestrictedString)o).getValue());
    }
}

