/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.cache;

import com.boxfuse.base.crypto.CryptoUtils;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.JsonUtils;
import com.boxfuse.base.util.ShellUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class ActivationCache {
    private static final byte[] MESSAGE = new byte[]{40, -53, -34, 104, -126, 95, -57, 68, 80, 4, -26, 35, 74, -49, 127, -13};
    private final File activationCache;

    private byte[] getMessage() {
        byte[] result = new byte[MESSAGE.length];
        for (int i2 = 0; i2 < MESSAGE.length; ++i2) {
            result[i2] = (byte)(MESSAGE[i2] ^ (i2 + 1) * 11);
        }
        return result;
    }

    public ActivationCache(File dir) {
        ShellUtils.mkdir(dir);
        this.activationCache = new File(dir, "activation");
    }

    public boolean hasActivation() {
        return this.activationCache.canRead();
    }

    public Map<String, Object> loadActivation() {
        return JsonUtils.jsonToMap(new String(CryptoUtils.aesDecrypt(IOUtils.copyToByteArray(this.activationCache), this.getMessage()), StandardCharsets.UTF_8));
    }

    public void saveActivation(Map<String, Object> activation) {
        if (this.activationCache.canRead()) {
            ShellUtils.deleteFile(this.activationCache);
        }
        IOUtils.copy(CryptoUtils.aesEncrypt(JsonUtils.mapToJson(activation).getBytes(StandardCharsets.UTF_8), this.getMessage()), this.activationCache);
    }
}

