/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform;

import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.port.Restriction;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.types.HealthcheckTimeout;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.types.TmpGB;
import com.boxfuse.base.util.CollectionUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.config.BoxfuseConfig;
import com.boxfuse.generator.config.CpuCount;
import com.boxfuse.generator.config.RamMB;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LaunchSettings {
    private final Map<PortName, Port> ports = new TreeMap<PortName, Port>();
    private Boolean healthcheck;
    private PortName healthcheckPort;
    private Path healthcheckPath;
    private HealthcheckTimeout healthcheckTimeout;
    private Boolean debug;
    private Boolean debugWait;
    private TmpGB tmp;
    private String jvmArgs;
    private String jvmMainClass;
    private String jvmMainArgs;
    private Boolean jvmJmx;
    private boolean logsBoot = true;
    private boolean logsAuto = true;
    private boolean logsTail;
    private String logsDir;
    private CpuCount cpus;
    private RamMB ramInMB;
    private final Map<PortName, Port> portsMap = new TreeMap<PortName, Port>();
    private EnvName env = EnvName.DEV;
    private final Map<EnvVarName, EnvVarValue> envVars = new TreeMap<EnvVarName, EnvVarValue>();

    LaunchSettings() {
    }

    public LaunchSettings(BoxfuseConfig config) {
        this.configure(config);
    }

    public boolean isLogsBoot() {
        return this.logsBoot;
    }

    public boolean isLogsAuto() {
        return this.logsAuto;
    }

    public boolean isLogsTail() {
        return this.logsTail;
    }

    public String getLogsDir() {
        return this.logsDir;
    }

    public PortName getHealthcheckPort() {
        return this.healthcheckPort;
    }

    public Path getHealthcheckPath() {
        return this.healthcheckPath;
    }

    public HealthcheckTimeout getHealthcheckTimeout() {
        return this.healthcheckTimeout;
    }

    public CpuCount getCpus() {
        return this.cpus;
    }

    public void setCpus(CpuCount cpus) {
        this.cpus = cpus;
    }

    public RamMB getRamInMB() {
        return this.ramInMB;
    }

    public void setRam(RamMB ramInMB) {
        this.ramInMB = ramInMB;
    }

    public TmpGB getTmp() {
        return this.tmp;
    }

    public void setTmp(TmpGB tmp) {
        this.tmp = tmp;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public String getJvmMainClass() {
        return this.jvmMainClass;
    }

    public String getJvmMainArgs() {
        return this.jvmMainArgs;
    }

    public Boolean getJvmJmx() {
        return this.jvmJmx;
    }

    public Map<PortName, Port> getPortsMap() {
        return this.portsMap;
    }

    public void addPort(String name, String spec) {
        this.ports.put(PortName.of(name), Port.of(spec));
    }

    public Map<PortName, Port> getPorts() {
        return Collections.unmodifiableMap(this.ports);
    }

    void addEnvironmentVariable(String name, String value) {
        this.envVars.put(EnvVarName.of(name), EnvVarValue.flexi(value));
    }

    public Map<EnvVarName, EnvVarValue> getEnvVars() {
        return Collections.unmodifiableMap(this.envVars);
    }

    public EnvName getEnv() {
        return this.env;
    }

    public void setEnv(EnvName env) {
        this.env = env;
    }

    public Boolean getHealthcheck() {
        return this.healthcheck;
    }

    public void setHealthcheck(Boolean healthcheck) {
        this.healthcheck = healthcheck;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public Boolean getDebugWait() {
        return this.debugWait;
    }

    private void configure(BoxfuseConfig config) {
        if (config.healthcheck.enabled.isSet()) {
            this.setHealthcheck(config.healthcheck.enabled.get());
        }
        if (config.healthcheck.port.isSet()) {
            this.healthcheckPort = config.healthcheck.port.get();
        }
        if (config.healthcheck.path.isSet()) {
            this.healthcheckPath = config.healthcheck.path.get();
        }
        if (config.healthcheck.timeout.isSet()) {
            this.healthcheckTimeout = config.healthcheck.timeout.get();
        }
        if (config.jvm.args.isSet()) {
            this.jvmArgs = config.jvm.args.get();
        }
        if (config.jvm.mainClass.isSet()) {
            this.jvmMainClass = config.jvm.mainClass.get();
        }
        if (config.jvm.mainArgs.isSet()) {
            this.jvmMainArgs = config.jvm.mainArgs.get();
        }
        if (config.jvm.jmx.isSet()) {
            this.jvmJmx = config.jvm.jmx.get();
        }
        if (config.debug.enabled.isSet()) {
            this.setDebug(config.debug.enabled.get());
        }
        if (config.debug.wait.isSet()) {
            this.debugWait = config.debug.wait.get();
        }
        if (config.logs.boot.isSet()) {
            this.logsBoot = config.logs.boot.get();
        }
        if (config.logs.auto.isSet()) {
            this.logsAuto = config.logs.auto.get();
        }
        if (config.logs.tail.isSet()) {
            this.logsTail = config.logs.tail.get();
        }
        if (config.logs.dir.isSet()) {
            this.logsDir = config.logs.dir.get();
        }
        this.setCpus(config.cpus.get());
        this.setRam(config.ram.get());
        this.setTmp(config.tmp.get());
        if (config.env.isSet()) {
            this.setEnv(config.env.get());
        }
        this.ports.putAll(config.ports);
        if (Boolean.TRUE.equals(this.debug) && !this.ports.containsKey(PortName.DEBUG)) {
            this.ports.put(PortName.DEBUG, Port.of(5005, Protocol.TCP, Restriction.OWN_IP));
        }
        if (Boolean.TRUE.equals(this.jvmJmx) && !this.ports.containsKey(PortName.JMX)) {
            this.ports.put(PortName.JMX, Port.of(1099, Protocol.TCP, Restriction.OWN_IP));
        }
        this.portsMap.putAll(config.portsmap);
        Map<Port, List<PortName>> portDuplicates = CollectionUtils.findDuplicateValues(this.portsMap);
        if (!portDuplicates.isEmpty()) {
            Map.Entry<Port, List<PortName>> duplicate = portDuplicates.entrySet().iterator().next();
            throw new BoxfuseException("Multiple ports mapped to " + duplicate.getKey() + ": " + StringUtils.collectionToDelimitedString((Collection)duplicate.getValue(), ", "));
        }
        this.envVars.putAll(config.envvars);
    }
}

