/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.logs.AsyncLogs;
import com.boxfuse.base.logs.LogsListener;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.generator.config.InstanceId;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SerialPortFileLogs
extends AsyncLogs {
    private final File serialConsole;
    private final File serialConsolePosition;
    private long position;
    private RandomAccessFile reader;
    private ByteArrayOutputStream out;

    private SerialPortFileLogs(InstanceId instanceId, File serialConsole, File serialConsolePosition) {
        super(instanceId.getId() + " Boot Logs");
        this.serialConsole = serialConsole;
        this.serialConsolePosition = serialConsolePosition;
    }

    public static SerialPortFileLogs createInDir(File dir, InstanceId instanceId) {
        ShellUtils.mkdir(dir);
        return new SerialPortFileLogs(instanceId, new File(dir, instanceId + ".logs"), new File(dir, instanceId + ".logs.pos"));
    }

    public String getLogsFilePath() {
        try {
            return this.serialConsole.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to get Logs for Instance", e);
        }
    }

    @Override
    protected void init(boolean tail, LogsListener logsListener) throws Exception {
        this.position = this.serialConsolePosition.isFile() ? Math.max(0L, Long.valueOf(IOUtils.copyToString(new FileInputStream(this.serialConsolePosition))) - 4096L) : 0L;
        this.reader = null;
        while (this.reader == null) {
            try {
                this.reader = new RandomAccessFile(this.serialConsole, "r");
                this.reader.seek(this.position);
            }
            catch (FileNotFoundException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.out = new ByteArrayOutputStream();
    }

    @Override
    protected void poll(boolean tail, LogsListener logsListener) throws Exception {
        if (this.serialConsole.length() > this.position) {
            int num;
            byte[] buffer = new byte[4096];
            while (this.isRunning() && (num = this.reader.read(buffer)) != -1) {
                block7: for (int i2 = 0; i2 < num; ++i2) {
                    byte ch = buffer[i2];
                    switch (ch) {
                        case 10: {
                            logsListener.onInfoLine(this.out.toString("UTF-8"));
                            this.out.reset();
                            continue block7;
                        }
                        case 13: {
                            continue block7;
                        }
                        default: {
                            this.out.write(ch);
                        }
                    }
                }
            }
            this.position = this.reader.getFilePointer();
        }
        if (tail) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.stop();
            }
        } else {
            this.stop();
        }
    }

    @Override
    protected void finish(boolean tail, LogsListener logsListener) throws Exception {
        try (FileWriter fileWriter = new FileWriter(this.serialConsolePosition);){
            fileWriter.append(Long.toString(this.position));
        }
    }

    @Override
    protected void cleanup(boolean tail, LogsListener logsListener) {
        IOUtils.close(this.reader);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SerialPortFileLogs that = (SerialPortFileLogs)o;
        if (this.position != that.position) {
            return false;
        }
        if (!this.serialConsole.equals(that.serialConsole)) {
            return false;
        }
        if (!this.serialConsolePosition.equals(that.serialConsolePosition)) {
            return false;
        }
        if (this.reader != null ? !this.reader.equals(that.reader) : that.reader != null) {
            return false;
        }
        return this.out != null ? this.out.equals(that.out) : that.out == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.serialConsole.hashCode();
        result = 31 * result + this.serialConsolePosition.hashCode();
        result = 31 * result + (int)(this.position ^ this.position >>> 32);
        result = 31 * result + (this.reader != null ? this.reader.hashCode() : 0);
        result = 31 * result + (this.out != null ? this.out.hashCode() : 0);
        return result;
    }
}

