/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.privateuse.util;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.logs.Logs;
import com.boxfuse.base.logs.LogsListener;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogsUtils {
    public static final String BOXFUSE_LOGS_LOGGER_NAME = "boxfuse.logs";
    private static final Logger LOGS_LOGGER = LoggerFactory.getLogger((String)"boxfuse.logs");

    public static void showLogs(final Logs logs, final String logTarget, boolean tail) {
        final ArrayList holder = new ArrayList();
        logs.start(tail, new LogsListener(){

            @Override
            public void onTraceLine(String line) {
                LOGS_LOGGER.trace(line);
            }

            @Override
            public void onDebugLine(String line) {
                LOGS_LOGGER.debug(line);
            }

            @Override
            public void onInfoLine(String line) {
                LOGS_LOGGER.info(line);
            }

            @Override
            public void onWarnLine(String line) {
                LOGS_LOGGER.warn(line);
            }

            @Override
            public void onErrorLine(String line) {
                LOGS_LOGGER.error(line);
            }

            @Override
            public void onException(Exception e) {
                logs.stop();
                holder.add(new BoxfuseException("Unable to read from Logs for " + logTarget + ": " + e.getMessage(), e));
            }
        });
        logs.waitForStop();
        if (!holder.isEmpty()) {
            throw (RuntimeException)holder.get(0);
        }
    }
}

