/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.privateuse.util;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import java.util.Arrays;

public enum PlatformTypeConfig {
    AUTO("auto"),
    VIRTUALBOX("virtualbox"),
    HYPERV("hyperv");

    private final String name;

    private PlatformTypeConfig(String name) {
        this.name = name;
    }

    public static PlatformTypeConfig of(String name) {
        if (name == null) {
            return null;
        }
        for (PlatformTypeConfig platformTypeConfig : PlatformTypeConfig.values()) {
            if (!name.equals(platformTypeConfig.name)) continue;
            return platformTypeConfig;
        }
        throw new BoxfuseException("Unknown platform: " + name + " (possible choices: " + StringUtils.collectionToDelimitedString(Arrays.asList(PlatformTypeConfig.values()), ", ") + ")");
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

