/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.generic;

import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.Template;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.RamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.generic.GenericPayload;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class GenericRamDiskBuilder<P extends GenericPayload>
extends RamDiskBuilder<P> {
    public GenericRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
    }

    @Override
    protected String getStartDir() {
        return "/app";
    }

    @Override
    protected void installPayloadWithDependencies() throws IOException {
        ((GenericPayload)this.payload).installInto(this.ramDisk, "app");
        if (this.spec.getTlsType() == TlsType.ACM) {
            this.ramDisk.createFile("app-config/boxfuse-selfsigned-cert.pem", false, IOUtils.copyToByteArray("generator/selfsigned/boxfuse-selfsigned-cert.pem"));
            this.ramDisk.createFile("app-config/boxfuse-selfsigned-key.pem", false, IOUtils.copyToByteArray("generator/selfsigned/boxfuse-selfsigned-key.pem"));
        }
    }

    @Override
    protected String createLaunchScript(String straceCmd, Map<EnvVarName, EnvVarValue> envVars) {
        return Template.process("generator/launch-generic.template", this.getStartDir(), "./" + this.getCmd(), straceCmd);
    }

    private String getCmd() {
        return this.spec.getCmd() == null ? ((GenericPayload)this.payload).getCmd() : this.spec.getCmd();
    }
}

