/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.generic;

import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.generic.GenericPayload;
import com.boxfuse.generator.payload.FilePayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class GenericTarGzPayload
extends FilePayload
implements GenericPayload {
    private static final String SYSCTL_CONF = "sysctl.conf";

    public GenericTarGzPayload(File file, byte[] bytes, Map<String, PayloadEntry> entries) {
        super(file, bytes, entries);
    }

    public static boolean supports(PayloadFormat format, Map<String, PayloadEntry> entries, boolean live) {
        if (PayloadFormat.TARGZ == format && !live) {
            for (PayloadEntry entry : entries.values()) {
                if (!entry.isExecutable()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PayloadType getType() {
        return PayloadType.LINUX_X64;
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        if (this.entries.keySet().contains(SYSCTL_CONF)) {
            return Pair.of(SYSCTL_CONF, null);
        }
        return null;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        ramDisk.installTarGzArchive(this.bytes, baseDir);
    }

    @Override
    public String getCmd() {
        for (PayloadEntry entry : this.entries.values()) {
            if (!entry.isExecutable()) continue;
            return entry.getName();
        }
        return null;
    }
}

