/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.generic.go.revel;

import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.ini4j.Wini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevelConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevelConfig.class);
    private final Map<PortName, Port> ports = new HashMap<PortName, Port>();

    public RevelConfig(String config) {
        try {
            Wini wini = new Wini(new StringReader("[default]\n" + config));
            boolean ssl = "true".equals(wini.get((Object)"default", "http.ssl"));
            this.addPort(ssl ? PortName.HTTPS : PortName.HTTP, ssl ? Protocol.HTTPS : Protocol.HTTP, wini.get((Object)"default", "http.port"));
        }
        catch (Exception e) {
            LOGGER.warn("Unable to parse app.conf: " + e.getMessage());
        }
    }

    private void addPort(PortName portName, Protocol protocol, String portNumber) {
        try {
            this.ports.put(portName, Port.of(Integer.parseInt(portNumber) + "/" + (Object)((Object)protocol)));
        }
        catch (Exception e) {
            LOGGER.warn("Invalid port definition in app.conf (" + portName + " -> " + portNumber + "): " + e.getMessage());
        }
    }

    public Map<PortName, Port> getPorts() {
        return this.ports;
    }
}

