/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.util.CollectionUtils;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot.SpringBootConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot.SpringBootPayload;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class SpringBootRamDiskBuilder
extends JarRamDiskBuilder<SpringBootPayload> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootRamDiskBuilder.class);
    private SpringBootConfig springBootConfig;

    public SpringBootRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
    }

    @Override
    protected void doAdjustSpecBasedOnConfig() {
        Properties config = this.getDefaultConfig();
        this.loadPropFile(config, "application.properties");
        this.loadYamlFile(config, "application.yml");
        this.loadPropFile(config, "application-default.properties");
        this.loadYamlFile(config, "application-default.yml");
        if (((SpringBootPayload)this.payload).getType() == PayloadType.JHIPSTER) {
            this.loadPropFile(config, "application-prod.properties");
            this.loadYamlFile(config, "application-prod.yml");
        } else {
            this.loadPropFile(config, "application-boxfuse.properties");
            this.loadYamlFile(config, "application-boxfuse.yml");
        }
        this.loadPropFile(config, "config/application.properties");
        this.loadYamlFile(config, "config/application.yml");
        this.loadPropFile(config, "config/application-default.properties");
        this.loadYamlFile(config, "config/application-default.yml");
        if (((SpringBootPayload)this.payload).getType() == PayloadType.JHIPSTER) {
            this.loadPropFile(config, "config/application-prod.properties");
            this.loadYamlFile(config, "config/application-prod.yml");
        } else {
            this.loadPropFile(config, "config/application-boxfuse.properties");
            this.loadYamlFile(config, "config/application-boxfuse.yml");
        }
        boolean actuator = ((SpringBootPayload)this.payload).hasActuator();
        if (actuator && !this.messagesDisplayed) {
            LOGGER.debug("Found Spring Boot Actuator");
        }
        this.springBootConfig = new SpringBootConfig(config, actuator, ((SpringBootPayload)this.payload).isSpringBoot1());
        this.autoConfigurePorts(this.springBootConfig.getPorts());
        if (this.spec.getPayloadPort() == null) {
            this.spec.setPayloadPort(this.springBootConfig.getPayloadPort());
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured payload port to " + this.spec.getPayloadPort());
            }
        }
        if (this.spec.getPayloadPath() == null) {
            this.spec.setPayloadPath(this.springBootConfig.getPayloadPath());
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured payload path to " + this.spec.getPayloadPath());
            }
        }
        if (this.spec.getHealthcheckPort() == null && ((SpringBootPayload)this.payload).getType() != PayloadType.JHIPSTER) {
            this.spec.setHealthcheckPort(this.springBootConfig.getHealthcheckPort());
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured healthcheck port to " + this.spec.getHealthcheckPort());
            }
        }
        if (this.spec.getHealthcheckPath() == null && ((SpringBootPayload)this.payload).getType() != PayloadType.JHIPSTER) {
            this.spec.setHealthcheckPath(this.springBootConfig.getHealthcheckPath());
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured healthcheck path to " + this.spec.getHealthcheckPath());
            }
        }
        super.doAdjustSpecBasedOnConfig();
    }

    private Properties getDefaultConfig() {
        Properties config = new Properties();
        if (this.spec.getTlsType() == TlsType.ACM) {
            config.setProperty("server.port", "443");
            config.setProperty("server.ssl.enabled", "true");
            config.setProperty("server.ssl.key-store", "/app-config/boxfuse-selfsigned.jks");
            config.setProperty("server.ssl.key-store-password", "boxfuse-selfsigned");
        } else {
            config.setProperty("server.port", "8080");
        }
        return config;
    }

    @Override
    protected String getMainClass() {
        return ((SpringBootPayload)this.payload).getMainClass();
    }

    private void loadPropFile(Properties config, String propFile) {
        String applicationProperties = ((SpringBootPayload)this.payload).getConfigFile(propFile);
        if (applicationProperties != null) {
            LOGGER.debug("Found " + propFile + " in jar file");
            try {
                config.load(new StringReader(applicationProperties));
            }
            catch (IOException e) {
                LOGGER.warn("Unable to read " + propFile + ": " + e.getMessage());
            }
        }
    }

    private void loadYamlFile(Properties config, String yamlFile) {
        String applicationYml = ((SpringBootPayload)this.payload).getConfigFile(yamlFile);
        if (applicationYml != null) {
            LOGGER.debug("Found " + yamlFile + " in jar file");
            try {
                SpringBootRamDiskBuilder.loadYamlIntoProperties(config, applicationYml);
            }
            catch (YAMLException e) {
                LOGGER.warn("Unable to read " + yamlFile + ": " + e.getMessage());
            }
        }
    }

    static void loadYamlIntoProperties(Properties config, String applicationYml) {
        Iterator<Object> yamls = new Yaml().loadAll(applicationYml).iterator();
        LinkedHashMap<String, String> defaultProfile = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> boxfuseProfile = new LinkedHashMap<String, String>();
        while (yamls.hasNext()) {
            Map yml = (Map)yamls.next();
            if (yml == null) continue;
            Map<String, String> flat = CollectionUtils.flattenMap(yml);
            String profile = flat.get("spring.profiles");
            if (profile == null || "default".equals(profile)) {
                defaultProfile.putAll(flat);
                continue;
            }
            if (!"boxfuse".equals(profile)) continue;
            boxfuseProfile.putAll(flat);
        }
        config.putAll((Map<?, ?>)defaultProfile);
        config.putAll((Map<?, ?>)boxfuseProfile);
    }

    @Override
    protected void adjustEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        super.adjustEnvVars(envVars);
        String activeSpringProfile = ((SpringBootPayload)this.payload).getType() == PayloadType.JHIPSTER ? "prod" : "boxfuse";
        this.putIfAbsent(envVars, EnvVarName.of("SPRING_PROFILES_ACTIVE"), EnvVarValue.asIs(activeSpringProfile));
        this.putIfAbsent(envVars, EnvVarName.of("MANAGEMENT_HEALTH_DISKSPACE_PATH"), EnvVarValue.asIs("/tmp"));
        this.putIfAbsent(envVars, EnvVarName.of("SERVER_SSL_ENABLED"), EnvVarValue.asIs("" + this.springBootConfig.isSslEnabled()));
        this.putIfAbsent(envVars, EnvVarName.of("SERVER_SSL_KEY_STORE"), EnvVarValue.asIs(this.springBootConfig.getSslKeyStore()));
        this.putIfAbsent(envVars, EnvVarName.of("SERVER_SSL_KEY_STORE_PASSWORD"), EnvVarValue.asIs(this.springBootConfig.getSslKeyStorePassword()));
        if (PortName.HTTPS.equals(this.spec.getPayloadPort()) || PortName.HTTP.equals(this.spec.getPayloadPort())) {
            this.putIfAbsent(envVars, EnvVarName.of("SERVER_PORT"), EnvVarValue.flexi("$BOXFUSE_PORTS_" + this.spec.getPayloadPort().getName().toUpperCase(Locale.ENGLISH)));
        }
    }

    @Override
    protected void addAdditionalPreCmds(List<String> preCmds) {
        super.addAdditionalPreCmds(preCmds);
        if (this.spec.getDbType() != null && DbType.NONE != this.spec.getDbType()) {
            preCmds.add("export SPRING_DATASOURCE_URL=$BOXFUSE_DATABASE_URL\nexport SPRING_DATASOURCE_USERNAME=$BOXFUSE_DATABASE_USER\nexport SPRING_DATASOURCE_PASSWORD=$BOXFUSE_DATABASE_PASSWORD");
        }
        preCmds.add("if [ $BOXFUSE_TMP -eq 0 ]; then\n  export MANAGEMENT_HEALTH_DISKSPACE_ENABLED=false\nfi");
    }
}

