/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.play;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.NewRelicConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.play.PlayConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.play.PlayPayload;
import com.boxfuse.generator.payload.FilePayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayZipPayload
extends FilePayload
implements PlayPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayZipPayload.class);
    private static final String CONFIG_FILE = "/conf/application.conf";
    private static final String CONFIG_FILE_PLAY23 = "/conf//application.conf";
    private static final String SYSCTL_CONF = "conf/sysctl.conf";
    private final boolean customJRE;

    public static boolean supports(String name, PayloadFormat format, Map<String, PayloadEntry> entries, boolean live) {
        return name.endsWith(".zip") && PayloadFormat.ZIP == format && PlayZipPayload.containsPlayJars(name, entries) && !live;
    }

    private static boolean containsPlayJars(String name, Map<String, PayloadEntry> entries) {
        String dirName = name.substring(0, name.lastIndexOf(".zip"));
        for (String entry : entries.keySet()) {
            if (!entry.startsWith(dirName + "/lib/play.play") && !entry.startsWith(dirName + "/lib/com.typesafe.play.play") && !entry.startsWith(dirName + "/lib/org.playframework.play")) continue;
            return true;
        }
        return false;
    }

    public PlayZipPayload(File file, byte[] bytes, Map<String, PayloadEntry> entries) {
        super(file, bytes, entries);
        this.customJRE = entries.keySet().contains(this.getArchiveDir() + "/" + "conf/jre" + "/bin/java");
    }

    private String getArchiveDir() {
        return this.name.replace(".zip", "");
    }

    @Override
    public PayloadType getType() {
        return PayloadType.PLAY;
    }

    @Override
    public Collection<String> getJavaAgents() {
        String regex = this.getArchiveDir() + "/conf/javaagents/.+\\.jar";
        ArrayList<String> javaAgents = new ArrayList<String>();
        for (String entry : this.entries.keySet()) {
            if (!entry.matches(regex)) continue;
            javaAgents.add("/app/" + entry);
        }
        return javaAgents;
    }

    @Override
    public NewRelicConfig getNewRelicConfig() {
        String config = ZipUtils.unzipSingleEntry(this.bytes, this.getArchiveDir() + "/conf/newrelic.yml");
        if (config == null) {
            return null;
        }
        return new NewRelicConfig(config);
    }

    @Override
    public boolean hasCustomJRE() {
        return this.customJRE;
    }

    @Override
    public byte[] getCACerts() {
        byte[] cacerts = ZipUtils.unzipSingleEntryToByteArray(this.bytes, this.getArchiveDir() + "/conf/cacerts");
        if (cacerts == null && this.customJRE) {
            cacerts = ZipUtils.unzipSingleEntryToByteArray(this.bytes, this.getArchiveDir() + "/" + "conf/jre" + "/lib/security/cacerts");
        }
        return cacerts;
    }

    @Override
    public byte[] getLocalPolicyJar() {
        return ZipUtils.unzipSingleEntryToByteArray(this.bytes, this.getArchiveDir() + "/conf/local_policy.jar");
    }

    @Override
    public byte[] getUsExportPolicyJar() {
        return ZipUtils.unzipSingleEntryToByteArray(this.bytes, this.getArchiveDir() + "/conf/US_export_policy.jar");
    }

    @Override
    public DbType detectDbType() {
        for (DbType dbType : DbType.values()) {
            if (DbType.NONE == dbType || StringUtils.findFirstMatching(this.entries.keySet(), this.getArchiveDir() + "/lib/" + dbType.getJdbcDriverJarRegex()) == null) continue;
            return dbType;
        }
        return DbType.NONE;
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        if (this.entries.keySet().contains(SYSCTL_CONF)) {
            return Pair.of(SYSCTL_CONF, null);
        }
        return null;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        ramDisk.installZipArchive(this.bytes, baseDir, null, null, true, ".*\\." + Pattern.quote("jmxremote.password"));
    }

    @Override
    public PlayConfig getApplicationConf(TlsType tlsType) {
        String conf = "";
        if (this.entries.keySet().contains(this.getArchiveDir() + CONFIG_FILE)) {
            conf = ZipUtils.unzipSingleEntry(this.bytes, this.getArchiveDir() + CONFIG_FILE);
            LOGGER.debug("Found application.conf in zip file");
        } else if (this.entries.keySet().contains(this.getArchiveDir() + CONFIG_FILE_PLAY23)) {
            conf = ZipUtils.unzipSingleEntry(this.bytes, this.getArchiveDir() + CONFIG_FILE_PLAY23);
            LOGGER.debug("Found application.conf in zip file");
        } else {
            LOGGER.debug("Unable to find application.conf in zip file => using defaults");
        }
        return new PlayConfig(tlsType, conf);
    }

    @Override
    public String getDirPrefix() {
        return "/" + this.getArchiveDir();
    }
}

