/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.tomcat.tomee;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.TomcatRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.tomee.TomeePayload;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

public class TomeeRamDiskBuilder
extends TomcatRamDiskBuilder<TomeePayload> {
    private static final String DEFAULT_TOMEE_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tomee></tomee>";
    private static final String DATASOURCE_TOMEE_XML_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tomee>\n<Resource id=\"boxfuseDatabase\" type=\"DataSource\" classpath=\"%s\">\n    JdbcDriver  %s\n    JdbcUrl     ${BOXFUSE_DATABASE_URL}\n    UserName    ${BOXFUSE_DATABASE_USER}\n    Password    ${BOXFUSE_DATABASE_PASSWORD}\n</Resource>\n</tomee>";
    private static final String TOMEE_INCLUDE_REGEX = "^bin/.+\\.jar$|^conf/catalina\\..+$|^conf/logging\\.properties$|^lib/.+\\.jar$|LICENSE|NOTICE|^conf/system\\.properties$|^endorsed/.+\\.jar$";

    public TomeeRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
    }

    @Override
    protected Component getTomcatComponent() {
        return this.getComponent(this.requiresTomeePlus() ? ComponentId.TOMEE_PLUS : ComponentId.TOMEE_WEBPROFILE);
    }

    @Override
    protected String getIncludeRegex() {
        return TOMEE_INCLUDE_REGEX;
    }

    @Override
    protected String getBaseArchiveDirPrefix() {
        return this.tomcatComponent.getId() == ComponentId.TOMEE_WEBPROFILE ? "apache-tomee-webprofile-" : "apache-tomee-plus-";
    }

    private boolean requiresTomeePlus() {
        String xml = ((TomeePayload)this.payload).getResourcesXml();
        return xml != null && (xml.contains("type=\"MESSAGE\"") || xml.contains("javax.jms") || xml.contains("ActiveMQResourceAdapter"));
    }

    @Override
    protected void installPayloadWithDependencies() throws IOException {
        String tomeeXml;
        super.installPayloadWithDependencies();
        DbType dbType = this.spec.getDbType();
        if (dbType == DbType.NONE) {
            tomeeXml = DEFAULT_TOMEE_XML;
        } else {
            String jdbcDriverJar = "/tomcat/webapps/ROOT/" + StringUtils.findFirstMatching(((TomeePayload)this.payload).getEntries().keySet(), Pattern.quote("WEB-INF/lib/") + dbType.getJdbcDriverJarRegex());
            tomeeXml = String.format(DATASOURCE_TOMEE_XML_TEMPLATE, jdbcDriverJar, dbType.getJdbcDriverClass());
        }
        this.ramDisk.createFile("tomcat/conf/tomee.xml", false, tomeeXml);
    }

    @Override
    protected Collection<String> getRuntimeJavaAgents() {
        return Collections.singletonList("/tomcat/lib/openejb-javaagent.jar");
    }

    @Override
    protected String computeJvmExtraArgs() {
        return super.computeJvmExtraArgs() + " -Dorg.apache.activemq.default.directory.prefix=/tmp/";
    }

    @Override
    protected String getServerXmlTemplate() {
        return "generator/tomee/server.xml";
    }

    @Override
    protected boolean isTomcat7() {
        return this.tomcatComponent.getVersion().getVersion().startsWith("1.7");
    }
}

