/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.payload;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.StopWatch;
import com.boxfuse.base.util.TimeFormat;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.generator.builder.ramdisk.generic.GenericELF64Payload;
import com.boxfuse.generator.builder.ramdisk.generic.GenericTarGzPayload;
import com.boxfuse.generator.builder.ramdisk.generic.go.revel.RevelTarGzPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarDirectoyPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarJarPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard.DropwizardDirectoryPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.dropwizard.DropwizardJarPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot.SpringBootDirectoryPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot.SpringBootJarWarPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.play.PlayDirectoryPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.play.PlayZipPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.TomcatDirectoryPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.TomcatWarPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.tomee.TomeeDirectoryPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.tomee.TomeeWarPayload;
import com.boxfuse.generator.builder.ramdisk.nodejs.NodeJsDirectoryPayload;
import com.boxfuse.generator.builder.ramdisk.nodejs.NodeJsTgzPayload;
import com.boxfuse.generator.payload.Payload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PayloadFactory.class);
    private static final String VALID_PAYLOAD_TYPES_MSG = " => must be a Linux x64 (tar.gz), Go (ELF64 binary), Revel (tar.gz), Node.js (tgz), Spring Boot (jar or war), Grails (jar or war), Play (zip), Dropwizard (jar), Tomcat (war), TomEE (war) or executable jar application";
    private static final String VALID_LIVE_PAYLOAD_TYPES_MSG = " => must be a Revel (unpacked tar.gz), Node.js (directory), Spring Boot (unpacked jar), Grails (unpacked jar), Play (unpacked zip), Dropwizard (unpacked jar), Tomcat (exploded war), TomEE (exploded war) or executable jar (unpacked jar) application";
    private static final int MAX_PAYLOAD_SIZE_IN_MB = 1024;
    private static final int MAX_PAYLOAD_SIZE = 0x40000000;
    private static final int MIN_GO_ELF64_SIZE = 614400;
    private static final int MAX_ENTRY_COUNT = 1000000;

    private PayloadFactory() {
    }

    public static Payload findFirstPayload(File dir, boolean live) {
        Payload payload = null;
        String[] list = dir.list();
        if (list != null) {
            HashSet<String> fileNames = new HashSet<String>(Arrays.asList(list));
            if (fileNames.contains("pom.xml") && fileNames.contains("target")) {
                LOGGER.debug("Found Maven project. Searching for payloads in target directory ...");
                payload = PayloadFactory.findFirstPayloadInDir(new File(dir, "target"), live);
            } else if (fileNames.contains("build.gradle") && fileNames.contains("build")) {
                LOGGER.debug("Found Gradle project. Searching for payloads in build directory ...");
                payload = PayloadFactory.findFirstPayloadInDir(new File(new File(dir, "build"), "libs"), live);
            } else if (fileNames.contains("project") && fileNames.contains("target")) {
                LOGGER.debug("Found Play project. Searching for payloads in target/universal directory ...");
                payload = PayloadFactory.findFirstPayloadInDir(new File(new File(dir, "target"), "universal"), live);
            }
        }
        if (payload == null) {
            LOGGER.debug("Searching for payloads in current directory ...");
            payload = PayloadFactory.findFirstPayloadInDir(dir, live);
        }
        if (payload != null) {
            LOGGER.debug("Found payload: " + payload.getFile().getAbsolutePath());
        }
        return payload;
    }

    private static Payload findFirstPayloadInDir(File dir, boolean live) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(dir);
        File[] entries = dir.listFiles(file -> file.canRead() && (file.isFile() || file.isDirectory() && PayloadFactory.isPayloadDirectoryName(file.getName())));
        if (entries != null) {
            files.addAll(Arrays.asList(entries));
        }
        files.sort((o1, o2) -> {
            if (o1.isFile() && o2.isFile()) {
                long l2;
                long l1 = o1.length();
                if (l1 < (l2 = o2.length())) {
                    return 1;
                }
                if (l1 > l2) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isDirectory() && o2.isDirectory()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isDirectory()) {
                return 1;
            }
            return -1;
        });
        for (File file2 : files) {
            try {
                return PayloadFactory.toPayload(file2.getAbsolutePath(), live);
            }
            catch (BoxfuseException e) {
                LOGGER.debug("Skipping invalid payload: " + file2.getAbsolutePath() + " (" + e.getMessage() + ")");
            }
        }
        return null;
    }

    public static Payload toPayload(String payloadLocation, boolean live) {
        File file;
        String name;
        if (payloadLocation.startsWith("http://") || payloadLocation.startsWith("https://")) {
            try {
                URL url = new URL(payloadLocation);
                name = payloadLocation.substring(payloadLocation.lastIndexOf("/") + 1);
                LOGGER.info("Downloading payload " + url.toExternalForm() + " ...");
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                try {
                    file = File.createTempFile("boxdl", "" + System.currentTimeMillis());
                    IOUtils.copy(url.openStream(), file);
                }
                catch (IOException e) {
                    throw new BoxfuseException("Unable to download Payload: " + url, e);
                }
                stopWatch.stop();
                long sizeInKB = file.length() / 1024L;
                String time = TimeFormat.format(stopWatch.getTotalTimeMillis());
                LOGGER.info("Payload downloaded in " + time + " (" + sizeInKB + " KB)");
            }
            catch (MalformedURLException e) {
                throw new BoxfuseException("Invalid Payload URL: " + payloadLocation, e);
            }
        }
        file = new File(payloadLocation);
        name = file.getName();
        if (!file.exists()) {
            throw new BoxfuseException("Payload not found: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new BoxfuseException("Unable to read Payload: " + file.getAbsolutePath());
        }
        byte[] bytes = null;
        Map<String, PayloadEntry> entries = null;
        long payloadSize = 0L;
        PayloadFormat format = null;
        if (file.isDirectory()) {
            format = PayloadFormat.DIRECTORY;
            Pair<AtomicLong, Map<String, PayloadEntry>> dirResult = PayloadFactory.listDirectoryRecursively(file, "");
            payloadSize = dirResult.getLeft().get();
            entries = dirResult.getRight();
            if (payloadSize > 0x40000000L) {
                throw new BoxfuseException("Maximum payload size of 1024 MB exceeded for Payload: " + name + " => pick a different payload to fuse");
            }
            if (entries.size() > 1000000) {
                throw new BoxfuseException("Maximum file count of 1000000 exceeded for Payload: " + name + " => pick a different payload to fuse");
            }
        } else if (file.isFile()) {
            payloadSize = file.length();
            if (payloadSize == 0L) {
                throw new BoxfuseException("Payload is empty: " + name + " => pick a different payload to fuse");
            }
            if (payloadSize > 0x40000000L) {
                throw new BoxfuseException("Maximum payload size of 1024 MB exceeded for Payload: " + name + " => pick a different payload to fuse");
            }
            bytes = IOUtils.copyToByteArray(file);
            if ((name.endsWith(".tgz") || name.endsWith(".tar.gz")) && PayloadFactory.isPayloadFileName(file.getName())) {
                format = PayloadFormat.TARGZ;
                entries = ZipUtils.listTarGzEntries(bytes);
            } else if ((name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".war")) && PayloadFactory.isPayloadFileName(file.getName())) {
                bytes = PayloadFactory.stripShellScriptIfNecessary(bytes);
                format = PayloadFormat.ZIP;
                entries = ZipUtils.listEntries(bytes);
            } else if (file.length() > 614400L && PayloadFactory.isElf64(bytes) && file.canExecute()) {
                format = PayloadFormat.ELF64;
                entries = new TreeMap<String, PayloadEntry>();
            }
        }
        if (format == null) {
            throw new BoxfuseException("Unsupported payload (unknown format): " + name + VALID_PAYLOAD_TYPES_MSG);
        }
        if (PayloadFormat.ELF64 != format && entries.isEmpty()) {
            throw new BoxfuseException("Invalid payload (unreadable or empty): " + name + VALID_PAYLOAD_TYPES_MSG);
        }
        if (RevelTarGzPayload.supports(name, format, entries, live)) {
            return new RevelTarGzPayload(file, bytes, entries);
        }
        if (NodeJsTgzPayload.supports(name, format, entries, live)) {
            return new NodeJsTgzPayload(file, bytes, entries);
        }
        if (NodeJsDirectoryPayload.supports(format, file, entries)) {
            return new NodeJsDirectoryPayload(file, payloadSize, entries, live);
        }
        if (SpringBootJarWarPayload.supports(name, format, bytes, entries, live)) {
            return new SpringBootJarWarPayload(file, bytes, entries);
        }
        if (SpringBootDirectoryPayload.supports(format, entries)) {
            return new SpringBootDirectoryPayload(file, payloadSize, entries, live);
        }
        if (TomeeWarPayload.supports(name, format, entries, live)) {
            return new TomeeWarPayload(file, bytes, entries);
        }
        if (TomeeDirectoryPayload.supports(format, entries)) {
            return new TomeeDirectoryPayload(file, payloadSize, entries, live);
        }
        if (TomcatWarPayload.supports(name, format, live)) {
            return new TomcatWarPayload(file, bytes, entries);
        }
        if (TomcatDirectoryPayload.supports(format, entries)) {
            return new TomcatDirectoryPayload(file, payloadSize, entries, live);
        }
        if (PlayZipPayload.supports(name, format, entries, live)) {
            return new PlayZipPayload(file, bytes, entries);
        }
        if (PlayDirectoryPayload.supports(format, entries)) {
            return new PlayDirectoryPayload(file, payloadSize, entries, live);
        }
        if (DropwizardJarPayload.supports(name, format, entries, live)) {
            return new DropwizardJarPayload(file, bytes, entries);
        }
        if (DropwizardDirectoryPayload.supports(format, entries)) {
            return new DropwizardDirectoryPayload(file, payloadSize, entries, live);
        }
        if (JarJarPayload.supports(name, format, live)) {
            return new JarJarPayload(file, bytes, entries);
        }
        if (JarDirectoyPayload.supports(format, entries)) {
            return new JarDirectoyPayload(file, payloadSize, entries, live);
        }
        if (GenericTarGzPayload.supports(format, entries, live)) {
            return new GenericTarGzPayload(file, bytes, entries);
        }
        if (GenericELF64Payload.supports(format, live)) {
            return new GenericELF64Payload(file, bytes, entries);
        }
        throw new BoxfuseException("Unsupported " + (live ? "live " : "") + "payload: " + name + (live ? VALID_LIVE_PAYLOAD_TYPES_MSG : VALID_PAYLOAD_TYPES_MSG));
    }

    private static byte[] stripShellScriptIfNecessary(byte[] bytes) {
        if (bytes[0] == 35 && bytes[1] == 33) {
            int pos = PayloadFactory.indexOf(bytes, new byte[]{101, 120, 105, 116, 32, 48, 10, 80, 75});
            return Arrays.copyOfRange(bytes, pos += 7, bytes.length);
        }
        return bytes;
    }

    private static int indexOf(byte[] outerArray, byte[] smallerArray) {
        for (int i2 = 0; i2 < outerArray.length - smallerArray.length + 1; ++i2) {
            boolean found = true;
            for (int j = 0; j < smallerArray.length; ++j) {
                if (outerArray[i2 + j] == smallerArray[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i2;
        }
        return -1;
    }

    static boolean isElf64(byte[] bytes) {
        return bytes[0] == 127 && bytes[1] == 69 && bytes[2] == 76 && bytes[3] == 70 && bytes[4] == 2 && bytes[5] == 1 && bytes[6] == 1 && bytes[16] == 2 && bytes[17] == 0 && bytes[18] == 62 && bytes[19] == 0 && bytes[20] == 1;
    }

    private static Pair<AtomicLong, Map<String, PayloadEntry>> listDirectoryRecursively(File dir, String root) {
        AtomicLong totalSize = new AtomicLong(0L);
        TreeMap<String, PayloadEntry> entries = new TreeMap<String, PayloadEntry>();
        Pair<AtomicLong, Map<String, PayloadEntry>> result = Pair.of(totalSize, entries);
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    Pair<AtomicLong, Map<String, PayloadEntry>> dirResult = PayloadFactory.listDirectoryRecursively(f, root + f.getName() + "/");
                    totalSize.addAndGet(dirResult.getLeft().get());
                    entries.putAll(dirResult.getRight());
                } else if (f.isFile()) {
                    totalSize.addAndGet(f.length());
                    String name = root + f.getName();
                    entries.put(name, new PayloadEntry(name, f.canExecute()));
                }
                if (totalSize.get() > 0x40000000L) {
                    return result;
                }
                if (entries.size() <= 1000000) continue;
                return result;
            }
        }
        return result;
    }

    static boolean isPayloadFileName(String name) {
        return (name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".zip") || name.endsWith(".tgz") || name.endsWith(".tar.gz")) && !name.endsWith("-sources.jar") && !name.endsWith("-javadoc.jar") && !name.matches("activator-launch-.*\\.jar");
    }

    private static boolean isPayloadDirectoryName(String name) {
        return !name.equals(".git") && !name.equals(".idea") && !name.equals("node_modules");
    }
}

