/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Parser;
import com.typesafe.config.impl.PathBuilder;
import java.util.Iterator;
import java.util.List;

final class Path {
    private final String first;
    private final Path remainder;

    Path(String first, Path remainder) {
        this.first = first;
        this.remainder = remainder;
    }

    Path(String ... elements) {
        if (elements.length == 0) {
            throw new ConfigException.BugOrBroken("empty path");
        }
        this.first = elements[0];
        if (elements.length > 1) {
            PathBuilder pb = new PathBuilder();
            for (int i2 = 1; i2 < elements.length; ++i2) {
                pb.appendKey(elements[i2]);
            }
            this.remainder = pb.result();
        } else {
            this.remainder = null;
        }
    }

    Path(List<Path> pathsToConcat) {
        this(pathsToConcat.iterator());
    }

    Path(Iterator<Path> i2) {
        if (!i2.hasNext()) {
            throw new ConfigException.BugOrBroken("empty path");
        }
        Path firstPath = i2.next();
        this.first = firstPath.first;
        PathBuilder pb = new PathBuilder();
        if (firstPath.remainder != null) {
            pb.appendPath(firstPath.remainder);
        }
        while (i2.hasNext()) {
            pb.appendPath(i2.next());
        }
        this.remainder = pb.result();
    }

    String first() {
        return this.first;
    }

    Path remainder() {
        return this.remainder;
    }

    Path parent() {
        if (this.remainder == null) {
            return null;
        }
        PathBuilder pb = new PathBuilder();
        Path p = this;
        while (p.remainder != null) {
            pb.appendKey(p.first);
            p = p.remainder;
        }
        return pb.result();
    }

    String last() {
        Path p = this;
        while (p.remainder != null) {
            p = p.remainder;
        }
        return p.first;
    }

    Path prepend(Path toPrepend) {
        PathBuilder pb = new PathBuilder();
        pb.appendPath(toPrepend);
        pb.appendPath(this);
        return pb.result();
    }

    int length() {
        int count = 1;
        Path p = this.remainder;
        while (p != null) {
            ++count;
            p = p.remainder;
        }
        return count;
    }

    Path subPath(int removeFromFront) {
        Path p = this;
        for (int count = removeFromFront; p != null && count > 0; --count) {
            p = p.remainder;
        }
        return p;
    }

    Path subPath(int firstIndex, int lastIndex) {
        if (lastIndex < firstIndex) {
            throw new ConfigException.BugOrBroken("bad call to subPath");
        }
        Path from = this.subPath(firstIndex);
        PathBuilder pb = new PathBuilder();
        for (int count = lastIndex - firstIndex; count > 0; --count) {
            pb.appendKey(from.first());
            if ((from = from.remainder()) != null) continue;
            throw new ConfigException.BugOrBroken("subPath lastIndex out of range " + lastIndex);
        }
        return pb.result();
    }

    public boolean equals(Object other) {
        if (other instanceof Path) {
            Path that = (Path)other;
            return this.first.equals(that.first) && ConfigImplUtil.equalsHandlingNull(this.remainder, that.remainder);
        }
        return false;
    }

    public int hashCode() {
        return 41 * (41 + this.first.hashCode()) + (this.remainder == null ? 0 : this.remainder.hashCode());
    }

    static boolean hasFunkyChars(String s) {
        int length = s.length();
        if (length == 0) {
            return false;
        }
        char first = s.charAt(0);
        if (!Character.isLetter(first)) {
            return true;
        }
        for (int i2 = 1; i2 < length; ++i2) {
            char c = s.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
            return true;
        }
        return false;
    }

    private void appendToStringBuilder(StringBuilder sb) {
        if (Path.hasFunkyChars(this.first) || this.first.isEmpty()) {
            sb.append(ConfigImplUtil.renderJsonString(this.first));
        } else {
            sb.append(this.first);
        }
        if (this.remainder != null) {
            sb.append(".");
            this.remainder.appendToStringBuilder(sb);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Path(");
        this.appendToStringBuilder(sb);
        sb.append(")");
        return sb.toString();
    }

    String render() {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb);
        return sb.toString();
    }

    static Path newKey(String key) {
        return new Path(key, null);
    }

    static Path newPath(String path) {
        return Parser.parsePath(path);
    }
}

