/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.fsimage.cpio;

import com.boxfuse.base.fsimage.FsFile;
import com.boxfuse.base.fsimage.FsFileMode;
import com.boxfuse.base.fsimage.FsFileType;
import com.boxfuse.base.fsimage.FsImage;
import com.boxfuse.base.fsimage.FsPath;
import com.boxfuse.base.fsimage.cpio.CpioFsFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001.B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J0\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016Jg\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010$J0\u0010%\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010&\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010'\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\rH\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010*\u001a\u00020\u0002H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020,2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010-\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/boxfuse/base/fsimage/cpio/WriteOnlyCpioFsImage;", "Lcom/boxfuse/base/fsimage/FsImage;", "Lcom/boxfuse/base/fsimage/cpio/CpioFsFile;", "Ljava/lang/AutoCloseable;", "outputStream", "Ljava/io/OutputStream;", "createTime", "Ljava/time/Instant;", "(Ljava/io/OutputStream;Ljava/time/Instant;)V", "cpio", "Lorg/apache/commons/compress/archivers/cpio/CpioArchiveOutputStream;", "files", "", "Lcom/boxfuse/base/fsimage/FsPath;", "close", "", "createBlockDevice", "directory", "name", "", "major", "", "minor", "mode", "Lcom/boxfuse/base/fsimage/FsFileMode;", "createCharacterDevice", "createDirectory", "createFifo", "createFile", "type", "Lcom/boxfuse/base/fsimage/FsFileType;", "size", "", "data", "Ljava/io/InputStream;", "destination", "(Lcom/boxfuse/base/fsimage/cpio/CpioFsFile;Ljava/lang/String;Lcom/boxfuse/base/fsimage/FsFileType;Lcom/boxfuse/base/fsimage/FsFileMode;JLjava/io/InputStream;Ljava/lang/String;Ljava/lang/Byte;Ljava/lang/Byte;)Lcom/boxfuse/base/fsimage/cpio/CpioFsFile;", "createRegularFile", "createSocket", "createSymbolicLink", "getFile", "path", "getRootDirectory", "listDirectory", "", "toCpioMode", "Companion", "boxfuse-base-fsimage"})
public final class WriteOnlyCpioFsImage
implements FsImage<CpioFsFile>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant createTime;
    @NotNull
    private final CpioArchiveOutputStream cpio;
    @NotNull
    private final Map<FsPath, CpioFsFile> files;
    private static final short CPIO_FORMAT = 1;

    public WriteOnlyCpioFsImage(@NotNull OutputStream outputStream, @NotNull Instant createTime) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)createTime, (String)"createTime");
        this.createTime = createTime;
        this.cpio = new CpioArchiveOutputStream(outputStream, 1);
        boolean bl = false;
        this.files = new LinkedHashMap();
    }

    public /* synthetic */ WriteOnlyCpioFsImage(OutputStream outputStream, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
            instant = instant2;
        }
        this(outputStream, instant);
    }

    @Override
    @NotNull
    public CpioFsFile getRootDirectory() {
        return new CpioFsFile(new FsPath("/"), FsFileType.DIRECTORY, FsFileMode.Companion.getRX(), 0L, null, null, null);
    }

    @Override
    @NotNull
    public CpioFsFile getFile(@NotNull FsPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Map<FsPath, CpioFsFile> map = this.files;
        boolean bl = false;
        CpioFsFile cpioFsFile = map.get(path);
        if (cpioFsFile == null) {
            boolean bl2 = false;
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown file: ", (Object)path));
        }
        return cpioFsFile;
    }

    @Override
    @NotNull
    public CpioFsFile getFile(@NotNull CpioFsFile directory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean bl = directory.getType() == FsFileType.DIRECTORY;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = directory.getPath() + " is not a directory";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.getFile(directory.getPath().getChild(name));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CpioFsFile> listDirectory(@NotNull CpioFsFile directory) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        boolean bl = directory.getType() == FsFileType.DIRECTORY;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = directory.getPath() + " is not a directory";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Map<FsPath, CpioFsFile> $this$filter$iv = this.files;
        boolean $i$f$filter = false;
        Map<FsPath, CpioFsFile> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_11 = $this$filterTo$iv$iv;
        boolean bl5 = false;
        Iterator iterator = var7_11.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl6 = false;
            if (!Intrinsics.areEqual((Object)((FsPath)it.getKey()).getParent(), (Object)directory.getPath())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }

    @Override
    @NotNull
    public CpioFsFile createRegularFile(@NotNull CpioFsFile directory, @NotNull String name, long size, @NotNull InputStream data, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        boolean bl = size >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return WriteOnlyCpioFsImage.createFile$default(this, directory, name, FsFileType.REGULAR_FILE, mode, size, data, null, null, null, 448, null);
    }

    @Override
    @NotNull
    public CpioFsFile createDirectory(@NotNull CpioFsFile directory, @NotNull String name, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return WriteOnlyCpioFsImage.createFile$default(this, directory, name, FsFileType.DIRECTORY, mode, 0L, null, null, null, null, 496, null);
    }

    @Override
    @NotNull
    public CpioFsFile createSymbolicLink(@NotNull CpioFsFile directory, @NotNull String name, @NotNull String destination, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        CharSequence charSequence = destination;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        bl = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = destination;
        Charset charset = Charsets.UTF_8;
        bl4 = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] destinationBytes = byArray;
        long size = destinationBytes.length;
        byte[] byArray2 = destinationBytes;
        boolean bl6 = false;
        return WriteOnlyCpioFsImage.createFile$default(this, directory, name, FsFileType.SYMBOLIC_LINK, mode, size, new ByteArrayInputStream(byArray2), destination, null, null, 384, null);
    }

    @Override
    @NotNull
    public CpioFsFile createBlockDevice(@NotNull CpioFsFile directory, @NotNull String name, byte major, byte minor, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return WriteOnlyCpioFsImage.createFile$default(this, directory, name, FsFileType.BLOCK_DEVICE, mode, 0L, null, null, major, minor, 112, null);
    }

    @Override
    @NotNull
    public CpioFsFile createCharacterDevice(@NotNull CpioFsFile directory, @NotNull String name, byte major, byte minor, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return WriteOnlyCpioFsImage.createFile$default(this, directory, name, FsFileType.CHARACTER_DEVICE, mode, 0L, null, null, major, minor, 112, null);
    }

    @Override
    @NotNull
    public CpioFsFile createFifo(@NotNull CpioFsFile directory, @NotNull String name, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return WriteOnlyCpioFsImage.createFile$default(this, directory, name, FsFileType.FIFO, mode, 0L, null, null, null, null, 496, null);
    }

    @Override
    @NotNull
    public CpioFsFile createSocket(@NotNull CpioFsFile directory, @NotNull String name, @NotNull FsFileMode mode) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return WriteOnlyCpioFsImage.createFile$default(this, directory, name, FsFileType.SOCKET, mode, 0L, null, null, null, null, 496, null);
    }

    @Override
    public void close() {
        this.cpio.close();
    }

    private final CpioFsFile createFile(CpioFsFile directory, String name, FsFileType type, FsFileMode mode, long size, InputStream data, String destination, Byte major, Byte minor) {
        boolean bl = directory.getType() == FsFileType.DIRECTORY;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = directory.getPath() + " is not a directory";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        FsPath path = directory.getPath().getChild(name);
        CpioArchiveEntry entry = new CpioArchiveEntry(1, Companion.toCpioPath$boxfuse_base_fsimage(path));
        entry.setMode(this.toCpioMode(type, mode));
        entry.setSize(size);
        entry.setTime(this.createTime.getEpochSecond());
        if (major != null) {
            entry.setRemoteDeviceMaj((long)major.byteValue());
        }
        if (minor != null) {
            entry.setRemoteDeviceMin((long)minor.byteValue());
        }
        this.cpio.putArchiveEntry((ArchiveEntry)entry);
        if (data != null) {
            long consumed = 0L;
            byte[] copyBuffer = new byte[4096];
            int read = 0;
            do {
                if ((read = data.read(copyBuffer)) < 0) continue;
                this.cpio.write(copyBuffer, 0, read);
                consumed += (long)read;
            } while (read >= 0 && consumed < size);
        }
        this.cpio.closeArchiveEntry();
        CpioFsFile file = new CpioFsFile(path, type, mode, size, destination, major, minor);
        Map<FsPath, CpioFsFile> map = this.files;
        boolean bl5 = false;
        map.put(path, file);
        return file;
    }

    static /* synthetic */ CpioFsFile createFile$default(WriteOnlyCpioFsImage writeOnlyCpioFsImage, CpioFsFile cpioFsFile, String string, FsFileType fsFileType, FsFileMode fsFileMode, long l, InputStream inputStream, String string2, Byte by, Byte by2, int n, Object object) {
        if ((n & 0x10) != 0) {
            l = 0L;
        }
        if ((n & 0x20) != 0) {
            inputStream = null;
        }
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            by = null;
        }
        if ((n & 0x100) != 0) {
            by2 = null;
        }
        return writeOnlyCpioFsImage.createFile(cpioFsFile, string, fsFileType, fsFileMode, l, inputStream, string2, by, by2);
    }

    private final long toCpioMode(FsFileType type, FsFileMode mode) {
        int n;
        FsFileType fsFileType = type;
        int n2 = WhenMappings.$EnumSwitchMapping$0[fsFileType.ordinal()];
        switch (n2) {
            case 1: {
                n = 32768;
                break;
            }
            case 2: {
                n = 16384;
                break;
            }
            case 3: {
                n = 40960;
                break;
            }
            case 4: {
                n = 24576;
                break;
            }
            case 5: {
                n = 8192;
                break;
            }
            case 6: {
                n = 49152;
                break;
            }
            case 7: {
                n = 4096;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int cpioMode = n;
        if (mode.getRusr()) {
            cpioMode |= 0x100;
        }
        if (mode.getWusr()) {
            cpioMode |= 0x80;
        }
        if (mode.getXusr()) {
            cpioMode |= 0x40;
        }
        if (mode.getRgrp()) {
            cpioMode |= 0x20;
        }
        if (mode.getWgrp()) {
            cpioMode |= 0x10;
        }
        if (mode.getXgrp()) {
            cpioMode |= 8;
        }
        if (mode.getRoth()) {
            cpioMode |= 4;
        }
        if (mode.getWoth()) {
            cpioMode |= 2;
        }
        if (mode.getXoth()) {
            cpioMode |= 1;
        }
        return cpioMode;
    }

    @Override
    public <T extends FsFile> void copyTo(@NotNull FsImage<T> target, @NotNull FsPath path) {
        FsImage.DefaultImpls.copyTo(this, target, path);
    }

    @Override
    @NotNull
    public CpioFsFile createFile(@NotNull FsFile file) {
        return FsImage.DefaultImpls.createFile(this, file);
    }

    @Override
    @NotNull
    public CpioFsFile createFile(@NotNull FsPath prefix, @NotNull FsFile file) {
        return (CpioFsFile)((Object)FsImage.DefaultImpls.createFile(this, prefix, file));
    }

    @Override
    @NotNull
    public CpioFsFile createRegularFile(@NotNull CpioFsFile directory, @NotNull String name, @NotNull byte[] data, @NotNull FsFileMode mode) {
        return (CpioFsFile)FsImage.DefaultImpls.createRegularFile(this, (FsFile)directory, name, data, mode);
    }

    @Override
    @NotNull
    public CpioFsFile createRegularFile(@NotNull CpioFsFile directory, @NotNull String name, @NotNull String data, @NotNull FsFileMode mode) {
        return (CpioFsFile)FsImage.DefaultImpls.createRegularFile(this, (FsFile)directory, name, data, mode);
    }

    @Override
    @NotNull
    public CpioFsFile createRegularFile(@NotNull FsFile regularFile, @NotNull InputStream data) {
        return FsImage.DefaultImpls.createRegularFile(this, regularFile, data);
    }

    @Override
    @NotNull
    public CpioFsFile createSymbolicLink(@NotNull CpioFsFile directory, @NotNull String name, @NotNull CpioFsFile destination, @NotNull FsFileMode mode) {
        return (CpioFsFile)FsImage.DefaultImpls.createSymbolicLink(this, (FsFile)directory, name, (FsFile)destination, mode);
    }

    @Override
    @NotNull
    public List<CpioFsFile> listAllFiles() {
        return FsImage.DefaultImpls.listAllFiles(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/boxfuse/base/fsimage/cpio/WriteOnlyCpioFsImage$Companion;", "", "()V", "CPIO_FORMAT", "", "toCpioPath", "", "path", "Lcom/boxfuse/base/fsimage/FsPath;", "toCpioPath$boxfuse_base_fsimage", "boxfuse-base-fsimage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toCpioPath$boxfuse_base_fsimage(@NotNull FsPath path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = path.getAbsolutePath();
            int n = 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FsFileType.values().length];
            nArray[FsFileType.REGULAR_FILE.ordinal()] = 1;
            nArray[FsFileType.DIRECTORY.ordinal()] = 2;
            nArray[FsFileType.SYMBOLIC_LINK.ordinal()] = 3;
            nArray[FsFileType.BLOCK_DEVICE.ordinal()] = 4;
            nArray[FsFileType.CHARACTER_DEVICE.ordinal()] = 5;
            nArray[FsFileType.SOCKET.ordinal()] = 6;
            nArray[FsFileType.FIFO.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

