/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.fsimage.ext2;

import com.boxfuse.base.fsimage.FsFile;
import com.boxfuse.base.fsimage.FsFileMode;
import com.boxfuse.base.fsimage.FsFileType;
import com.boxfuse.base.fsimage.FsPath;
import com.boxfuse.base.fsimage.ext2.Bitmap;
import com.boxfuse.base.fsimage.ext2.CompositeUByteBuffer;
import com.boxfuse.base.fsimage.ext2.Ext2FsBlockAllocator;
import com.boxfuse.base.fsimage.ext2.Ext2FsBlockGroupDescriptorTable;
import com.boxfuse.base.fsimage.ext2.Ext2FsBlockMapper;
import com.boxfuse.base.fsimage.ext2.Ext2FsBlockNumber;
import com.boxfuse.base.fsimage.ext2.Ext2FsDirectoryData;
import com.boxfuse.base.fsimage.ext2.Ext2FsImage;
import com.boxfuse.base.fsimage.ext2.Ext2FsImageGeometry;
import com.boxfuse.base.fsimage.ext2.Ext2FsInode;
import com.boxfuse.base.fsimage.ext2.Ext2FsInodeNumber;
import com.boxfuse.base.fsimage.ext2.Ext2FsInodeTable;
import com.boxfuse.base.fsimage.ext2.Ext2FsSuperBlock;
import com.boxfuse.base.fsimage.ext2.SimpleUByteBuffer;
import com.boxfuse.base.fsimage.ext2.UByteBuffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UByteArray;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.UComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.URangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a%\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\"\u0013\u0010\u0000\u001a\u00020\u0001X\u0080T\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0013\u0010\u0003\u001a\u00020\u0001X\u0080T\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0013\u0010\u0004\u001a\u00020\u0005X\u0080T\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u0013\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0013\u0010\b\u001a\u00020\u0001X\u0080T\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0002\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001a"}, d2={"BLOCK_GROUP_DESCRIPTOR_SIZE", "Lkotlin/UInt;", "I", "BLOCK_SIZE", "INODE_SIZE", "Lkotlin/UShort;", "S", "MAX_BLOCK_COUNT_PER_GROUP", "RESERVED_INODE_COUNT", "computeIdealExt2FsImageGeometry", "Lcom/boxfuse/base/fsimage/ext2/Ext2FsImageGeometry;", "files", "", "Lcom/boxfuse/base/fsimage/FsFile;", "containersRequired", "itemSize", "containerSize", "containersRequired-feOb9K0", "(II)I", "createExt2FsImage", "Lcom/boxfuse/base/fsimage/ext2/Ext2FsImage;", "geometry", "byteBuffer", "Ljava/nio/ByteBuffer;", "inodeMinCount", "", "boxfuse-base-fsimage"})
public final class Ext2FsImageKt {
    public static final int BLOCK_SIZE = 1024;
    public static final short INODE_SIZE = 128;
    public static final int BLOCK_GROUP_DESCRIPTOR_SIZE = 32;
    public static final int RESERVED_INODE_COUNT = 10;
    private static final int MAX_BLOCK_COUNT_PER_GROUP;

    @NotNull
    public static final Ext2FsImage createExt2FsImage(@NotNull Ext2FsImageGeometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        ByteBuffer buffer = ByteBuffer.allocate(geometry.getBlockSize() * geometry.getBlockCount());
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        return Ext2FsImageKt.createExt2FsImage(buffer, geometry.getInodeCount());
    }

    @NotNull
    public static final Ext2FsImage createExt2FsImage(@NotNull ByteBuffer byteBuffer, int inodeMinCount) {
        int n;
        int blockGroupNum;
        int blockGroupBlockBitmapBuffer232;
        int n2;
        int uByteArrayArray;
        int n3;
        int n5;
        Pair[] $this$mapTo$iv$iv;
        int i2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        SimpleUByteBuffer buffer = new SimpleUByteBuffer(byteBuffer);
        int bufferSize = buffer.getSize-pVg5ArA();
        boolean bl2 = Integer.remainderUnsigned(bufferSize, 1024) == 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Buffer size must be a multiple of 1024 bytes";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int blockCount = Integer.divideUnsigned(bufferSize, 1024);
        int blockGroupCount = Ext2FsImageKt.containersRequired-feOb9K0(blockCount, MAX_BLOCK_COUNT_PER_GROUP);
        int bl5 = inodeMinCount;
        int n6 = 0;
        int n4 = UInt.constructor-impl((int)bl5);
        bl5 = 1024;
        n6 = 128;
        int n8 = 0;
        int n9 = bl5;
        int n10 = n6;
        int n11 = 0;
        n10 = UInt.constructor-impl((int)(n10 & 0xFFFF));
        n11 = 0;
        bl5 = UnsignedKt.uintDivide-J1ME1BU((int)n9, (int)n10);
        n6 = 0;
        bl5 = Ext2FsImageKt.containersRequired-feOb9K0(n4, UInt.constructor-impl((int)(blockGroupCount * bl5)));
        n6 = 0;
        bl5 = UInt.constructor-impl((int)(bl5 * blockGroupCount));
        n6 = 1024;
        n8 = 128;
        n9 = 0;
        n10 = n6;
        n11 = n8;
        int n12 = 0;
        n11 = UInt.constructor-impl((int)(n11 & 0xFFFF));
        n12 = 0;
        n6 = UnsignedKt.uintDivide-J1ME1BU((int)n10, (int)n11);
        n8 = 0;
        int inodeCount = UInt.constructor-impl((int)(bl5 * n6));
        bl5 = 1024;
        n6 = 128;
        n8 = 0;
        n9 = bl5;
        n10 = n6;
        n11 = 0;
        n10 = UInt.constructor-impl((int)(n10 & 0xFFFF));
        n11 = 0;
        bl5 = UnsignedKt.uintDivide-J1ME1BU((int)n9, (int)n10);
        n6 = 0;
        bl5 = Integer.remainderUnsigned(inodeCount, UInt.constructor-impl((int)(blockGroupCount * bl5))) == 0 ? 1 : 0;
        n6 = 0;
        n8 = 0;
        if (bl5 == 0) {
            bl = false;
            n10 = 1024;
            n11 = 128;
            n12 = 0;
            int n13 = n10;
            int n14 = n11;
            boolean bl6 = false;
            n14 = UInt.constructor-impl((int)(n14 & 0xFFFF));
            bl6 = false;
            String string = Intrinsics.stringPlus((String)"Inode count must be a multiple of ", (Object)UInt.toString-impl((int)UnsignedKt.uintDivide-J1ME1BU((int)n13, (int)n14)));
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n6 = 32;
        n8 = 0;
        int blockGroupDescriptorTableBlockCount = Ext2FsImageKt.containersRequired-feOb9K0(UInt.constructor-impl((int)(blockGroupCount * n6)), 1024);
        n8 = 128;
        bl = false;
        n10 = inodeCount;
        n11 = n8;
        n12 = 0;
        n11 = UInt.constructor-impl((int)(n11 & 0xFFFF));
        n12 = 0;
        int inodeTableBlockCount = Ext2FsImageKt.containersRequired-feOb9K0(UInt.constructor-impl((int)(n10 * n11)), 1024);
        int inodeTableBlockCountPerGroup = Ext2FsImageKt.containersRequired-feOb9K0(inodeTableBlockCount, blockGroupCount);
        n10 = 1024;
        n11 = 128;
        n12 = 0;
        int n15 = n10;
        int n16 = n11;
        int n17 = 0;
        n16 = UInt.constructor-impl((int)(n16 & 0xFFFF));
        n17 = 0;
        n10 = UnsignedKt.uintDivide-J1ME1BU((int)n15, (int)n16);
        n11 = 0;
        int inodeCountPerGroup = UInt.constructor-impl((int)(inodeTableBlockCountPerGroup * n10));
        n11 = 3;
        n12 = 0;
        n11 = UInt.constructor-impl((int)(n11 + blockGroupDescriptorTableBlockCount));
        n12 = 0;
        int overheadBlockCountPerGroup = UInt.constructor-impl((int)(n11 + inodeTableBlockCountPerGroup));
        n12 = 2;
        n15 = 0;
        int usedBlockCountGroup0 = UInt.constructor-impl((int)(overheadBlockCountPerGroup + n12));
        n15 = 1;
        n16 = 0;
        int freeBlockCount = UInt.constructor-impl((int)(blockCount - n15));
        n15 = 0;
        freeBlockCount = UInt.constructor-impl((int)(freeBlockCount - usedBlockCountGroup0));
        n16 = 1;
        n17 = 0;
        n15 = n16;
        n17 = 0;
        n16 = blockGroupCount;
        n17 = n15;
        int n18 = n16;
        int n19 = 0;
        if (UnsignedKt.uintCompare((int)n17, (int)n18) < 0) {
            do {
                i2 = n15++;
                n18 = 0;
                freeBlockCount = UInt.constructor-impl((int)(freeBlockCount - overheadBlockCountPerGroup));
                n18 = n15;
                n19 = n16;
                boolean bl7 = false;
            } while (UnsignedKt.uintCompare((int)n18, (int)n19) < 0);
        }
        n16 = 10;
        i2 = 1;
        n18 = 0;
        int usedInodeCount = UInt.constructor-impl((int)(n16 + i2));
        i2 = 0;
        int freeInodeCount = UInt.constructor-impl((int)(inodeCount - usedInodeCount));
        n18 = MAX_BLOCK_COUNT_PER_GROUP;
        n19 = 0;
        byte[] superBlockBlock0Bytes = Ext2FsSuperBlock.Companion.create-yY0LWAg(blockCount, freeBlockCount, UComparisonsKt.minOf-J1ME1BU((int)blockCount, (int)n18), inodeCount, freeInodeCount, inodeCountPerGroup, (short)0);
        Ext2FsSuperBlock superBlock = new Ext2FsSuperBlock(new SimpleUByteBuffer(superBlockBlock0Bytes, null), false, 2, null);
        Ext2FsBlockMapper simpleBlockMapper2 = new Ext2FsBlockMapper(superBlock){
            final /* synthetic */ Ext2FsSuperBlock $superBlock;
            {
                this.$superBlock = $superBlock;
            }

            @NotNull
            public UByteBuffer mapBlocks-mInE6nA(int startBlockNum, int count) {
                int n = this.$superBlock.getBlockSize-pVg5ArA();
                boolean bl = false;
                return new SimpleUByteBuffer(UInt.constructor-impl((int)(n * count)), null);
            }
        };
        Ext2FsBlockAllocator noopBlockAllocator2 = new Ext2FsBlockAllocator(){

            @NotNull
            public Pair<List<Ext2FsBlockNumber>, UByteBuffer> allocateBlocks-WZ4Q5Ns(int count) {
                throw new IllegalStateException("Can never happen");
            }
        };
        int rootDirectoryInodeNum = Ext2FsInodeNumber.Companion.getROOT_DIRECTORY-mJi9oTg();
        int n20 = 1;
        boolean bl8 = false;
        int rootDirectoryBlockNum = Ext2FsBlockNumber.constructor-impl(UInt.constructor-impl((int)(n20 + overheadBlockCountPerGroup)));
        byte[] rootDirectoryInode = Ext2FsInode.Companion.create-2Nq_yQs(simpleBlockMapper2, noopBlockAllocator2, 1024, 1024, FsFileType.DIRECTORY, FsFileMode.Companion.getRX(), CollectionsKt.listOf((Object)Ext2FsBlockNumber.box-impl(rootDirectoryBlockNum)), (short)3, null, null, null);
        int lostFoundDirectoryInodeNum = Ext2FsInodeNumber.Companion.getLOST_FOUND_DIRECTORY-mJi9oTg();
        int n21 = rootDirectoryBlockNum;
        int n22 = 1;
        boolean bl9 = false;
        int lostFoundDirectoryBlockNum = Ext2FsBlockNumber.constructor-impl(UInt.constructor-impl((int)(n21 + n22)));
        byte[] lostFoundDirectoryInode = Ext2FsInode.Companion.create-2Nq_yQs(simpleBlockMapper2, noopBlockAllocator2, 1024, 1024, FsFileType.DIRECTORY, FsFileMode.Companion.getRX(), CollectionsKt.listOf((Object)Ext2FsBlockNumber.box-impl(lostFoundDirectoryBlockNum)), (short)2, null, null, null);
        Iterable $this$map$iv = (Iterable)URangesKt.until-J1ME1BU((int)0, (int)blockGroupCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Pair[] destination$iv$iv = (Pair[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        for (Object t : $this$mapTo$iv$iv) {
            int n7 = ((UInt)t).unbox-impl();
            Pair[] pairArray = destination$iv$iv;
            n5 = 0;
            n3 = superBlock.getBlockSize-pVg5ArA();
            uByteArrayArray = 0;
            SimpleUByteBuffer simpleUByteBuffer = new SimpleUByteBuffer(UInt.constructor-impl((int)(inodeTableBlockCountPerGroup * n3)), null);
            pairArray.add(simpleUByteBuffer);
        }
        List inodeTableBuffers = (List)destination$iv$iv;
        Ext2FsInodeTable inodeTable = new Ext2FsInodeTable(new CompositeUByteBuffer(inodeTableBuffers), superBlock, simpleBlockMapper2, noopBlockAllocator2);
        inodeTable.writeInode-dinPuuU(rootDirectoryInodeNum, rootDirectoryInode);
        inodeTable.writeInode-dinPuuU(lostFoundDirectoryInodeNum, lostFoundDirectoryInode);
        Ext2FsDirectoryData rootDirectoryData = new Ext2FsDirectoryData(inodeTable.readInode-rfUoTA8(rootDirectoryInodeNum), simpleBlockMapper2);
        $this$mapTo$iv$iv = new Pair[]{TuplesKt.to((Object)".", (Object)Ext2FsInodeNumber.box-impl(rootDirectoryInodeNum)), TuplesKt.to((Object)"..", (Object)Ext2FsInodeNumber.box-impl(rootDirectoryInodeNum)), TuplesKt.to((Object)"lost+found", (Object)Ext2FsInodeNumber.box-impl(lostFoundDirectoryInodeNum))};
        rootDirectoryData.appendDirectoryEntries(MapsKt.mapOf((Pair[])$this$mapTo$iv$iv));
        Ext2FsDirectoryData lostFoundDirectoryData = new Ext2FsDirectoryData(inodeTable.readInode-rfUoTA8(lostFoundDirectoryInodeNum), simpleBlockMapper2);
        destination$iv$iv = new Pair[]{TuplesKt.to((Object)".", (Object)Ext2FsInodeNumber.box-impl(lostFoundDirectoryInodeNum)), TuplesKt.to((Object)"..", (Object)Ext2FsInodeNumber.box-impl(rootDirectoryInodeNum))};
        lostFoundDirectoryData.appendDirectoryEntries(MapsKt.mapOf((Pair[])destination$iv$iv));
        $i$f$mapTo = 10;
        int n24 = 1;
        boolean bl6 = false;
        int usedInodeCountBlock0 = UInt.constructor-impl((int)($i$f$mapTo + n24));
        int usedDirCountBlock0 = 2;
        int n13 = superBlock.getBlockSize-pVg5ArA();
        int it = 0;
        SimpleUByteBuffer blockGroupDescriptorTableBuffer = new SimpleUByteBuffer(UInt.constructor-impl((int)(n13 * blockGroupDescriptorTableBlockCount)), null);
        Ext2FsBlockGroupDescriptorTable ext2FsBlockGroupDescriptorTable = new Ext2FsBlockGroupDescriptorTable(blockGroupDescriptorTableBuffer, superBlock);
        ext2FsBlockGroupDescriptorTable.addBlockGroupDescriptor-nAmpug0(0, usedBlockCountGroup0, usedInodeCountBlock0, usedDirCountBlock0);
        n5 = 1;
        n3 = 0;
        it = n5;
        n3 = 0;
        n5 = blockGroupCount;
        n3 = it;
        uByteArrayArray = n5;
        int uByteArrayArray2 = 0;
        if (UnsignedKt.uintCompare((int)n3, (int)uByteArrayArray) < 0) {
            do {
                int blockGroupNum2 = it++;
                ext2FsBlockGroupDescriptorTable.addBlockGroupDescriptor-nAmpug0(blockGroupNum2, overheadBlockCountPerGroup, 0, 0);
                uByteArrayArray = it;
                uByteArrayArray2 = n5;
                n2 = 0;
            } while (UnsignedKt.uintCompare((int)uByteArrayArray, (int)uByteArrayArray2) < 0);
        }
        n5 = 0;
        uByteArrayArray = 0;
        n3 = blockGroupCount;
        UByteArray[] n26 = new UByteArray[n3];
        while (n5 < n3) {
            uByteArrayArray2 = n5++;
            n26[uByteArrayArray2] = UByteArray.box-impl((byte[])UByteArray.constructor-impl((int)0));
        }
        UByteArray[] blockGroupBlockBitmaps = n26;
        n3 = 0;
        uByteArrayArray2 = 0;
        int n14 = blockGroupCount;
        UByteArray[] n27 = new UByteArray[n14];
        while (n3 < n14) {
            n2 = n3++;
            n27[n2] = UByteArray.box-impl((byte[])UByteArray.constructor-impl((int)0));
        }
        UByteArray[] blockGroupInodeBitmaps = n27;
        n14 = 0;
        int n23 = 0;
        n3 = n14;
        n23 = 0;
        n14 = blockGroupCount;
        n23 = n3;
        n2 = n14;
        int n25 = 0;
        if (UnsignedKt.uintCompare((int)n23, (int)n2) < 0) {
            do {
                boolean bl7;
                int bitNum;
                int n28;
                int n29;
                int n30;
                int n31;
                blockGroupNum = n3++;
                SimpleUByteBuffer blockGroupBlockBitmapBuffer232 = new SimpleUByteBuffer(superBlock.getBlockSize-pVg5ArA(), null);
                SimpleUByteBuffer blockGroupInodeBitmapBuffer = new SimpleUByteBuffer(superBlock.getBlockSize-pVg5ArA(), null);
                Bitmap blockGroupBlockBitmap = new Bitmap(blockGroupBlockBitmapBuffer232);
                Bitmap blockGroupInodeBitmap = new Bitmap(blockGroupInodeBitmapBuffer);
                if (blockGroupNum == 0) {
                    n31 = 0;
                    int n32 = 0;
                    n30 = n31;
                    n32 = 0;
                    n31 = usedBlockCountGroup0;
                    n32 = n30;
                    n29 = n31;
                    n28 = 0;
                    if (UnsignedKt.uintCompare((int)n32, (int)n29) < 0) {
                        do {
                            bitNum = n30++;
                            blockGroupBlockBitmap.set-WZ4Q5Ns(bitNum);
                            n29 = n30;
                            n28 = n31;
                            bl7 = false;
                        } while (UnsignedKt.uintCompare((int)n29, (int)n28) < 0);
                    }
                    n31 = 0;
                    bitNum = 0;
                    n30 = n31;
                    bitNum = 0;
                    n31 = usedInodeCount;
                    bitNum = n30;
                    n29 = n31;
                    n28 = 0;
                    if (UnsignedKt.uintCompare((int)bitNum, (int)n29) < 0) {
                        do {
                            bitNum = n30++;
                            blockGroupInodeBitmap.set-WZ4Q5Ns(bitNum);
                            n29 = n30;
                            n28 = n31;
                            bl7 = false;
                        } while (UnsignedKt.uintCompare((int)n29, (int)n28) < 0);
                    }
                } else {
                    n31 = 0;
                    bitNum = 0;
                    n30 = n31;
                    bitNum = 0;
                    n31 = overheadBlockCountPerGroup;
                    bitNum = n30;
                    n29 = n31;
                    n28 = 0;
                    if (UnsignedKt.uintCompare((int)bitNum, (int)n29) < 0) {
                        do {
                            bitNum = n30++;
                            blockGroupBlockBitmap.set-WZ4Q5Ns(bitNum);
                            n29 = n30;
                            n28 = n31;
                            bl7 = false;
                        } while (UnsignedKt.uintCompare((int)n29, (int)n28) < 0);
                    }
                }
                blockGroupBlockBitmap.padFrom-WZ4Q5Ns(superBlock.getBlockCountForBlockGroup-IKrLr70(blockGroupNum));
                blockGroupInodeBitmap.padFrom-WZ4Q5Ns(superBlock.getInodeCountPerBlockGroup-pVg5ArA());
                n30 = 0;
                blockGroupBlockBitmaps[blockGroupNum] = UByteArray.box-impl((byte[])blockGroupBlockBitmapBuffer232.toUByteArray-TcUX1vc());
                n30 = 0;
                blockGroupInodeBitmaps[blockGroupNum] = UByteArray.box-impl((byte[])blockGroupInodeBitmapBuffer.toUByteArray-TcUX1vc());
                blockGroupBlockBitmapBuffer232 = n3;
                n25 = n14;
                n = 0;
            } while (UnsignedKt.uintCompare((int)blockGroupBlockBitmapBuffer232, (int)n25) < 0);
        }
        buffer.putUByteArray-U8q4Juc(1024, superBlockBlock0Bytes);
        Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, Ext2FsBlockNumber.constructor-impl(2), blockGroupDescriptorTableBuffer.toUByteArray-TcUX1vc());
        n3 = 2;
        n14 = 0;
        Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, Ext2FsBlockNumber.constructor-impl(UInt.constructor-impl((int)(n3 + blockGroupDescriptorTableBlockCount))), blockGroupBlockBitmaps[0].unbox-impl());
        n3 = 3;
        n14 = 0;
        Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, Ext2FsBlockNumber.constructor-impl(UInt.constructor-impl((int)(n3 + blockGroupDescriptorTableBlockCount))), blockGroupInodeBitmaps[0].unbox-impl());
        n3 = 4;
        n14 = 0;
        Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, Ext2FsBlockNumber.constructor-impl(UInt.constructor-impl((int)(n3 + blockGroupDescriptorTableBlockCount))), ((SimpleUByteBuffer)inodeTableBuffers.get(0)).toUByteArray-TcUX1vc());
        Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, rootDirectoryBlockNum, rootDirectoryData.toUByteArray-TcUX1vc());
        Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, lostFoundDirectoryBlockNum, lostFoundDirectoryData.toUByteArray-TcUX1vc());
        n14 = 1;
        blockGroupNum = 0;
        n3 = n14;
        blockGroupNum = 0;
        n14 = blockGroupCount;
        blockGroupNum = n3;
        blockGroupBlockBitmapBuffer232 = n14;
        n25 = 0;
        if (UnsignedKt.uintCompare((int)blockGroupNum, (int)blockGroupBlockBitmapBuffer232) < 0) {
            do {
                blockGroupNum = n3++;
                int startBlockNum = superBlock.getStartBlockNumForBlockGroup-8SBzV5A(blockGroupNum);
                n25 = MAX_BLOCK_COUNT_PER_GROUP;
                n = 0;
                int n33 = UComparisonsKt.minOf-J1ME1BU((int)blockCount, (int)n25);
                n25 = 0;
                n = blockGroupNum;
                boolean bl10 = false;
                Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, startBlockNum, Ext2FsSuperBlock.Companion.create-yY0LWAg(blockCount, freeBlockCount, n33, inodeCount, freeInodeCount, inodeCountPerGroup, UShort.constructor-impl((short)((short)n))));
                n25 = startBlockNum;
                n = 1;
                bl10 = false;
                Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, Ext2FsBlockNumber.constructor-impl(UInt.constructor-impl((int)(n25 + n))), blockGroupDescriptorTableBuffer.toUByteArray-TcUX1vc());
                n25 = startBlockNum;
                n = 1;
                bl10 = false;
                n25 = UInt.constructor-impl((int)(n25 + n));
                n = 0;
                int n34 = Ext2FsBlockNumber.constructor-impl(UInt.constructor-impl((int)(n25 + blockGroupDescriptorTableBlockCount)));
                n25 = 0;
                Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, n34, blockGroupBlockBitmaps[blockGroupNum].unbox-impl());
                n25 = startBlockNum;
                n = 1;
                bl10 = false;
                n25 = UInt.constructor-impl((int)(n25 + n));
                n = 0;
                n25 = UInt.constructor-impl((int)(n25 + blockGroupDescriptorTableBlockCount));
                n = 1;
                bl10 = false;
                int n35 = Ext2FsBlockNumber.constructor-impl(UInt.constructor-impl((int)(n25 + n)));
                n25 = 0;
                Ext2FsImageKt.createExt2FsImage$writeBlocks_8003RsQ(buffer, n35, blockGroupInodeBitmaps[blockGroupNum].unbox-impl());
                n2 = n3;
                n25 = n14;
                n = 0;
            } while (UnsignedKt.uintCompare((int)n2, (int)n25) < 0);
        }
        return new Ext2FsImage(byteBuffer);
    }

    @NotNull
    public static final Ext2FsImageGeometry computeIdealExt2FsImageGeometry(@NotNull List<? extends FsFile> files) {
        boolean bl;
        int n;
        int n2;
        int usage;
        int n3;
        boolean bl2;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        boolean bl3 = false;
        Map dirs = new LinkedHashMap();
        int n4 = 10;
        int n5 = 1;
        boolean bl4 = false;
        int inodeCount = UInt.constructor-impl((int)(n4 + n5));
        int dataBlocks = 0;
        dataBlocks = 0;
        int blockSize = 1024;
        Ext2FsImageKt.computeIdealExt2FsImageGeometry$addDirEntry(dirs, "/", ".");
        Ext2FsImageKt.computeIdealExt2FsImageGeometry$addDirEntry(dirs, "/", "lost+found");
        Ext2FsImageKt.computeIdealExt2FsImageGeometry$addDirEntry(dirs, "/lost+found", ".");
        for (FsFile fsFile : files) {
            FsPath parentPath32422;
            Object filePath = fsFile.getPath();
            do {
                parentPath32422 = ((FsPath)filePath).getParent();
                Ext2FsImageKt.computeIdealExt2FsImageGeometry$addDirEntry(dirs, parentPath32422.getAbsolutePath(), ((FsPath)filePath).getName());
            } while (!Intrinsics.areEqual((Object)((FsPath)(filePath = parentPath32422)).getAbsolutePath(), (Object)"/"));
            int parentPath32422 = inodeCount;
            int n6 = 0;
            inodeCount = UInt.constructor-impl((int)(parentPath32422 + 1));
            if (fsFile.getType() == FsFileType.SYMBOLIC_LINK) {
                String parentPath32422 = fsFile.getDestination();
                Intrinsics.checkNotNull((Object)parentPath32422);
                Charset charset = Charsets.UTF_8;
                bl2 = false;
                byte[] byArray = parentPath32422.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                parentPath32422 = byArray.length;
                n6 = 0;
                if (Integer.compareUnsigned(UInt.constructor-impl((int)parentPath32422), 59) > 0) {
                    parentPath32422 = dataBlocks;
                    n6 = 0;
                    dataBlocks = UInt.constructor-impl((int)(parentPath32422 + 1));
                }
            }
            if (fsFile.getType() != FsFileType.REGULAR_FILE) continue;
            parentPath32422 = dataBlocks;
            n6 = Ext2FsImageKt.computeIdealExt2FsImageGeometry$regularFileDataBlockUsage(blockSize, fsFile.getSize());
            bl2 = false;
            dataBlocks = UInt.constructor-impl((int)(parentPath32422 + n6));
        }
        Iterable $this$forEach$iv = dirs.values();
        boolean bl5 = false;
        for (Object element$iv : $this$forEach$iv) {
            Set it = (Set)element$iv;
            n3 = 0;
            usage = 0;
            for (String entry : it) {
                int n7 = 4;
                int n8 = 0;
                usage = UInt.constructor-impl((int)(usage + n7));
                byte[] bytes = StringsKt.encodeToByteArray((String)entry);
                n8 = bytes.length;
                int n9 = 0;
                n8 = UInt.constructor-impl((int)n8);
                n9 = 0;
                usage = UInt.constructor-impl((int)(usage + n8));
                n8 = 4;
                n9 = bytes.length;
                boolean bl6 = false;
                n9 = Integer.remainderUnsigned(UInt.constructor-impl((int)n9), 4);
                bl6 = false;
                n8 = UInt.constructor-impl((int)(n8 - n9));
                n9 = 0;
                usage = UInt.constructor-impl((int)(usage + n8));
            }
            n2 = dataBlocks;
            n = Ext2FsImageKt.containersRequired-feOb9K0(usage, blockSize);
            bl = false;
            dataBlocks = UInt.constructor-impl((int)(n2 + n));
        }
        int n10 = 128;
        int filePath = 0;
        int element$iv = inodeCount;
        int it = n10;
        n3 = 0;
        it = UInt.constructor-impl((int)(it & 0xFFFF));
        n3 = 0;
        int inodeTableBlockCount = Ext2FsImageKt.containersRequired-feOb9K0(UInt.constructor-impl((int)(element$iv * it)), blockSize);
        filePath = 8;
        element$iv = 0;
        int n11 = Ext2FsImageKt.containersRequired-feOb9K0(inodeCount, UInt.constructor-impl((int)(blockSize * filePath)));
        element$iv = dataBlocks;
        it = 0;
        element$iv = UInt.constructor-impl((int)(element$iv + inodeTableBlockCount));
        it = 0;
        element$iv = UInt.constructor-impl((int)(element$iv + n11));
        it = 3;
        n3 = 0;
        int n12 = UInt.constructor-impl((int)(element$iv + it));
        element$iv = 8;
        it = 0;
        int blockBitmapBlockCount = Ext2FsImageKt.containersRequired-feOb9K0(n12, UInt.constructor-impl((int)(blockSize * element$iv)));
        it = 0;
        it = UComparisonsKt.maxOf-J1ME1BU((int)n11, (int)blockBitmapBlockCount);
        n3 = 1;
        usage = 0;
        int blockGroupCount = UInt.constructor-impl((int)(it - n3));
        int blockCount = 0;
        do {
            n3 = blockGroupCount;
            usage = 0;
            blockGroupCount = UInt.constructor-impl((int)(n3 + 1));
            usage = Ext2FsImageKt.containersRequired-feOb9K0(inodeTableBlockCount, blockGroupCount);
            n2 = 0;
            int adjustedInodeTableBlockCount = UInt.constructor-impl((int)(usage * blockGroupCount));
            n2 = 32;
            n = 0;
            int blockGroupDescriptorTableBlockCount = Ext2FsImageKt.containersRequired-feOb9K0(UInt.constructor-impl((int)(blockGroupCount * n2)), 1024);
            n2 = dataBlocks;
            n = 0;
            n2 = UInt.constructor-impl((int)(n2 + adjustedInodeTableBlockCount));
            n = 3;
            bl = false;
            n = UInt.constructor-impl((int)(blockGroupDescriptorTableBlockCount + n));
            bl = false;
            n = UInt.constructor-impl((int)(blockGroupCount * n));
            bl = false;
            n2 = UInt.constructor-impl((int)(n2 + n));
            n = 1;
            bl = false;
            blockCount = UInt.constructor-impl((int)(n2 + n));
            n2 = 8;
            n = 0;
        } while (Integer.compareUnsigned(Ext2FsImageKt.containersRequired-feOb9K0(blockCount, UInt.constructor-impl((int)(blockSize * n2))), blockGroupCount) < 0);
        bl2 = false;
        bl2 = false;
        bl2 = false;
        return new Ext2FsImageGeometry(blockSize, blockCount, inodeCount);
    }

    public static final int containersRequired-feOb9K0(int itemSize, int containerSize) {
        int n = 1;
        boolean bl = false;
        n = UInt.constructor-impl((int)(containerSize - n));
        bl = false;
        return Integer.divideUnsigned(UInt.constructor-impl((int)(itemSize + n)), containerSize);
    }

    private static final void createExt2FsImage$writeBlocks_8003RsQ(SimpleUByteBuffer buffer, int startBlockNum, byte[] data) {
        int n = 1024;
        int n2 = startBlockNum;
        boolean bl = false;
        buffer.putUByteArray-U8q4Juc(UInt.constructor-impl((int)(n * n2)), data);
    }

    private static final void computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addDirectBlocks_WZ4Q5Ns(Ref.LongRef remaining, Ref.IntRef usage, int blockSize, int blockNumBuffer) {
        int buffer = blockNumBuffer;
        while (remaining.element > 0L && Integer.compareUnsigned(buffer, 0) > 0) {
            int n = usage.element;
            boolean bl = false;
            usage.element = UInt.constructor-impl((int)(n + 1));
            n = 0;
            remaining.element -= (long)blockSize;
            n = buffer;
            bl = false;
            buffer = UInt.constructor-impl((int)(n + -1));
        }
    }

    private static final void computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addIndirectBlocks_WZ4Q5Ns(Ref.LongRef remaining, Ref.IntRef usage, int blockSize, int blockNumBuffer) {
        int buffer = blockNumBuffer;
        while (remaining.element > 0L && Integer.compareUnsigned(buffer, 0) > 0) {
            int n = usage.element;
            boolean bl = false;
            usage.element = UInt.constructor-impl((int)(n + 1));
            n = buffer;
            bl = false;
            buffer = UInt.constructor-impl((int)(n + -1));
            Ext2FsImageKt.computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addDirectBlocks_WZ4Q5Ns(remaining, usage, blockSize, Integer.divideUnsigned(blockSize, 4));
        }
    }

    private static final void computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addDoubleIndirectBlocks_WZ4Q5Ns(Ref.LongRef remaining, Ref.IntRef usage, int blockSize, int blockNumBuffer) {
        int buffer = blockNumBuffer;
        while (remaining.element > 0L && Integer.compareUnsigned(buffer, 0) > 0) {
            int n = usage.element;
            boolean bl = false;
            usage.element = UInt.constructor-impl((int)(n + 1));
            n = buffer;
            bl = false;
            buffer = UInt.constructor-impl((int)(n + -1));
            Ext2FsImageKt.computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addIndirectBlocks_WZ4Q5Ns(remaining, usage, blockSize, Integer.divideUnsigned(blockSize, 4));
        }
    }

    private static final void computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addTripleIndirectBlocks_WZ4Q5Ns(Ref.LongRef remaining, Ref.IntRef usage, int blockSize, int blockNumBuffer) {
        int buffer = blockNumBuffer;
        while (remaining.element > 0L && Integer.compareUnsigned(buffer, 0) > 0) {
            int n = usage.element;
            boolean bl = false;
            usage.element = UInt.constructor-impl((int)(n + 1));
            n = buffer;
            bl = false;
            buffer = UInt.constructor-impl((int)(n + -1));
            Ext2FsImageKt.computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addDoubleIndirectBlocks_WZ4Q5Ns(remaining, usage, blockSize, Integer.divideUnsigned(blockSize, 4));
        }
    }

    private static final int computeIdealExt2FsImageGeometry$regularFileDataBlockUsage(int blockSize, long size) {
        Ref.IntRef usage = new Ref.IntRef();
        usage.element = 0;
        Ref.LongRef remaining = new Ref.LongRef();
        remaining.element = size;
        Ext2FsImageKt.computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addDirectBlocks_WZ4Q5Ns(remaining, usage, blockSize, 12);
        if (remaining.element > 0L) {
            Ext2FsImageKt.computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addIndirectBlocks_WZ4Q5Ns(remaining, usage, blockSize, 1);
            if (remaining.element > 0L) {
                Ext2FsImageKt.computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addDoubleIndirectBlocks_WZ4Q5Ns(remaining, usage, blockSize, 1);
                if (remaining.element > 0L) {
                    Ext2FsImageKt.computeIdealExt2FsImageGeometry$regularFileDataBlockUsage$addTripleIndirectBlocks_WZ4Q5Ns(remaining, usage, blockSize, 1);
                }
            }
        }
        return usage.element;
    }

    private static final void computeIdealExt2FsImageGeometry$addDirEntry(Map<String, Set<String>> dirs, String dir, String entry) {
        Object object;
        if (!dirs.containsKey(dir)) {
            object = dirs;
            boolean bl = false;
            Set set = new LinkedHashSet();
            boolean bl2 = false;
            object.put(dir, set);
            Ext2FsImageKt.computeIdealExt2FsImageGeometry$addDirEntry(dirs, dir, ".");
            Ext2FsImageKt.computeIdealExt2FsImageGeometry$addDirEntry(dirs, dir, "..");
        }
        object = dirs.get(dir);
        Intrinsics.checkNotNull((Object)object);
        object.add(entry);
    }

    static {
        int n = 1024;
        int n2 = 8;
        boolean bl = false;
        MAX_BLOCK_COUNT_PER_GROUP = UInt.constructor-impl((int)(n * n2));
    }
}

