/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.generic.go.revel;

import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.generic.GenericRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.generic.go.revel.RevelConfig;
import com.boxfuse.generator.builder.ramdisk.generic.go.revel.RevelPayload;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevelRamDiskBuilder
extends GenericRamDiskBuilder<RevelPayload> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevelRamDiskBuilder.class);

    public RevelRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
    }

    @Override
    protected void doAdjustSpecBasedOnConfig() {
        String appConf = ((RevelPayload)this.payload).getAppConf();
        if (appConf != null && !this.messagesDisplayed) {
            LOGGER.debug("Found app.conf");
        }
        RevelConfig revelConfig = new RevelConfig(appConf);
        for (Map.Entry<PortName, Port> portEntry : revelConfig.getPorts().entrySet()) {
            if (this.spec.getPorts().containsKey(portEntry.getKey())) continue;
            this.spec.getPorts().put(portEntry.getKey(), portEntry.getValue());
            if (this.messagesDisplayed) continue;
            LOGGER.debug("Auto-configured " + portEntry.getKey().getName() + " port to " + portEntry.getValue());
        }
        super.doAdjustSpecBasedOnConfig();
    }
}

