/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot;

import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootConfig.class);
    private static final String REGEX_DEFAULT_VALUE = Pattern.quote("${") + ".+" + Pattern.quote(":") + "(.+)" + Pattern.quote("}");
    private final Map<PortName, Port> ports = new HashMap<PortName, Port>();
    private final PortName payloadPort;
    private final Path payloadPath;
    private final Path healthcheckPath;
    private final PortName healthcheckPort;
    private final String dataSourceUrl;
    private final boolean sslEnabled;
    private final String sslKeyStore;
    private final String sslKeyStorePassword;

    SpringBootConfig(Properties cfg, boolean actuator, boolean springBoot1) {
        boolean usableHealthEndpoint;
        String sslEnabledProp = this.getPropertyValue(cfg, "server.ssl.enabled");
        this.sslKeyStore = this.getPropertyValue(cfg, "server.ssl.key-store");
        this.sslKeyStorePassword = this.getPropertyValue(cfg, "server.ssl.key-store-password");
        if (!StringUtils.hasLength((String)sslEnabledProp)) {
            sslEnabledProp = "" + StringUtils.hasLength((String)this.sslKeyStore);
        }
        this.sslEnabled = Boolean.parseBoolean(sslEnabledProp);
        this.payloadPort = this.sslEnabled ? PortName.HTTPS : PortName.HTTP;
        Protocol payloadPortProtocol = this.sslEnabled ? Protocol.HTTPS : Protocol.HTTP;
        this.addPort(this.payloadPort, this.getPropertyValue(cfg, "server.port", "8080"), payloadPortProtocol);
        String serverContextPath = this.normalizePath(this.getPropertyValue(cfg, springBoot1 ? "server.context-path" : "server.servlet.context-path", "/"));
        String serverServletPath = this.normalizePath(this.getPropertyValue(cfg, springBoot1 ? "server.servlet-path" : "server.servlet.path", "/"));
        this.payloadPath = Path.of((String)("/" + serverContextPath + serverServletPath));
        String managementPort = this.getPropertyValue(cfg, springBoot1 ? "management.port" : "management.server.port");
        boolean managementDisabled = "-1".equals(managementPort);
        boolean managementPortEnabled = StringUtils.hasLength((String)managementPort) && !managementDisabled;
        boolean managementSecurityEnabled = this.getPropertyValue(cfg, "management.security.enabled", false);
        boolean healthEndpointEnabled = this.getPropertyValue(cfg, springBoot1 ? "endpoints.health.enabled" : "management.endpoint.health.enabled", true);
        boolean healthEndpointSensitive = this.getPropertyValue(cfg, springBoot1 ? "endpoints.health.sensitive" : "management.endpoint.health.sensitive", false);
        boolean bl = usableHealthEndpoint = actuator && !managementDisabled && healthEndpointEnabled && (!healthEndpointSensitive || !managementSecurityEnabled);
        if (managementPortEnabled) {
            String managementSslEnabledProp = this.getPropertyValue(cfg, springBoot1 ? "management.ssl.enabled" : "management.server.ssl.enabled");
            if (!StringUtils.hasLength((String)managementSslEnabledProp)) {
                String managementSslKeyStoreProp = this.getPropertyValue(cfg, springBoot1 ? "management.ssl.key-store" : "management.server.ssl.key-store");
                managementSslEnabledProp = managementSslKeyStoreProp == null ? null : "" + StringUtils.hasLength((String)managementSslKeyStoreProp);
            }
            boolean managementSslEnabled = managementSslEnabledProp == null ? this.sslEnabled : Boolean.parseBoolean(managementSslEnabledProp);
            PortName managementPortName = managementSslEnabled ? PortName.ADMIN_HTTPS : PortName.ADMIN_HTTP;
            Protocol managementPortProtocol = managementSslEnabled ? Protocol.HTTPS : Protocol.HTTP;
            this.addPort(managementPortName, managementPort, managementPortProtocol);
            this.healthcheckPort = usableHealthEndpoint ? managementPortName : this.payloadPort;
        } else {
            this.healthcheckPort = this.payloadPort;
        }
        if (usableHealthEndpoint) {
            String endpointsWebBasePath = springBoot1 ? "" : this.normalizePath(this.getPropertyValue(cfg, "management.endpoints.web.base-path", "/actuator"));
            String baseManagementPath = this.normalizePath(managementPortEnabled ? "" : serverContextPath + serverServletPath + endpointsWebBasePath);
            String managementContextPath = this.normalizePath(this.getPropertyValue(cfg, springBoot1 ? "management.context-path" : "management.server.servlet.context-path", "/"));
            String healthEndpoint = this.noTrailingSlash(this.normalizePath(this.getPropertyValue(cfg, springBoot1 ? "endpoints.health.id" : "management.endpoint.health.id", "health")));
            this.healthcheckPath = Path.of((String)("/" + baseManagementPath + managementContextPath + healthEndpoint));
        } else {
            this.healthcheckPath = this.payloadPath;
        }
        this.dataSourceUrl = this.getPropertyValue(cfg, "spring.datasource.url");
    }

    private boolean getPropertyValue(Properties properties, String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getPropertyValue(properties, key, "" + defaultValue));
    }

    private String getPropertyValue(Properties properties, String key) {
        return this.getPropertyValue(properties, key, null);
    }

    private String getPropertyValue(Properties properties, String key, String defaultValue) {
        String value = properties.getProperty(key, defaultValue);
        if (value != null && value.matches(REGEX_DEFAULT_VALUE)) {
            return StringUtils.firstMatchingGroup((String)value, (String)REGEX_DEFAULT_VALUE);
        }
        return value;
    }

    private void addPort(PortName portName, String portNumber, Protocol portProtocol) {
        try {
            this.ports.put(portName, Port.of((String)(Integer.parseInt(portNumber) + "/" + portProtocol)));
        }
        catch (Exception e) {
            LOGGER.warn("Invalid port definition in application-boxfuse.properties (" + portName + " -> " + portNumber + "): " + e.getMessage());
        }
    }

    private String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ("/".equals(path)) {
            return "";
        }
        return path;
    }

    private String noTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public Map<PortName, Port> getPorts() {
        return this.ports;
    }

    public PortName getPayloadPort() {
        return this.payloadPort;
    }

    public Path getPayloadPath() {
        return this.payloadPath;
    }

    public PortName getHealthcheckPort() {
        return this.healthcheckPort;
    }

    public Path getHealthcheckPath() {
        return this.healthcheckPath;
    }

    public String getDataSourceUrl() {
        return this.dataSourceUrl;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getSslKeyStore() {
        return this.sslKeyStore;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }
}

