/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.tomcat;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.NewRelicConfig;
import com.boxfuse.generator.builder.ramdisk.jvm.tomcat.TomcatPayload;
import com.boxfuse.generator.payload.FilePayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public class TomcatWarPayload
extends FilePayload
implements TomcatPayload {
    private static final String JAVAAGENTS_ARCHIVE_ROOT = "WEB-INF/javaagents/";
    private final boolean customJRE;

    public static boolean supports(String name, PayloadFormat format, boolean live) {
        return name.endsWith(".war") && PayloadFormat.ZIP == format && !live;
    }

    public TomcatWarPayload(File file, byte[] bytes, Map<String, PayloadEntry> entries) {
        super(file, bytes, entries);
        this.customJRE = entries.containsKey("WEB-INF/jre/bin/java");
    }

    @Override
    public PayloadType getType() {
        return PayloadType.TOMCAT;
    }

    @Override
    public Collection<String> getJavaAgents() {
        ArrayList<String> javaAgents = new ArrayList<String>();
        for (String entry : this.entries.keySet()) {
            if (!entry.matches("WEB-INF/javaagents/.+\\.jar") || entry.substring(JAVAAGENTS_ARCHIVE_ROOT.length()).contains("/")) continue;
            javaAgents.add("/tomcat/webapps/ROOT/" + entry);
        }
        return javaAgents;
    }

    @Override
    public NewRelicConfig getNewRelicConfig() {
        String config = ZipUtils.unzipSingleEntry((byte[])this.bytes, (String)"WEB-INF/newrelic.yml");
        if (config == null) {
            return null;
        }
        return new NewRelicConfig(config);
    }

    @Override
    public boolean hasCustomJRE() {
        return this.customJRE;
    }

    @Override
    public byte[] getCACerts() {
        byte[] cacerts = ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)"WEB-INF/cacerts");
        if (cacerts == null && this.customJRE) {
            cacerts = ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)"WEB-INF/jre/lib/security/cacerts");
        }
        return cacerts;
    }

    @Override
    public byte[] getLocalPolicyJar() {
        return ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)"WEB-INF/local_policy.jar");
    }

    @Override
    public byte[] getUsExportPolicyJar() {
        return ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)"WEB-INF/US_export_policy.jar");
    }

    @Override
    public byte[] getKeyStore() {
        return ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)"WEB-INF/keystore.jks");
    }

    @Override
    public byte[] getServerXml() {
        return ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)"WEB-INF/server.xml");
    }

    @Override
    public DbType detectDbType() {
        for (DbType dbType : DbType.values()) {
            if (DbType.NONE == dbType) continue;
            String regex = "WEB-INF/lib/" + dbType.getJdbcDriverJarRegex();
            for (String payloadEntry : this.entries.keySet()) {
                if (!payloadEntry.matches(regex)) continue;
                return dbType;
            }
        }
        return DbType.NONE;
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        if (this.entries.containsKey("WEB-INF/sysctl.conf")) {
            return Pair.of(null, (Object)ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)"WEB-INF/sysctl.conf"));
        }
        return null;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        ramDisk.installZipArchive(this.bytes, baseDir, null, null, true, ".*\\." + Pattern.quote("jmxremote.password"));
    }
}

