/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.config;

import com.boxfuse.base.aws.AwsSubnetId;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.config.InstanceId;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ConfigUtils {
    private ConfigUtils() {
    }

    public static Boolean booleanOf(Map<String, String> cfg, String property) {
        String value = cfg.get(property);
        if (value == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            throw new BoxfuseException("Invalid value for " + property + " : " + value + "(must be either true or false)");
        }
    }

    public static Set<InstanceId> instanceIdSetOf(String value) {
        if (value == null) {
            return null;
        }
        TreeSet<InstanceId> result = new TreeSet<InstanceId>();
        for (String instanceProp : StringUtils.delimitedStringToArray((String)value, (String)",")) {
            result.add(new InstanceId(instanceProp));
        }
        return result;
    }

    public static Set<AwsSubnetId> awsSubnetIdSetOf(String value) {
        if (value == null) {
            return null;
        }
        TreeSet<AwsSubnetId> result = new TreeSet<AwsSubnetId>();
        for (String prop : StringUtils.delimitedStringToArray((String)value, (String)",")) {
            result.add(AwsSubnetId.of((String)prop));
        }
        return result;
    }

    public static File fileOf(String name) {
        if (name == null) {
            return null;
        }
        return new File(name);
    }
}

