/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.commandline;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.types.Proxy;
import com.boxfuse.base.util.EnvironmentUtils;
import com.boxfuse.base.util.HttpUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.client.commandline.ColorizeCompositeConverter;
import com.boxfuse.client.core.Boxfuse;
import com.boxfuse.client.core.BoxfuseConnectConfig;
import com.boxfuse.client.core.privateuse.util.ClassUtils;
import com.boxfuse.client.core.privateuse.util.ClientInfo;
import com.boxfuse.client.core.privateuse.util.ConfigUtils;
import com.boxfuse.generator.config.BoxfuseConfig;
import com.boxfuse.generator.config.InstanceId;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final List<String> ENVIRONMENT_SPECIFIC_OPERATIONS = Arrays.asList("cfg", "run", "info", "scale", "ps", "logs", "open", "kill", "deploy");
    private static final Logger LOGGER;

    public static void main(String[] args) {
        boolean debugLogLevel = Main.isFlagSet(args, "X");
        boolean traceLogLevel = Main.isFlagSet(args, "XX");
        boolean machineReadable = Main.isFlagSet(args, "m");
        Main.initLogging(debugLogLevel, traceLogLevel, machineReadable);
        Boxfuse boxfuse = null;
        BoxfuseConfig config = null;
        try {
            TreeMap<String, String> mapConfig = new TreeMap<String, String>();
            String operation = Main.determineOperation(args);
            Boxfuse.printVersion();
            if (Main.isFlagSet(args, "v")) {
                LOGGER.info("");
                LOGGER.info(ClientInfo.getInfo());
                return;
            }
            boolean offline = Main.isFlagSet(args, "o");
            mapConfig.putAll(Main.loadConfig(args, ENVIRONMENT_SPECIFIC_OPERATIONS.contains(operation)));
            BoxfuseConnectConfig connectConfig = new BoxfuseConnectConfig();
            connectConfig.configure(mapConfig);
            boxfuse = new Boxfuse(connectConfig, "CommandLine", false, offline);
            config = boxfuse.createConfig();
            config.configure(mapConfig);
            ConfigUtils.validateConfig(mapConfig);
            if (Main.isFlagSet(args, "u")) {
                Main.downloadUpgrade(boxfuse, connectConfig, offline);
                return;
            }
            if (operation == null || Main.isFlagSet(args, "?") || Main.isFlagSet(args, "help")) {
                Main.printUsage();
                return;
            }
            String operand = Main.determineOperand(args);
            switch (operation) {
                case "versions": {
                    LOGGER.warn("WARNING: versions is deprecated and will be removed in CloudCaptain Client 2.0 -> use inventory instead");
                    Main.inventory(boxfuse, config, operand);
                    return;
                }
                case "inventory": {
                    Main.inventory(boxfuse, config, operand);
                    return;
                }
                case "fuse": {
                    Main.fuse(boxfuse, config, operand);
                    return;
                }
                case "create": {
                    Main.create(boxfuse, config, operand);
                    return;
                }
                case "cfg": {
                    Main.cfg(boxfuse, config, operand);
                    return;
                }
                case "push": {
                    Main.push(boxfuse, config, operand);
                    return;
                }
                case "convert": {
                    Main.convert(boxfuse, config, operand);
                    return;
                }
                case "pull": {
                    Main.pull(boxfuse, config, operand);
                    return;
                }
                case "ls": {
                    Main.ls(boxfuse, config, operand);
                    return;
                }
                case "run": {
                    Main.run(boxfuse, config, operand);
                    return;
                }
                case "info": {
                    Main.info(boxfuse, config, operand);
                    return;
                }
                case "scale": {
                    Main.scale(boxfuse, config, operand);
                    return;
                }
                case "ps": {
                    Main.ps(boxfuse, config, operand);
                    return;
                }
                case "logs": {
                    Main.logs(boxfuse, config, operand);
                    return;
                }
                case "open": {
                    Main.open(boxfuse, config, operand);
                    return;
                }
                case "kill": {
                    Main.kill(boxfuse, config, operand);
                    return;
                }
                case "rm": {
                    Main.rm(boxfuse, config, operand);
                    return;
                }
                case "destroy": {
                    Main.destroy(boxfuse, config, operand);
                    return;
                }
            }
            Main.printUsage();
        }
        catch (BoxfuseException | IllegalArgumentException e) {
            if (debugLogLevel) {
                LOGGER.error("ERROR: " + e.getMessage(), e);
            } else {
                LOGGER.error("ERROR: " + e.getMessage());
            }
            try {
                if (boxfuse != null) {
                    boxfuse.reportClientError(false, config, e);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(1);
        }
        catch (Throwable e) {
            if (debugLogLevel) {
                LOGGER.error("INTERNAL ERROR (" + ClassUtils.getShortName(e.getClass()) + "): " + e.getMessage(), e);
            } else {
                LOGGER.error("INTERNAL ERROR: " + e.getMessage());
            }
            try {
                if (boxfuse != null) {
                    boxfuse.reportClientError(true, config, e);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    private static void downloadUpgrade(Boxfuse boxfuse, BoxfuseConnectConfig config, boolean offline) {
        byte[] bytes;
        if (offline) {
            throw new BoxfuseException("You must be online to upgrade.");
        }
        Pair commandLineUpgradeInfo = boxfuse.getCommandLineUpgradeInfo();
        String updateVersion = (String)commandLineUpgradeInfo.getLeft();
        String updateUrlCommandLine = (String)commandLineUpgradeInfo.getRight();
        if (updateVersion == null) {
            LOGGER.info("Boxfuse is already up to date.");
            return;
        }
        LOGGER.info("Downloading upgrade to version " + updateVersion + " ...");
        try {
            Proxy proxy = (Proxy)config.proxy.get();
            boolean isInsecure = (Boolean)config.insecure.get();
            bytes = HttpUtils.downloadWithProgress((String)updateUrlCommandLine, (Proxy)proxy, (boolean)isInsecure);
        }
        catch (Exception e) {
            throw new BoxfuseException("Unable to download CloudCaptain Client " + updateVersion, (Throwable)e);
        }
        File upgradeDir = new File(Main.getInstallationDir(), "upgrade");
        ShellUtils.mkdir((File)upgradeDir);
        ZipUtils.unzip((byte[])bytes, (File)upgradeDir);
        LOGGER.info("Upgrade will be applied automatically next time the CloudCaptain Client is run");
    }

    private static void inventory(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        if (operand != null) {
            config.component.set((Object[])new ComponentId[]{ComponentId.of((String)operand)});
        }
        boxfuse.inventory(config);
    }

    private static boolean isImage(Boxfuse boxfuse, String operand) {
        return operand != null && operand.contains(":") && boxfuse.validImageCoordinates(operand);
    }

    private static boolean isApp(Boxfuse boxfuse, String operand) {
        return boxfuse.validAppCoordinates(operand);
    }

    static boolean isInstance(String operand) {
        return operand != null && InstanceId.isValid((String)operand);
    }

    private static void create(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        config.app.set((Object[])new AppCoordinates[]{AppCoordinates.of((String)operand, (Owner)config.getOwner())});
        boxfuse.create(config);
    }

    private static void destroy(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        config.app.set((Object[])new AppCoordinates[]{AppCoordinates.of((String)operand, (Owner)config.getOwner())});
        boxfuse.destroy(config);
    }

    private static void cfg(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        config.app.set((Object[])new AppCoordinates[]{AppCoordinates.of((String)operand, (Owner)config.getOwner())});
        boxfuse.cfg(config);
    }

    private static void info(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        config.app.set((Object[])new AppCoordinates[]{AppCoordinates.of((String)operand, (Owner)config.getOwner())});
        boxfuse.info(config);
    }

    private static void run(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.imageAppPayload(boxfuse, config, operand);
        boxfuse.run(config);
    }

    private static void scale(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        if (Main.isApp(boxfuse, operand)) {
            config.app.set((Object[])new AppCoordinates[]{AppCoordinates.of((String)operand, (Owner)config.getOwner())});
        }
        boxfuse.scale(config);
    }

    private static void rm(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.imageApp(boxfuse, config, operand);
        boxfuse.rm(config);
    }

    private static void imageApp(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        if (Main.isImage(boxfuse, operand)) {
            config.image.set((Object[])new ImageCoordinates[]{ImageCoordinates.of((String)operand, (Owner)config.getOwner())});
        } else if (Main.isApp(boxfuse, operand)) {
            config.app.set((Object[])new AppCoordinates[]{AppCoordinates.of((String)operand, (Owner)config.getOwner())});
        }
    }

    private static void kill(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.adjustConfigForOperandAppImageInstance(boxfuse, config, operand);
        boxfuse.kill(config);
    }

    private static void fuse(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        if (operand != null) {
            config.payload.location.set((Object[])new String[]{operand});
        }
        boxfuse.fuse(config);
    }

    private static void push(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.imageApp(boxfuse, config, operand);
        boxfuse.push(config);
    }

    private static void convert(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.imageAppPayload(boxfuse, config, operand);
        boxfuse.convert(config);
    }

    private static void imageAppPayload(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        if (Main.isImage(boxfuse, operand)) {
            config.image.set((Object[])new ImageCoordinates[]{ImageCoordinates.of((String)operand, (Owner)config.getOwner())});
        } else if (Main.isApp(boxfuse, operand)) {
            config.app.set((Object[])new AppCoordinates[]{AppCoordinates.of((String)operand, (Owner)config.getOwner())});
        } else if (operand != null) {
            config.payload.location.set((Object[])new String[]{operand});
        }
    }

    private static void pull(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.imageApp(boxfuse, config, operand);
        boxfuse.pull(config);
    }

    private static void ls(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.imageApp(boxfuse, config, operand);
        boxfuse.ls(config);
    }

    private static void ps(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.adjustConfigForOperandAppImageInstance(boxfuse, config, operand);
        boxfuse.ps(config);
    }

    private static void logs(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.adjustConfigForOperandAppImageInstance(boxfuse, config, operand);
        boxfuse.logs(config);
    }

    private static void open(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        Main.adjustConfigForOperandAppImageInstance(boxfuse, config, operand);
        boxfuse.open(config);
    }

    static void adjustConfigForOperandAppImageInstance(Boxfuse boxfuse, BoxfuseConfig config, String operand) {
        if (Main.isInstance(operand)) {
            config.instances.set((Object[])new Set[]{new TreeSet<InstanceId>(Collections.singletonList(new InstanceId(operand)))});
            if (operand.startsWith("i") && !config.env.isSet()) {
                config.env.set((Object[])new EnvName[]{EnvName.PROD});
            }
        } else {
            Main.imageApp(boxfuse, config, operand);
        }
    }

    private static Map<String, String> loadConfig(String[] args, boolean defaultEnv) {
        TreeMap<String, String> argConfig = new TreeMap<String, String>();
        Main.loadConfiguration(argConfig, args);
        String env = (String)argConfig.get("env");
        if (env == null && defaultEnv) {
            env = "dev";
        }
        TreeMap<String, String> mapConfig = new TreeMap<String, String>();
        ConfigUtils.addConfigFromConfigFile(mapConfig, (File)Main.getInstallationDirConfigFile());
        if (env != null) {
            ConfigUtils.addConfigFromConfigFile(mapConfig, (File)Main.getInstallationDirConfigFile(env));
        }
        ConfigUtils.addConfigFromStandardConfigFiles(mapConfig, (String)env);
        ConfigUtils.addConfigFromConfigFile(mapConfig, (File)Main.getCommandLineArgumentConfigFile(args));
        mapConfig.putAll(argConfig);
        return mapConfig;
    }

    private static void initLogging(boolean debug, boolean trace, boolean machineReadable) {
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.detachAndStopAllAppenders();
        rootLogger.setLevel(Level.INFO);
        Main.updateLoggerLevel("org.apache.http.wire", Level.ERROR);
        Main.updateLoggerLevel("com.amazonaws.http", Level.ERROR);
        Main.updateLoggerLevel("org", Level.INFO);
        Main.updateLoggerLevel("com.boxfuse", Level.INFO);
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ConsoleAppender consoleAppender = new ConsoleAppender();
        rootLogger.addAppender((Appender)consoleAppender);
        String encoding = System.getProperty("sun.stdout.encoding", "UTF-8");
        if ("cp65001".equalsIgnoreCase(encoding)) {
            encoding = "UTF-8";
        }
        consoleAppender.setWithJansi(true);
        String pattern = "%m%n";
        if (machineReadable) {
            EnvironmentUtils.setOutputMachineReadable((boolean)true);
            ArrayList<ch.qos.logback.classic.Logger> loggers = new ArrayList<ch.qos.logback.classic.Logger>(loggerContext.getLoggerList());
            loggers.add(rootLogger);
            for (ch.qos.logback.classic.Logger logger : loggers) {
                logger.setLevel(Level.ERROR);
            }
        } else if (debug || trace) {
            Main.updateLoggerLevel("com.boxfuse", debug ? Level.DEBUG : Level.TRACE);
            pattern = "%d{HH:mm:ss.SSS} %m%n";
        }
        Main.registerColorizeConverter();
        pattern = "%colorize(" + pattern + ")";
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern(pattern);
        encoder.setCharset(Charset.forName(encoding));
        encoder.start();
        consoleAppender.setEncoder((Encoder)encoder);
        consoleAppender.setContext((Context)loggerContext);
        consoleAppender.start();
        Main.updateLoggerLevel("boxfuse.logs", Level.DEBUG);
        Main.updateLoggerLevel("boxfuse.machinereadable", machineReadable ? Level.INFO : Level.OFF);
    }

    static void registerColorizeConverter() {
        PatternLayout.defaultConverterMap.put("colorize", ColorizeCompositeConverter.class.getName());
    }

    private static void updateLoggerLevel(String loggerName, Level newLevel) {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)loggerName)).setLevel(newLevel);
    }

    private static void printUsage() {
        LOGGER.info("Usage");
        LOGGER.info("=====");
        LOGGER.info("boxfuse <<command>> [operand] [options]");
        LOGGER.info("");
        LOGGER.info("Example: boxfuse run hello-1.0.war");
        LOGGER.info("");
        LOGGER.info("Commands");
        LOGGER.info("--------");
        LOGGER.info("create [app]             Creates an App in the Boxfuse Console");
        LOGGER.info("info [app]               Displays info about an App in the specified environment");
        LOGGER.info("cfg [app]                Configures an App in the specified environment");
        LOGGER.info("fuse [payload]           Fuses a Payload into an Image");
        LOGGER.info("ls                       Lists all Images on your machine or in the Boxfuse Vault");
        LOGGER.info("scale [app]              Scales an app to the specified capacity in an environment");
        LOGGER.info("run [payload | image]    Runs instances of the Image in the specified environment");
        LOGGER.info("logs [instance]          Displays the logs for the Instance");
        LOGGER.info("open [instance]          Opens a web browser at the url of the Payload of an Instance");
        LOGGER.info("ps                       Lists all running Instances on your machine");
        LOGGER.info("kill [instance]          Kills the specified Instance");
        LOGGER.info("push [image]             Pushes this Image to the Boxfuse Vault");
        LOGGER.info("convert [image]          Converts this Image from the Boxfuse Vault into an AWS AMI");
        LOGGER.info("pull [image]             Pulls this Image from the Boxfuse Vault");
        LOGGER.info("rm [image]               Removes this Image from your machine or the Boxfuse Vault");
        LOGGER.info("destroy [app]            Destroys an App in the Boxfuse Console");
        LOGGER.info("inventory [component]    Lists all versions of a Component available in the Inventory");
        LOGGER.info("");
        LOGGER.info("Operands");
        LOGGER.info("--------");
        LOGGER.info("[component]              The Component to use. (ex.: tomcat, openjdk, ...)");
        LOGGER.info("[app]                    The App to use.");
        LOGGER.info("[payload]                The Payload to use. Can be a file, directory or URL");
        LOGGER.info("[image]                  The Image to use in the format owner/app:version");
        LOGGER.info("[instance]               The id of the Instance to use");
        LOGGER.info("");
        LOGGER.info("App settings");
        LOGGER.info("------------");
        LOGGER.info("-app.type=...            Create a single-instance, load-balanced or worker app");
        LOGGER.info("-tls.type=...            The type of TLS (SSL) certificate management to use with an app");
        LOGGER.info("-db.type=...             The type of database to use with an app");
        LOGGER.info("-logs.type=...           The type of centralized logging to use with an app");
        LOGGER.info("-domain=...              The custom domain to use for an app in a certain environment");
        LOGGER.info("-capacity=...            The capacity to scale an app to in a certain environment");
        LOGGER.info("-securitygroup=...       The id of the AWS security group to use");
        LOGGER.info("-instanceprofile=...     The name of the AWS instance profile to use");
        LOGGER.info("-subnets=...             Comma-separated list of AWS subnets to deploy to in the specified environment");
        LOGGER.info("-elasticip=...           The AWS Elastic IP to use (single-instance apps only)");
        LOGGER.info("-elb=...                 The AWS ELB to use (load-balanced apps only)");
        LOGGER.info("-targetgroup=...         The AWS Target Group to use (load-balanced-https apps only)");
        LOGGER.info("-tags.<KEY>=value        The map of custom tags <key, value> pairs to apply to AWS resources");
        LOGGER.info("");
        LOGGER.info("Image settings");
        LOGGER.info("--------------");
        LOGGER.info("-components.<NAME>=...   The version of the component with this name to include");
        LOGGER.info("-cmd=...                 The command to run to start the payload");
        LOGGER.info("-debug                   Start the Payload in debug mode when an Instance launches");
        LOGGER.info("-debug.wait              Whether the JVM should wait for the debugger to connect");
        LOGGER.info("-jvm.args=...            Extra arguments to pass to the JVM");
        LOGGER.info("-jvm.main.class=...      Main class to invoke on JVM startup");
        LOGGER.info("-jvm.main.args=...       Arguments to pass to the main class");
        LOGGER.info("-jvm.jmx                 Enables the JMX remote management interface for the JVM");
        LOGGER.info("-linux.args              The arguments to pass from the bootloader to the Linux kernel (experts only)");
        LOGGER.info("-live                    Enables live reloading of changes in dev");
        LOGGER.info("-healthcheck             Checks whether to payload started correctly");
        LOGGER.info("-healthcheck.port=<NAME> The name of the port to perform the healthcheck against");
        LOGGER.info("-healthcheck.path=...    The path to check whether to payload started correctly");
        LOGGER.info("-healthcheck.timeout=... The number of seconds to wait for the Payload to come up");
        LOGGER.info("-newrelic.licensekey=... Install and configure New Relic agents with this license key");
        LOGGER.info("-payload.port=<NAME>     The name of the main port on which the payload starts");
        LOGGER.info("-payload.path=...        The path where the payload starts");
        LOGGER.info("-ports.<NAME>=...        Expose the port with this name (Format:1234/tcp)");
        LOGGER.info("-tmp=...                 The amount of temp space to allocate to /tmp in GB");
        LOGGER.info("-vault                   Perform the operation on the Boxfuse Vault instead of locally");
        LOGGER.info("");
        LOGGER.info("Instance settings");
        LOGGER.info("-----------------");
        LOGGER.info("-env=dev|test|prod        Select the AWS test/prod environments or the local dev one");
        LOGGER.info("-envvars.<NAME>=value     Passes the environment variable into an Instance");
        LOGGER.info("-logs.auto                Whether to automatically display the instance logs on startup");
        LOGGER.info("-logs.boot                Whether to display the instance boot logs");
        LOGGER.info("-logs.dir=...             The directory to redirect the VirtualBox instance boot logs to");
        LOGGER.info("-logs.filter.<NAME>=value The filter to apply when viewing the application logs");
        LOGGER.info("-logs.layout=...          The layout to use when displaying the logs");
        LOGGER.info("-logs.tail                Whether the logs command should tail the incoming messages");
        LOGGER.info("-db                       Whether to open a DB connection instead of a browser window");
        LOGGER.info("");
        LOGGER.info("dev environment settings");
        LOGGER.info("------------------------");
        LOGGER.info("-cpus=...                The number of CPUs to assign to an Instance");
        LOGGER.info("-ram=...                 The amount of RAM in MB to assign to an Instance");
        LOGGER.info("-portsmap.<NAME>=number  The local ports to forward to the running Payload");
        LOGGER.info("-platform=...            The hypervisor platform to use (auto, virtualbox or hyperv)");
        LOGGER.info("-virtualbox.natnetwork   Whether to use the VirtualBox NAT Network networking mode");
        LOGGER.info("-windows.user=...        The Windows user of your machine (Hyper-V live images only)");
        LOGGER.info("-windows.password=...    The Windows password of your machine (Hyper-V live images only)");
        LOGGER.info("");
        LOGGER.info("Other options");
        LOGGER.info("-------------");
        LOGGER.info("-configfile=...          The configuration file to load");
        LOGGER.info("-proxy=...               The proxy to use (format: https://user:pwd@host:port)");
        LOGGER.info("-insecure                Disable TLS certificate validation");
        LOGGER.info("-X                       Output debug log messages");
        LOGGER.info("-m                       Make the output machine-readable (JSON)");
        LOGGER.info("-o                       Work offline");
        LOGGER.info("-u                       Upgrade to the latest CloudCaptain Client version");
        LOGGER.info("-v                       Print the version and exit");
        LOGGER.info("");
        LOGGER.info("All options also configurable in " + Main.getInstallationDirConfigFile().getAbsolutePath());
        LOGGER.info("More info available at https://cloudcaptain.sh/docs/commandline");
    }

    private static File getCommandLineArgumentConfigFile(String[] args) {
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg) || !"configfile".equals(Main.getArgumentProperty(arg))) continue;
            return new File(Main.getArgumentValue(arg));
        }
        return null;
    }

    private static File getInstallationDirConfigFile() {
        return Main.getInstallationDirConfigFile(null);
    }

    private static File getInstallationDirConfigFile(String env) {
        String path = Main.getInstallationDir() + "/conf/boxfuse" + (env == null ? "" : "-" + env) + ".conf";
        try {
            return new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new BoxfuseBugException("Unable to detect path of config file: " + path, (Throwable)e);
        }
    }

    private static String getInstallationDir() {
        String path = ClassUtils.getLocationOnDisk(Main.class);
        return path.substring(0, path.lastIndexOf("/")) + "/..";
    }

    static void loadConfiguration(Map<String, String> mapConfig, String[] args) {
        for (String arg : args) {
            if (arg.startsWith("--")) {
                LOGGER.warn("Ignoring invalid argument " + arg + " => arguments must start with - instead of --");
                continue;
            }
            if (Main.isPropertyArgument(arg)) {
                mapConfig.put(Main.getArgumentProperty(arg), Main.getArgumentValue(arg));
                continue;
            }
            if (!Main.isFlagArgument(arg)) continue;
            mapConfig.put(arg.substring(1), "true");
        }
    }

    private static boolean isFlagSet(String[] args, String flag) {
        for (String arg : args) {
            if (!("-" + flag).equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFlagArgument(String arg) {
        return arg.startsWith("-") && !arg.contains("=");
    }

    private static boolean isPropertyArgument(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    private static String getArgumentProperty(String arg) {
        int index = arg.indexOf("=");
        return arg.substring(1, index);
    }

    private static String getArgumentValue(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length()) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static String determineOperation(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            return arg;
        }
        return null;
    }

    private static String determineOperand(String[] args) {
        boolean operationSkipped = false;
        for (String arg : args) {
            if (arg.startsWith("\u2013")) {
                throw new BoxfuseException("Found argument starting with long dash (\u2013 => unicode U+2013) instead of dash (-): " + arg + " => use a regular dash instead");
            }
            if (arg.startsWith("-")) continue;
            if (!operationSkipped) {
                operationSkipped = true;
                continue;
            }
            return arg;
        }
        return null;
    }

    static {
        AnsiConsole.systemInstall();
        LOGGER = LoggerFactory.getLogger(Main.class);
    }
}

