/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.joliet.impl;

import com.github.stephenc.javaisotools.iso9660.FilenameDataReference;
import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.joliet.impl.JolietFilenameDataReference;
import com.github.stephenc.javaisotools.joliet.impl.JolietNamingConventions;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.io.UnsupportedEncodingException;

public class JolietLayoutHelper
extends LayoutHelper {
    public JolietLayoutHelper(StreamHandler streamHandler, ISO9660RootDirectory root) {
        super(streamHandler, root, new JolietNamingConventions());
    }

    public FilenameDataReference getFilenameDataReference(ISO9660Directory dir) throws HandlerException {
        return new JolietFilenameDataReference(dir);
    }

    public FilenameDataReference getFilenameDataReference(ISO9660File file) throws HandlerException {
        return new JolietFilenameDataReference(file);
    }

    public byte[] pad(String string, int targetByteLength) throws HandlerException {
        byte[] bytes = new byte[targetByteLength];
        byte[] original = null;
        int length = 0;
        try {
            int i;
            if (string != null) {
                original = string.getBytes("UTF-16BE");
                length = original.length;
            }
            for (i = 0; i < length; ++i) {
                bytes[i] = original[i];
            }
            for (i = length; i < bytes.length; ++i) {
                bytes[i] = 0;
                if (++i >= bytes.length) continue;
                bytes[i] = 32;
            }
            bytes[bytes.length - 1] = 0;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return bytes;
    }
}

