/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.Template;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.RamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.JvmPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.NewRelicConfig;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JvmRamDiskBuilder<P extends JvmPayload>
extends RamDiskBuilder<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmRamDiskBuilder.class);
    protected static final String NATIVE_DIRECTORY = "native";
    protected static final String JRE_DIRECTORY = "jre";
    private static final String JAVA_EXE = "/jre/bin/java ";
    private static final String JAVA_ARGS = "${xmx} -XX:OnOutOfMemoryError=\"killall -3 java\" -Djavax.net.ssl.trustStore=/cacerts/cacerts -Djavax.net.ssl.trustStorePassword=changeit -Djava.awt.headless=true -Dfile.encoding=UTF-8 -Djava.net.preferIPv4Stack=true -Djava.security.egd=file:/dev/./urandom -Djdk.reflect.allowGetCallerClass=true ${debug} ${jmx} ${jvmsysprops} ";
    public static final String JMXREMOTE_PASSWORD_FILE = "jmxremote.password";
    private final Component libpng = this.getComponent(ComponentId.LIBPNG);
    private final Component zlib = this.getComponent(ComponentId.ZLIB);
    private final Component freetype = this.getComponent(ComponentId.FREETYPE);
    private final Component ttf_bitstream_vera = this.getComponent(ComponentId.TTF_BITSTREAM_VERA);
    private Component springloaded;
    private Component newrelic_java;
    private Component openjdk;
    private byte[] cacertsBytes;
    private boolean customJRE;
    private boolean oldJRE;

    public JvmRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
        this.components.addAll(Arrays.asList(this.libpng, this.zlib, this.freetype, this.ttf_bitstream_vera));
        if (spec.isLive()) {
            this.springloaded = this.getComponent(ComponentId.SPRINGLOADED);
            this.components.add(this.springloaded);
        }
    }

    @Override
    protected void doAdjustSpecBasedOnConfig() {
        this.customJRE = ((JvmPayload)this.payload).hasCustomJRE();
        if (!this.customJRE) {
            this.openjdk = this.getComponent(ComponentId.OPENJDK);
            this.oldJRE = this.openjdk.getVersion().compareTo(new Version("9.0.0")) < 0;
            this.components.add(this.openjdk);
        } else if (!this.messagesDisplayed) {
            LOGGER.debug("Overriding OpenJDK JRE with custom JRE included in payload ...");
        }
        this.cacertsBytes = ((JvmPayload)this.payload).getCACerts();
        if (this.cacertsBytes != null && !this.messagesDisplayed) {
            LOGGER.debug("Overriding default cacerts with cacerts included in payload ...");
        }
        NewRelicConfig newRelicConfig = ((JvmPayload)this.payload).getNewRelicConfig();
        if (this.spec.getNewRelicLicenseKey() == null && newRelicConfig != null) {
            this.spec.setNewRelicLicenseKey(newRelicConfig.getLicenseKey());
        }
        if (this.spec.getNewRelicLicenseKey() != null) {
            if (!this.messagesDisplayed) {
                LOGGER.debug("Detected New Relic config");
            }
            this.newrelic_java = this.getComponent(ComponentId.NEWRELIC_JAVA);
            this.components.add(this.newrelic_java);
        }
    }

    @Override
    public final void doBuild() throws IOException {
        this.ramDisk.installTarGzArchive(this.libpng.getBytes(), "");
        this.ramDisk.installTarGzArchive(this.zlib.getBytes(), "");
        this.ramDisk.installTarGzArchive(this.freetype.getBytes(), "");
        this.installJRE();
        if (this.spec.getNewRelicLicenseKey() != null) {
            this.installNewRelicJavaAgent();
        }
        this.installJavaAgents();
    }

    private void installJRE() throws IOException {
        if (this.customJRE) {
            this.installCustomJRE();
        } else {
            this.installOpenJDK();
        }
        this.installCacerts();
    }

    protected abstract void installCustomJRE() throws IOException;

    private void installOpenJDK() throws IOException {
        this.ramDisk.createDir(JRE_DIRECTORY);
        if (this.oldJRE) {
            byte[] usExportPolicyJar;
            this.ramDisk.createDir("jre/lib");
            this.ramDisk.createDir("jre/lib/security");
            byte[] localPolicyJar = ((JvmPayload)this.payload).getLocalPolicyJar();
            if (localPolicyJar != null) {
                LOGGER.debug("Overriding JRE local_policy.jar with version included in payload ...");
                this.ramDisk.createFile("jre/lib/security/local_policy.jar", false, localPolicyJar);
            }
            if ((usExportPolicyJar = ((JvmPayload)this.payload).getUsExportPolicyJar()) != null) {
                LOGGER.debug("Overriding JRE US_export_policy.jar with version included in payload ...");
                this.ramDisk.createFile("jre/lib/security/US_export_policy.jar", false, usExportPolicyJar);
            }
        }
        this.ramDisk.installTarGzArchive(this.openjdk.getBytes(), "jre/");
        String jreConfDir = this.oldJRE ? "lib" : "conf";
        this.ramDisk.createFile("jre/" + jreConfDir + "/management/" + JMXREMOTE_PASSWORD_FILE, false, "boxfuse  boxfuse");
        this.ramDisk.createSymLink("jre/lib/amd64/libfreetype.so.6", "/usr/lib/x86_64-linux-gnu/libfreetype.so.6");
        this.ramDisk.createDir("ttf-bitstream-vera");
        this.ramDisk.installTarGzArchive(this.ttf_bitstream_vera.getBytes(), "ttf-bitstream-vera/");
        this.ramDisk.createDir("jre/lib/fonts");
        this.ramDisk.createSymLink("jre/lib/fonts/LucidaSansRegular.ttf", "/ttf-bitstream-vera/Vera.ttf");
        this.ramDisk.createSymLink("jre/lib/fonts/fallback", "/ttf-bitstream-vera");
        this.ramDisk.createSymLink("jre/lib/fontconfig.properties", "/ttf-bitstream-vera/fontconfig.properties");
    }

    @Override
    protected void installCacerts() throws IOException {
        if (this.cacertsBytes != null) {
            this.ramDisk.createFile("cacerts/cacerts", false, this.cacertsBytes);
        }
        super.installCacerts();
    }

    private void installNewRelicJavaAgent() throws IOException {
        String config = ((JvmPayload)this.payload).getNewRelicConfig() == null ? "common:\n  license_key: '" + this.spec.getNewRelicLicenseKey() + "'" : ((JvmPayload)this.payload).getNewRelicConfig().getConfig();
        this.ramDisk.createFile("newrelic/newrelic.yml", false, config);
        this.ramDisk.installZipArchive(this.newrelic_java.getBytes(), "newrelic/");
    }

    @Override
    protected void doGenerateEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        String jvmArgs = this.spec.getJvm().getJvmArgs();
        envVars.put(EnvVarName.BOXFUSE_JVM_ARGS, EnvVarValue.flexi((String)jvmArgs));
        envVars.put(EnvVarName.BOXFUSE_JVM_MAIN_CLASS, EnvVarValue.flexi((String)this.spec.getJvm().getMainClass()));
        envVars.put(EnvVarName.BOXFUSE_JVM_MAIN_ARGS, EnvVarValue.flexi((String)this.spec.getJvm().getMainArgs()));
        envVars.put(EnvVarName.BOXFUSE_JVM_JMX, EnvVarValue.flexi((String)("" + this.spec.getJvm().isJmx())));
        if (this.spec.getNewRelicLicenseKey() != null) {
            envVars.put(EnvVarName.of((String)"NEW_RELIC_LOG"), EnvVarValue.asIs((String)"STDOUT"));
        }
    }

    protected Collection<String> getRuntimeJavaAgents() {
        return Collections.emptyList();
    }

    protected abstract String computeJvmExtraArgs();

    protected abstract void adjustEnvVars(Map<EnvVarName, EnvVarValue> var1);

    private void installJavaAgents() throws IOException {
        this.ramDisk.createDir("javaagents");
        if (this.spec.isLive()) {
            this.ramDisk.createFile("javaagents/springloaded.jar", false, this.springloaded.getBytes());
        }
    }

    @Override
    protected String createLaunchScript(String straceCmd, Map<EnvVarName, EnvVarValue> envVars) {
        StringBuilder agents = new StringBuilder();
        if (this.spec.isLive()) {
            agents.append("-javaagent:/javaagents/springloaded.jar -noverify ");
        }
        if (this.spec.getNewRelicLicenseKey() != null) {
            agents.append("-javaagent:/newrelic/newrelic/newrelic.jar -Dnewrelic.config.file=/newrelic/newrelic.yml ");
        }
        ArrayList<String> allJavaAgents = new ArrayList<String>();
        allJavaAgents.addAll(this.getRuntimeJavaAgents());
        allJavaAgents.addAll(((JvmPayload)this.payload).getJavaAgents());
        for (String agent : allJavaAgents) {
            agents.append("-javaagent:").append(agent).append(" ");
        }
        this.adjustEnvVars(envVars);
        String jvmExtraArgs = this.computeJvmExtraArgs();
        String javaCmd = JvmRamDiskBuilder.createJavaCmd(agents.toString(), jvmExtraArgs).replace("\"", "\\\"");
        return Template.process((String)"generator/launch-jvm.template", (Object[])new Object[]{this.getStartDir(), javaCmd, straceCmd});
    }

    static String createJavaCmd(String agents, String jvmExtraArgs) {
        return StringUtils.collectionToDelimitedString(Arrays.asList(JAVA_EXE, agents, JAVA_ARGS, jvmExtraArgs, EnvVarName.BOXFUSE_JVM_ARGS.quote(), EnvVarName.BOXFUSE_JVM_MAIN_CLASS.quote(), EnvVarName.BOXFUSE_JVM_MAIN_ARGS.quote()), (String)" ");
    }

    @Override
    protected void addAdditionalPreCmds(List<String> preCmds) {
        super.addAdditionalPreCmds(preCmds);
        if (((JvmPayload)this.payload).getNewRelicConfig() == null) {
            preCmds.add("export NEW_RELIC_APP_NAME=\"$BOXFUSE_APP ($BOXFUSE_ENV)\"");
        }
    }

    @Override
    protected final DbType detectDbType() {
        return ((JvmPayload)this.payload).detectDbType();
    }

    @Override
    protected String extraPathDirs() {
        return ":/native/bin";
    }

    @Override
    protected String extraLdLibraryPathDirs() {
        return ":/native/lib";
    }
}

