/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm;

import com.boxfuse.base.util.CollectionUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.newrelic.NewRelicLicenseKey;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class NewRelicConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewRelicConfig.class);
    private final String config;

    public NewRelicConfig(String config) {
        this.config = config;
    }

    public NewRelicLicenseKey getLicenseKey() {
        try {
            for (Object o : new Yaml().loadAll(this.config)) {
                Map flat;
                String licenseKey;
                Map yml = (Map)o;
                if (yml == null || !StringUtils.hasLength((String)(licenseKey = (String)(flat = CollectionUtils.flattenMap((Map)yml)).get("common.license_key")))) continue;
                return new NewRelicLicenseKey(licenseKey);
            }
            LOGGER.warn("Unable to detect NewRelic license key in newrelic.yml");
        }
        catch (YAMLException e) {
            LOGGER.warn("Unable to read NewRelic license key from newrelic.yml : " + e.getMessage());
        }
        return null;
    }

    public String getConfig() {
        return this.config;
    }
}

