/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar;

import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.builder.certificate.CertificateManager;
import com.boxfuse.generator.builder.ramdisk.jvm.JvmRamDiskBuilder;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.ManifestUtils;
import com.boxfuse.generator.image.ImageSpecImpl;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.Inventory;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarRamDiskBuilder<P extends JarPayload>
extends JvmRamDiskBuilder<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarRamDiskBuilder.class);

    public JarRamDiskBuilder(CertificateManager certificateManager, Inventory inventory, ImageSpecImpl spec, Collection<Component> virtualDiskComponents) {
        super(certificateManager, inventory, spec, virtualDiskComponents);
    }

    @Override
    protected void doAdjustSpecBasedOnConfig() {
        super.doAdjustSpecBasedOnConfig();
        Map<PortName, Port> ports = this.spec.getPorts();
        if (ports.isEmpty()) {
            if (!this.messagesDisplayed) {
                LOGGER.debug("Auto-configured " + PortName.HTTP + " port to " + Port.HTTP);
            }
            ports.put(PortName.HTTP, Port.HTTP);
        }
    }

    @Override
    protected void installPayloadWithDependencies() throws IOException {
        ((JarPayload)this.payload).installInto(this.ramDisk, "app");
        if (this.spec.getTlsType() == TlsType.ACM) {
            this.ramDisk.createFile("app-config/boxfuse-selfsigned.jks", false, IOUtils.copyToByteArray((String)"generator/selfsigned/boxfuse-selfsigned.jks"));
        }
    }

    @Override
    protected String getStartDir() {
        return "/app";
    }

    @Override
    protected String computeJvmExtraArgs() {
        String classPath = ((JarPayload)this.payload).getClassPath();
        if (StringUtils.hasLength((String)classPath)) {
            return "-cp \"" + classPath + "\"";
        }
        return "";
    }

    @Override
    protected void adjustEnvVars(Map<EnvVarName, EnvVarValue> envVars) {
        if (!StringUtils.hasLength((String)this.spec.getJvm().getMainClass())) {
            String mainClass = this.getMainClass();
            if (mainClass == null) {
                throw new BoxfuseException("No main class specified for Jar Payload: " + this.spec.getPayload().getFile().getAbsolutePath() + " => set jvm.main.class or make sure the Jar contains a manifest with a valid Main-Class attribute");
            }
            this.putIfAbsent(envVars, EnvVarName.BOXFUSE_JVM_MAIN_CLASS, EnvVarValue.flexi((String)mainClass));
        }
    }

    protected String getMainClass() {
        return ManifestUtils.getMainClass(((JarPayload)this.payload).getManifest());
    }

    @Override
    protected void installCustomJRE() throws IOException {
        ((JarPayload)this.payload).installCustomJREInto(this.ramDisk, "jre");
    }

    @Override
    protected void installNativeBinariesAndLibs() throws IOException {
        ((JarPayload)this.payload).installNativeBinariesAndLibsInto(this.ramDisk, "native");
    }
}

