/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot;

import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.JarJarPayload;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.ManifestUtils;
import com.boxfuse.generator.builder.ramdisk.jvm.jar.springboot.SpringBootPayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootJarWarPayload
extends JarJarPayload
implements SpringBootPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootJarWarPayload.class);
    private String libDir;
    private final PayloadType payloadType;
    private final boolean springBoot1;

    public static boolean supports(String name, PayloadFormat format, byte[] bytes, Map<String, PayloadEntry> entries, boolean live) {
        if (PayloadFormat.ZIP == format && SpringBootJarWarPayload.containsSpringBootJars(entries) && !live) {
            if (name.endsWith(".war")) {
                byte[] manifest = ManifestUtils.extractManifest(bytes);
                return manifest != null && ManifestUtils.getMainClass(manifest) != null;
            }
            return name.endsWith(".jar");
        }
        return false;
    }

    private static boolean containsSpringBootJars(Map<String, PayloadEntry> entries) {
        for (String entry : entries.keySet()) {
            if (!entry.startsWith("lib/spring-boot-") && !entry.startsWith("BOOT-INF/lib/spring-boot-") && !entry.startsWith("WEB-INF/lib/spring-boot-")) continue;
            return true;
        }
        return false;
    }

    public SpringBootJarWarPayload(File file, byte[] bytes, Map<String, PayloadEntry> entries) {
        super(file, bytes, entries);
        if (StringUtils.containsMatching(entries.keySet(), (String)"WEB-INF/lib/spring-boot-.*\\.jar")) {
            this.springBoot1 = true;
            this.classesDir = "WEB-INF/classes/";
            this.libDir = "WEB-INF/lib/";
            if (this.containsJHipster()) {
                LOGGER.debug("Detected JHipster war");
                this.payloadType = PayloadType.JHIPSTER;
            } else {
                LOGGER.debug("Detected Spring Boot war");
                this.payloadType = PayloadType.SPRINGBOOT;
            }
        } else {
            String springBootVersion;
            if (StringUtils.containsMatching(entries.keySet(), (String)"BOOT-INF/lib/spring-boot-.*\\.jar")) {
                if (StringUtils.containsMatching(entries.keySet(), (String)"BOOT-INF/lib/spring-boot-2.*\\.jar")) {
                    this.springBoot1 = false;
                    springBootVersion = "2.0 or newer";
                } else {
                    this.springBoot1 = true;
                    springBootVersion = "1.4 or newer";
                }
                this.classesDir = "BOOT-INF/classes/";
                this.libDir = "BOOT-INF/lib/";
            } else {
                this.springBoot1 = true;
                springBootVersion = "1.3 or older";
                this.classesDir = "";
                this.libDir = "lib/";
            }
            if (this.containsGrailsJars()) {
                LOGGER.debug("Detected Grails jar (using Spring Boot " + springBootVersion + ")");
                this.payloadType = PayloadType.GRAILS;
            } else {
                LOGGER.debug("Detected Spring Boot " + springBootVersion + " jar");
                this.payloadType = PayloadType.SPRINGBOOT;
            }
        }
    }

    @Override
    public PayloadType getType() {
        return this.payloadType;
    }

    private boolean containsGrailsJars() {
        return StringUtils.containsMatching(this.entries.keySet(), (String)(this.libDir + "grails-core-.*\\.jar"));
    }

    private boolean containsJHipster() {
        return StringUtils.containsMatching(this.entries.keySet(), (String)(this.libDir + "jhipster-.*\\.jar")) || StringUtils.containsMatching(this.entries.keySet(), (String)(this.classesDir + ".*/config/JHipsterProperties.class"));
    }

    @Override
    public DbType detectDbType() {
        for (DbType dbType : DbType.values()) {
            if (DbType.NONE == dbType || !StringUtils.containsMatching(this.entries.keySet(), (String)(this.libDir + dbType.getJdbcDriverJarRegex()))) continue;
            return dbType;
        }
        return DbType.NONE;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        super.installInto(ramDisk, baseDir);
        for (String entry : this.entries.keySet()) {
            if (!entry.startsWith(this.classesDir) || entry.substring(this.classesDir.length()).contains("/") || !entry.endsWith(".jks") && !entry.endsWith(".keystore")) continue;
            byte[] entryBytes = ZipUtils.unzipSingleEntryToByteArray((byte[])this.bytes, (String)entry);
            ramDisk.createFile("app/" + entry, false, entryBytes);
        }
    }

    @Override
    public boolean isSpringBoot1() {
        return this.springBoot1;
    }

    @Override
    public boolean hasActuator() {
        return StringUtils.containsMatching(this.entries.keySet(), (String)(this.libDir + "spring-boot-actuator-.*\\.jar"));
    }

    @Override
    public String getConfigFile(String name) {
        return ZipUtils.unzipSingleEntry((byte[])this.bytes, (String)(this.classesDir + name));
    }

    @Override
    public String getMainClass() {
        return ManifestUtils.getMainClass(this.getManifest());
    }
}

