/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.image;

import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.enums.PlatformType;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.metadata.ImageMetadata;
import com.boxfuse.base.metadata.MetadataReader;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.HealthcheckTimeout;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.types.TmpGB;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.JsonUtils;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.generator.image.Image;
import com.boxfuse.generator.image.MetadataImage;
import com.boxfuse.generator.image.spec.ImageSpec;
import com.boxfuse.generator.image.spec.JvmSpec;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.payload.Payload;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class LocalImage
implements Image {
    public static final String IMAGE_EXTENSION = ".boxfuse";
    private final Image wrapped;
    private final File file;
    private boolean destroyed;
    private final Map<String, Object> manifest;

    public LocalImage(File imageFile) {
        this.file = imageFile;
        String id = imageFile.getName().replace(IMAGE_EXTENSION, "");
        try {
            String manifestStr = ZipUtils.unzipSingleEntry((File)this.file, (String)(id + ".manifest"));
            this.manifest = JsonUtils.jsonToMap((String)manifestStr);
            this.wrapped = new MetadataImage(MetadataReader.toMetadata((ImageCoordinates)new ImageCoordinates("unknown/unknown:0"), (String)manifestStr));
        }
        catch (BoxfuseException e) {
            throw new BoxfuseException("Unable to read manifest from Image: " + this.file.getAbsolutePath(), e.getCause());
        }
    }

    @Override
    public ImageMetadata getMetadata() {
        return this.wrapped.getMetadata();
    }

    @Override
    public String getId() {
        return this.wrapped.getId();
    }

    @Override
    public Version getBoxfuseVersion() {
        return this.wrapped.getBoxfuseVersion();
    }

    @Override
    public ImageCoordinates getCoordinates() {
        return this.wrapped.getCoordinates();
    }

    @Override
    public PlatformType[] getPlatforms() {
        return this.wrapped.getPlatforms();
    }

    @Override
    public boolean isLive() {
        return this.wrapped.isLive();
    }

    @Override
    public Payload getPayload() {
        return this.wrapped.getPayload();
    }

    @Override
    public Path getPayloadPath() {
        return this.wrapped.getPayloadPath();
    }

    @Override
    public PortName getPayloadPort() {
        return this.wrapped.getPayloadPort();
    }

    @Override
    public AppType getAppType() {
        return this.wrapped.getAppType();
    }

    @Override
    public DbType getDbType() {
        return this.wrapped.getDbType();
    }

    @Override
    public LogsType getLogsType() {
        return this.wrapped.getLogsType();
    }

    @Override
    public Map<PortName, Port> getPorts() {
        return this.wrapped.getPorts();
    }

    @Override
    public boolean isHealthcheck() {
        return this.wrapped.isHealthcheck();
    }

    @Override
    public Path getHealthcheckPath() {
        return this.wrapped.getHealthcheckPath();
    }

    @Override
    public PortName getHealthcheckPort() {
        return this.wrapped.getHealthcheckPort();
    }

    @Override
    public HealthcheckTimeout getHealthcheckTimeout() {
        return this.wrapped.getHealthcheckTimeout();
    }

    @Override
    public boolean isDebug() {
        return this.wrapped.isDebug();
    }

    @Override
    public boolean isDebugWait() {
        return this.wrapped.isDebugWait();
    }

    @Override
    public boolean isStrace() {
        return this.wrapped.isStrace();
    }

    @Override
    public InputStream getDiskImage() {
        this.checkDestroyed();
        try {
            InputStream result = ZipUtils.unzipSingleEntryToStream((InputStream)new FileInputStream(this.file), (String)(this.getId() + ".disk.gz"));
            result = result == null ? ZipUtils.unzipSingleEntryToStream((InputStream)new FileInputStream(this.file), (String)(this.getId() + ".disk")) : new GZIPInputStream(result);
            return result;
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to read disk image for " + this.getCoordinates() + " (" + e.getMessage() + ")");
        }
    }

    @Override
    public byte[] getSignature() {
        this.checkDestroyed();
        return ZipUtils.unzipSingleEntryToByteArray((File)this.file, (String)(this.getId() + ".sig"));
    }

    @Override
    public File getFile() {
        this.checkDestroyed();
        return this.file;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public Date getGeneratedUtc() {
        return this.wrapped.getGeneratedUtc();
    }

    @Override
    public Map<ComponentId, Version> getComponents() {
        return this.wrapped.getComponents();
    }

    @Override
    public String getLinuxArgs() {
        return this.wrapped.getLinuxArgs();
    }

    @Override
    public JvmSpec getJvm() {
        return this.wrapped.getJvm();
    }

    @Override
    public TmpGB getTmp() {
        return this.wrapped.getTmp();
    }

    @Override
    public Map<String, Object> getManifest() {
        return this.manifest;
    }

    @Override
    public void rm() {
        this.checkDestroyed();
        this.destroyed = true;
    }

    @Override
    public boolean matches(String owner, ImageSpec spec, List<Component> components) {
        return this.wrapped.matches(owner, spec, components);
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new BoxfuseException("Image " + this.getId() + " has been destroyed and is no longer available!");
        }
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalImage that = (LocalImage)o;
        return this.destroyed == that.destroyed && this.file.equals(that.file) && this.wrapped.equals(that.wrapped);
    }

    public int hashCode() {
        int result = this.wrapped.hashCode();
        result = 31 * result + this.file.hashCode();
        result = 31 * result + (this.destroyed ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(Image o) {
        return this.wrapped.compareTo(o);
    }
}

