/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.inventory;

import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.types.Proxy;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.HttpUtils;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.IdUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.inventory.InventoryUtils;
import com.boxfuse.generator.inventory.RemoteInventory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inventory {
    private static final Logger LOGGER = LoggerFactory.getLogger(Inventory.class);
    private final File inventoryDir;
    private final RemoteInventory remoteInventory;
    private final Proxy proxy;
    private final boolean insecure;
    private final Map<Pair<ComponentId, Version>, Component> cache = new HashMap<Pair<ComponentId, Version>, Component>();

    public Inventory(RemoteInventory remoteInventory, Proxy proxy, boolean insecure, File inventoryDir) {
        this.remoteInventory = remoteInventory;
        this.proxy = proxy;
        this.insecure = insecure;
        this.inventoryDir = inventoryDir;
    }

    public Component get(ComponentId id, Version version) {
        SortedSet<Version> versions = this.versions(id).get(id);
        if (versions == null || versions.isEmpty()) {
            throw new BoxfuseBugException("Unable to find any versions for " + id);
        }
        if (version == null) {
            Version defaultVersion = id.getDefaultVersion();
            version = defaultVersion != null ? defaultVersion : InventoryUtils.findDefaultVersion(versions);
        } else if (!versions.contains(version) && id.getDirectFetchUrl(version) == null) {
            throw new BoxfuseException("Unknown version for " + id + ": " + version + " => possible choices: " + StringUtils.collectionToDelimitedString(versions, (String)", "));
        }
        String info = id + " " + version;
        Pair cacheKey = Pair.of((Object)id, (Object)version);
        Component component = this.cache.get(cacheKey);
        if (component != null) {
            return component;
        }
        component = this.retrieveFromLocalInventory(id, version);
        if (component != null) {
            LOGGER.debug(info + " found in local inventory");
            this.cache.put((Pair<ComponentId, Version>)cacheKey, component);
            return component;
        }
        if (!this.remoteInventory.isOnline()) {
            throw new BoxfuseException("Unable to download " + info + " as you are currently offline => ensure you are online and try again");
        }
        LOGGER.info("Downloading " + info + " ...");
        this.download(id, version);
        LOGGER.debug("Installed " + info + " in local inventory");
        component = this.retrieveFromLocalInventory(id, version);
        this.cache.put((Pair<ComponentId, Version>)cacheKey, component);
        return component;
    }

    public Component retrieveFromLocalInventory(ComponentId id, Version version) {
        File file = new File(this.computeFileName(id, version));
        if (!file.isFile()) {
            LOGGER.debug("Component not found in local inventory: " + file.getPath());
            return null;
        }
        return new Component(id, version, file);
    }

    private String computeDirectory(ComponentId id) {
        return this.inventoryDir.getAbsolutePath() + "/" + id;
    }

    private String computeFileName(ComponentId id, Version version) {
        return this.computeDirectory(id) + "/" + id + "-" + version + "." + id.getFormat();
    }

    void download(ComponentId id, Version version) {
        ShellUtils.mkdir((String)this.computeDirectory(id));
        String downloadUrl = this.remoteInventory.generateDownloadUrl(id, version);
        try {
            String finalName = this.computeFileName(id, version);
            String tempName = IdUtils.generateLocallyUniqueId((String)finalName);
            File tempFile = new File(tempName);
            IOUtils.copy((byte[])HttpUtils.downloadWithProgress((String)downloadUrl, (Proxy)this.proxy, (boolean)this.insecure), (File)tempFile);
            File finalFile = new File(finalName);
            ShellUtils.renameFile((File)tempFile, (File)finalFile);
        }
        catch (Exception e) {
            String source = id.getDirectFetchUrl(version);
            throw new BoxfuseException("Unable to download " + id + " " + version + " from " + (source == null ? "inventory" : source), (Throwable)e);
        }
    }

    public Map<ComponentId, SortedSet<Version>> versions(ComponentId id) {
        TreeMap<ComponentId, SortedSet<Version>> result = new TreeMap<ComponentId, SortedSet<Version>>();
        if (!this.remoteInventory.isOnline()) {
            ComponentId[] components;
            ComponentId[] componentIdArray;
            if (id == null) {
                componentIdArray = ComponentId.values();
            } else {
                ComponentId[] componentIdArray2 = new ComponentId[1];
                componentIdArray = componentIdArray2;
                componentIdArray2[0] = id;
            }
            for (ComponentId componentId : components = componentIdArray) {
                result.put(componentId, this.localInventoryVersions(componentId));
            }
            return this.hideVersionsOutsideRange(result);
        }
        if (id == null) {
            return this.hideVersionsOutsideRange(this.remoteInventory.listAllComponents());
        }
        result.put(id, this.remoteInventory.listAllComponents().get(id));
        return this.hideVersionsOutsideRange(result);
    }

    private Map<ComponentId, SortedSet<Version>> hideVersionsOutsideRange(Map<ComponentId, SortedSet<Version>> componentIdListMap) {
        TreeMap<ComponentId, SortedSet<Version>> result = new TreeMap<ComponentId, SortedSet<Version>>();
        for (Map.Entry<ComponentId, SortedSet<Version>> entry : componentIdListMap.entrySet()) {
            TreeSet<Version> versions = new TreeSet<Version>();
            ComponentId componentId = entry.getKey();
            if (entry.getValue() == null) continue;
            for (Version version : entry.getValue()) {
                if (componentId.getMinVersion().compareTo(version) > 0 || componentId.getMaxVersion().compareTo(version) < 0) continue;
                versions.add(version);
            }
            result.put(componentId, versions);
        }
        return result;
    }

    private SortedSet<Version> localInventoryVersions(ComponentId id) {
        File directory = new File(this.computeDirectory(id));
        if (!directory.isDirectory() || !directory.canRead()) {
            throw new BoxfuseException("No versions of " + id + " available offline.");
        }
        String[] names = directory.list((dir, name) -> name.endsWith(id.getFormat()));
        return Inventory.getComponentVersions(id, names);
    }

    static SortedSet<Version> getComponentVersions(ComponentId id, String ... fileNames) {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (String name : fileNames) {
            versions.add(new Version(StringUtils.firstMatchingGroup((String)name, (String)(".*" + id + "-([0-9\\.]+)\\." + id.getFormat()))));
        }
        if (versions.isEmpty()) {
            throw new BoxfuseException("No versions of " + id + " available offline.");
        }
        return versions;
    }
}

