/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660;

import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import java.util.Iterator;

public class ISO9660RootDirectory
extends ISO9660Directory {
    public static String MOVED_DIRECTORIES_STORE_NAME = "rr_moved";
    private ISO9660Directory movedDirectoriesStore;

    public ISO9660RootDirectory() {
        super("");
        this.setRoot(this);
    }

    public void setMovedDirectoryStore() {
        if (this.movedDirectoriesStore == null) {
            this.movedDirectoriesStore = new ISO9660Directory(MOVED_DIRECTORIES_STORE_NAME);
            this.addDirectory(this.movedDirectoriesStore);
            this.sortedIterator = null;
        }
    }

    public ISO9660Directory getMovedDirectoriesStore() {
        return this.movedDirectoriesStore;
    }

    public int deepLevelCount() {
        int count = this.getLevel();
        for (ISO9660Directory dir : this.getDirectories()) {
            count = Math.max(count, dir.deepLevelCount());
        }
        return count;
    }

    public int deepFileCount() {
        int count = this.getFiles().size();
        for (ISO9660Directory dir : this.getDirectories()) {
            count += dir.deepFileCount();
        }
        return count;
    }

    public int deepDirCount() {
        int count = this.getDirectories().size();
        for (ISO9660Directory dir : this.getDirectories()) {
            count += dir.deepDirCount();
        }
        return count;
    }

    public Object clone() {
        ISO9660RootDirectory clone = (ISO9660RootDirectory)super.clone();
        clone.setParentDirectory(clone);
        clone.setRoot(clone);
        Iterator<ISO9660Directory> it = clone.unsortedIterator();
        while (it.hasNext()) {
            ISO9660Directory dir = it.next();
            dir.setRoot(clone);
        }
        return clone;
    }
}

