/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660;

import com.github.stephenc.javaisotools.eltorito.impl.ElToritoConfig;
import com.github.stephenc.javaisotools.iso9660.ConfigException;
import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.ISOFileSet;
import com.github.stephenc.javaisotools.iso9660.NamingConventions;
import com.github.stephenc.javaisotools.iso9660.impl.CreateISO;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Config;
import com.github.stephenc.javaisotools.iso9660.impl.ISOImageFileHandler;
import com.github.stephenc.javaisotools.joliet.impl.JolietConfig;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeConfig;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public class ISOTask
extends MatchingTask {
    private File baseDir;
    private File destFile;
    private File bootImage;
    private Vector filesets;
    private String name;
    private String system;
    private String publisher;
    private String dataPreparer;
    private String copyrightFile;
    private String bootImageID;
    private String bootImageEmulation;
    private String bootImagePlatformID;
    private String movedDirectoriesStoreName;
    private boolean allowASCII;
    private boolean restrictDirDepthTo8;
    private boolean forceDotDelimiter;
    private boolean mkisofsCompatibility;
    private boolean forcePortableFilenameCharacterSet;
    private boolean enableJoliet;
    private boolean enableRockRidge;
    private boolean hideMovedDirectoriesStore;
    private boolean verbose;
    private boolean genBootInfoTable;
    private boolean padEnd;
    private int interchangeLevel;
    private int bootImageSectorCount;
    private int bootImageLoadSegment;

    public void init() {
        this.bootImage = null;
        this.destFile = null;
        this.baseDir = null;
        this.filesets = new Vector();
        this.bootImageID = "";
        this.dataPreparer = "";
        this.publisher = "";
        this.system = "";
        this.name = "";
        this.copyrightFile = null;
        this.movedDirectoriesStoreName = "rr_moved";
        this.allowASCII = false;
        this.restrictDirDepthTo8 = true;
        this.forceDotDelimiter = true;
        this.interchangeLevel = 1;
        this.mkisofsCompatibility = true;
        this.forcePortableFilenameCharacterSet = true;
        this.enableJoliet = true;
        this.enableRockRidge = true;
        this.hideMovedDirectoriesStore = true;
        this.verbose = false;
        this.bootImageSectorCount = 1;
        this.bootImageLoadSegment = ElToritoConfig.LOAD_SEGMENT_7C0;
        this.bootImagePlatformID = "";
        this.bootImageEmulation = "";
        this.genBootInfoTable = false;
        this.padEnd = true;
    }

    public void execute() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.destFile == null) {
            throw new BuildException("destfile attribute must be set!");
        }
        try {
            NamingConventions.VERBOSE = this.verbose;
            ISO9660RootDirectory.MOVED_DIRECTORIES_STORE_NAME = this.movedDirectoriesStoreName;
            ISO9660RootDirectory root = new ISO9660RootDirectory();
            this.createHierarchy(root);
            File copyrightFileObj = null;
            if (this.copyrightFile != null) {
                copyrightFileObj = new File(this.copyrightFile);
            }
            ISO9660Config iso9660Config = new ISO9660Config();
            iso9660Config.setVolumeID(this.name);
            iso9660Config.setSystemID(this.system);
            iso9660Config.setPublisher(this.publisher);
            iso9660Config.setDataPreparer(this.dataPreparer);
            iso9660Config.allowASCII(this.allowASCII);
            iso9660Config.restrictDirDepthTo8(this.restrictDirDepthTo8);
            iso9660Config.forceDotDelimiter(this.forceDotDelimiter);
            iso9660Config.setInterchangeLevel(this.interchangeLevel);
            iso9660Config.setPadEnd(this.padEnd);
            if (copyrightFileObj != null) {
                iso9660Config.setCopyrightFile(copyrightFileObj);
            }
            RockRidgeConfig rrConfig = null;
            if (this.enableRockRidge) {
                this.log("Rock Ridge support enabled.");
                rrConfig = new RockRidgeConfig();
                rrConfig.setMkisofsCompatibility(this.mkisofsCompatibility);
                rrConfig.hideMovedDirectoriesStore(this.hideMovedDirectoriesStore);
                rrConfig.forcePortableFilenameCharacterSet(this.forcePortableFilenameCharacterSet);
            }
            JolietConfig jolietConfig = null;
            if (this.enableJoliet) {
                this.log("Joliet support enabled.");
                jolietConfig = new JolietConfig();
                jolietConfig.setVolumeID(this.name);
                jolietConfig.setSystemID(this.system);
                jolietConfig.setPublisher(this.publisher);
                jolietConfig.setDataPreparer(this.dataPreparer);
                jolietConfig.forceDotDelimiter(this.forceDotDelimiter);
                if (copyrightFileObj != null) {
                    jolietConfig.setCopyrightFile(copyrightFileObj);
                }
            }
            ElToritoConfig elToritoConfig = null;
            if (this.bootImage != null) {
                this.log("El Torito support enabled.");
                elToritoConfig = new ElToritoConfig(this.bootImage, this.getBootEmulation(), this.getBootPlatformID(), this.bootImageID, this.bootImageSectorCount, this.bootImageLoadSegment);
                elToritoConfig.setGenBootInfoTable(this.genBootInfoTable);
            }
            CreateISO iso = new CreateISO(new ISOImageFileHandler(this.destFile), root);
            iso.process(iso9660Config, rrConfig, jolietConfig, elToritoConfig);
            this.log("Successfully created ISO image " + this.destFile + ".");
        }
        catch (ConfigException ce) {
            throw new BuildException((Throwable)ce);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private int getBootEmulation() {
        if (this.bootImageEmulation.matches(".*1.*2.*")) {
            return ElToritoConfig.BOOT_MEDIA_TYPE_1_2MEG_DISKETTE;
        }
        if (this.bootImageEmulation.matches(".*44.*")) {
            return ElToritoConfig.BOOT_MEDIA_TYPE_1_44MEG_DISKETTE;
        }
        if (this.bootImageEmulation.matches(".*88.*")) {
            return ElToritoConfig.BOOT_MEDIA_TYPE_2_88MEG_DISKETTE;
        }
        if (this.bootImageEmulation.matches(".*(hd|hard).*")) {
            return ElToritoConfig.BOOT_MEDIA_TYPE_HD;
        }
        return ElToritoConfig.BOOT_MEDIA_TYPE_NO_EMU;
    }

    private int getBootPlatformID() {
        if (this.bootImagePlatformID.equalsIgnoreCase("mac") || this.bootImagePlatformID.equalsIgnoreCase("macintosh") || this.bootImagePlatformID.equalsIgnoreCase("apple")) {
            return ElToritoConfig.PLATFORM_ID_MAC;
        }
        if (this.bootImagePlatformID.equalsIgnoreCase("ppc") || this.bootImagePlatformID.equalsIgnoreCase("powerpc")) {
            return ElToritoConfig.PLATFORM_ID_PPC;
        }
        if (this.bootImagePlatformID.equalsIgnoreCase("efi")) {
            return ElToritoConfig.PLATFORM_ID_EFI;
        }
        return ElToritoConfig.PLATFORM_ID_X86;
    }

    private void createHierarchy(ISO9660RootDirectory root) throws HandlerException, IOException {
        if (this.baseDir != null) {
            FileSet fs = (FileSet)this.getImplicitFileSet().clone();
            fs.setDir(this.baseDir);
            this.filesets.addElement(fs);
        }
        for (FileSet fs : this.filesets) {
            String prefix = "";
            if (fs instanceof ISOFileSet) {
                ISOFileSet ifs = (ISOFileSet)fs;
                prefix = ifs.getPrefix();
            }
            this.createHierarchy(root, fs, prefix);
        }
    }

    private void createHierarchy(ISO9660RootDirectory root, FileSet fs, String prefix) throws HandlerException {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] dirs = ds.getIncludedDirectories();
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].equals("")) continue;
            String path = this.checkPrefix(dirs[i], prefix);
            root.addPath(path);
        }
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            ISO9660Directory dir = root;
            String path = this.checkPrefix(files[i], prefix);
            if (path.indexOf(File.separator) >= 0) {
                path = path.substring(0, path.lastIndexOf(File.separator));
                dir = root.addPath(path);
            }
            dir.addFile(new File(ds.getBasedir(), files[i]));
        }
    }

    private String checkPrefix(String path, String prefix) {
        if (prefix.length() > 0) {
            prefix = prefix + "/";
        }
        path = prefix + path;
        path = path.replace('\\', File.separatorChar);
        path = path.replace('/', File.separatorChar);
        return path;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void addFileset(FileSet set) {
        set.setDir(this.baseDir);
        this.filesets.addElement(set);
    }

    public void addISOFileset(ISOFileSet set) {
        set.setDir(this.baseDir);
        this.filesets.addElement(set);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setDataPreparer(String dataPreparer) {
        this.dataPreparer = dataPreparer;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public void setCopyrightFile(String copyrightFile) {
        this.copyrightFile = copyrightFile;
    }

    public void setAllowASCII(boolean allowASCII) {
        this.allowASCII = allowASCII;
    }

    public void setForceDotDelimiter(boolean forceDotDelimiter) {
        this.forceDotDelimiter = forceDotDelimiter;
    }

    public void setRestrictDirDepthTo8(boolean restrictDirDepthTo8) {
        this.restrictDirDepthTo8 = restrictDirDepthTo8;
    }

    public void setInterchangeLevel(int interchangeLevel) {
        this.interchangeLevel = interchangeLevel;
    }

    public void setForcePortableFilenameCharacterSet(boolean forcePortableFilenameCharacterSet) {
        this.forcePortableFilenameCharacterSet = forcePortableFilenameCharacterSet;
    }

    public void setMkisofsCompatibility(boolean mkisofsCompatibility) {
        this.mkisofsCompatibility = mkisofsCompatibility;
    }

    public void setEnableJoliet(boolean enableJoliet) {
        this.enableJoliet = enableJoliet;
    }

    public void setEnableRockRidge(boolean enableRockRidge) {
        this.enableRockRidge = enableRockRidge;
    }

    public void setHideMovedDirectoriesStore(boolean hideMovedDirectoriesStore) {
        this.hideMovedDirectoriesStore = hideMovedDirectoriesStore;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setBootImage(File bootImage) {
        this.bootImage = bootImage;
    }

    public void setBootImageSectorCount(int bootImageSectorCount) {
        this.bootImageSectorCount = bootImageSectorCount;
    }

    public void setBootImageID(String bootImageID) {
        this.bootImageID = bootImageID;
    }

    public void setBootImageLoadSegment(int bootImageLoadSegment) {
        this.bootImageLoadSegment = bootImageLoadSegment;
    }

    public void setBootImageEmulation(String bootImageEmulation) {
        this.bootImageEmulation = bootImageEmulation;
    }

    public void setBootImagePlatformID(String bootImagePlatformID) {
        this.bootImagePlatformID = bootImagePlatformID;
    }

    public void setMovedDirectoriesStoreName(String movedDirectoriesStoreName) {
        this.movedDirectoriesStoreName = movedDirectoriesStoreName;
    }

    public void setGenBootInfoTable(boolean genBootInfoTable) {
        this.genBootInfoTable = genBootInfoTable;
    }

    public void setPadEnd(boolean padEnd) {
        this.padEnd = padEnd;
    }
}

