/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.joliet.impl;

import com.github.stephenc.javaisotools.iso9660.ConfigException;
import com.github.stephenc.javaisotools.iso9660.StandardConfig;
import com.github.stephenc.javaisotools.joliet.impl.JolietNamingConventions;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;

public class JolietConfig
extends StandardConfig {
    private static byte[][] UCS2_LEVEL_ESCAPE_SEQUENCES = new byte[][]{{37, 47, 64}, {37, 47, 67}, {37, 47, 69}};
    int ucs2_level = 3;

    public void forceDotDelimiter(boolean force) {
        JolietNamingConventions.FORCE_DOT_DELIMITER = force;
        if (!force) {
            System.out.println("Warning: Not forcing to include the dot in filenames breaks Joliet conformance.");
        }
    }

    public void setUCS2Level(int level) throws ConfigException {
        if (level != 1 && level != 2 && level != 3) {
            throw new ConfigException(this, "Invalid UCS-2 level: " + level);
        }
        this.ucs2_level = level;
    }

    public int getUCS2Level() {
        return this.ucs2_level;
    }

    public ByteArrayDataReference getUCS2LevelEscapeSequence() {
        return new ByteArrayDataReference(UCS2_LEVEL_ESCAPE_SEQUENCES[this.ucs2_level - 1]);
    }

    public void setVolumeSetID(String volumeSetID) throws ConfigException {
        if (volumeSetID.length() > 64) {
            throw new ConfigException(this, "The Volume Set ID may be no longer than 64 characters.");
        }
        super.setVolumeSetID(volumeSetID);
    }

    public void setApp(String app) throws ConfigException {
        if (app.length() > 64) {
            throw new ConfigException(this, "The Application Identifier may be no longer than 64 characters.");
        }
        super.setApp(app);
    }

    public void setDataPreparer(String dataPreparer) throws ConfigException {
        if (dataPreparer.length() > 64) {
            throw new ConfigException(this, "The Data Preparer Identifier may be no longer than 64 characters.");
        }
        super.setDataPreparer(dataPreparer);
    }

    public void setPublisher(String publisher) throws ConfigException {
        if (publisher.length() > 64) {
            throw new ConfigException(this, "The Publisher Identifier may be no longer than 64 characters.");
        }
        super.setPublisher(publisher);
    }

    public void setSystemID(String systemID) throws ConfigException {
        if (systemID.length() > 16) {
            throw new ConfigException(this, "The System Identifier may be no longer than 16 characters.");
        }
        super.setSystemID(systemID);
    }

    public void setVolumeID(String volumeID) throws ConfigException {
        if (volumeID.length() > 16) {
            throw new ConfigException(this, "The Volume Identifier may be no longer than 16 characters.");
        }
        super.setVolumeID(volumeID);
    }
}

