/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.peer.RobotPeer;
import sun.awt.CGraphicsDevice;
import sun.lwawt.macosx.CCursorManager;

class CRobot
implements RobotPeer {
    private static final int MOUSE_LOCATION_UNKNOWN = -1;
    private final CGraphicsDevice fDevice;
    private int mouseLastX = -1;
    private int mouseLastY = -1;
    private int mouseButtonsState = 0;

    public CRobot(Robot robot, CGraphicsDevice cGraphicsDevice) {
        this.fDevice = cGraphicsDevice;
        this.initRobot();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void mouseMove(int n, int n2) {
        this.mouseLastX = n;
        this.mouseLastY = n2;
        this.mouseEvent(this.fDevice.getCGDisplayID(), this.mouseLastX, this.mouseLastY, this.mouseButtonsState, true, true);
    }

    @Override
    public void mousePress(int n) {
        this.mouseButtonsState |= n;
        this.checkMousePos();
        this.mouseEvent(this.fDevice.getCGDisplayID(), this.mouseLastX, this.mouseLastY, n, true, false);
    }

    @Override
    public void mouseRelease(int n) {
        this.mouseButtonsState &= ~n;
        this.checkMousePos();
        this.mouseEvent(this.fDevice.getCGDisplayID(), this.mouseLastX, this.mouseLastY, n, false, false);
    }

    private void checkMousePos() {
        if (this.mouseLastX == -1 || this.mouseLastY == -1) {
            Rectangle rectangle = this.fDevice.getDefaultConfiguration().getBounds();
            Point point = CCursorManager.getInstance().getCursorPosition();
            if (point.x < rectangle.x) {
                point.x = rectangle.x;
            } else if (point.x > rectangle.x + rectangle.width) {
                point.x = rectangle.x + rectangle.width;
            }
            if (point.y < rectangle.y) {
                point.y = rectangle.y;
            } else if (point.y > rectangle.y + rectangle.height) {
                point.y = rectangle.y + rectangle.height;
            }
            this.mouseLastX = point.x;
            this.mouseLastY = point.y;
        }
    }

    @Override
    public native void mouseWheel(int var1);

    @Override
    public void keyPress(int n) {
        this.keyEvent(n, true);
    }

    @Override
    public void keyRelease(int n) {
        this.keyEvent(n, false);
    }

    @Override
    public int getRGBPixel(int n, int n2) {
        int[] nArray = new int[1];
        this.getScreenPixels(new Rectangle(n, n2, 1, 1), nArray);
        return nArray[0];
    }

    @Override
    public int[] getRGBPixels(Rectangle rectangle) {
        int[] nArray = new int[rectangle.width * rectangle.height];
        this.getScreenPixels(rectangle, nArray);
        return nArray;
    }

    private native void initRobot();

    private native void mouseEvent(int var1, int var2, int var3, int var4, boolean var5, boolean var6);

    private native void keyEvent(int var1, boolean var2);

    private void getScreenPixels(Rectangle rectangle, int[] nArray) {
        this.nativeGetScreenPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
    }

    private native void nativeGetScreenPixels(int var1, int var2, int var3, int var4, int[] var5);
}

