/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.aws;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public class AwsTagKey
implements Comparable<AwsTagKey> {
    private static final String AWS_PREFIX = "aws:";
    private static final String BOXFUSE_PREFIX = "boxfuse:";
    public static final AwsTagKey TAG_BOXFUSE_IGNORE = new AwsTagKey("boxfuse:ignore");
    public static final AwsTagKey BOXFUSE_ENV = new AwsTagKey("boxfuse:env");
    public static final AwsTagKey BOXFUSE_APP = new AwsTagKey("boxfuse:app");
    public static final AwsTagKey BOXFUSE_DB = new AwsTagKey("boxfuse:db");
    public static final AwsTagKey BOXFUSE_IMAGE = new AwsTagKey("boxfuse:image");
    public static final AwsTagKey NAME = new AwsTagKey("Name");
    private final String key;

    @JsonCreator
    public static AwsTagKey of(String key) {
        return new AwsTagKey(key);
    }

    public static AwsTagKey ofCustom(String key) {
        if (!StringUtils.hasLength(key)) {
            throw new BoxfuseException("Missing tag key");
        }
        if (key.startsWith(AWS_PREFIX)) {
            throw new BoxfuseException("Invalid tag key: " + key + " => Tag keys starting with " + AWS_PREFIX + " are reserved for AWS internal use");
        }
        if (key.startsWith(BOXFUSE_PREFIX)) {
            throw new BoxfuseException("Invalid tag key: " + key + " => Tag keys starting with " + BOXFUSE_PREFIX + " are reserved for Boxfuse internal use");
        }
        return AwsTagKey.of(key);
    }

    private AwsTagKey(String key) {
        if (!key.matches("^[a-zA-Z0-9_\\+\\-=\\.:\\/@]{1,127}$")) {
            throw new BoxfuseException("Invalid tag key (may only contain a-z, A-Z, 0-9, _+-=.:/@ (max 127 chars)): " + key);
        }
        this.key = key;
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    @Override
    public int compareTo(AwsTagKey o) {
        return this.key.compareTo(o.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsTagKey awsTagKey = (AwsTagKey)o;
        return this.key.equals(awsTagKey.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }
}

