/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.crypto;

import com.boxfuse.base.crypto.PKCS1;
import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.ByteArrayUtils;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    private static final String PEM_PKCS8_BEGIN = "-----BEGIN PRIVATE KEY-----";
    private static final String PEM_PKCS8_END = "-----END PRIVATE KEY-----";

    private CryptoUtils() {
    }

    public static byte[] pemToDer(String pem) {
        String derBase64 = pem.replace(PEM_PKCS8_BEGIN, "").replace(PEM_PKCS8_END, "").replace("\r", "").replace("\n", "");
        return ByteArrayUtils.fromBase64(derBase64);
    }

    public static byte[] md5Digest(byte[] bytes) {
        try {
            return MessageDigest.getInstance("MD5").digest(bytes);
        }
        catch (Exception e) {
            throw new BoxfuseException("Unable to digest " + bytes.length + " bytes", e);
        }
    }

    public static byte[] sha1Digest(byte[] bytes) {
        try {
            return MessageDigest.getInstance("SHA-1").digest(bytes);
        }
        catch (Exception e) {
            throw new BoxfuseException("Unable to digest " + bytes.length + " bytes", e);
        }
    }

    public static byte[] sha256Digest(byte[] bytes) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(bytes);
        }
        catch (Exception e) {
            throw new BoxfuseException("Unable to digest " + bytes.length + " bytes", e);
        }
    }

    public static byte[] sha1Sign(PrivateKey privateKey, String str) {
        try {
            Signature instance = Signature.getInstance("SHA1withRSA");
            instance.initSign(privateKey);
            instance.update(str.getBytes("UTF-8"));
            return instance.sign();
        }
        catch (Exception e) {
            throw new BoxfuseException("Unable to compute digest", e);
        }
    }

    public static PublicKey rsaPublicKey(byte[] publicKey) {
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (GeneralSecurityException e) {
            throw new BoxfuseException("Unable to load the public key", e);
        }
    }

    public static PrivateKey rsaPrivateKey(byte[] privateKey) {
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(privateKey));
        }
        catch (GeneralSecurityException e) {
            throw new BoxfuseException("Unable to load the private key", e);
        }
    }

    public static byte[] rsaEncrypt(PublicKey publicKey, byte[] data) {
        try {
            Cipher rsa = CryptoUtils.getRsaCipher();
            rsa.init(1, publicKey);
            return rsa.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new BoxfuseException("Unable to RSA encrypt data", e);
        }
    }

    public static byte[] rsaDecrypt(Key key, byte[] data) {
        try {
            Cipher rsa = CryptoUtils.getRsaCipher();
            rsa.init(2, key);
            return rsa.doFinal(data);
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Unable to RSA decrypt data", e);
        }
    }

    public static byte[] rsaDecrypt(byte[] encrypted, Key key) {
        try {
            Cipher rsa = CryptoUtils.getRsaCipher();
            rsa.init(2, key);
            return rsa.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Decrypt failed", e);
        }
    }

    public static byte[] rsaEncrypt(byte[] clear, Key key) {
        try {
            Cipher rsa = CryptoUtils.getRsaCipher();
            rsa.init(1, key);
            return rsa.doFinal(clear);
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Encrypt failed", e);
        }
    }

    public static String rsaDecryptUtf8(Key key, byte[] encrypted) {
        return new String(CryptoUtils.rsaDecrypt(key, encrypted), Charset.forName("UTF-8"));
    }

    private static Cipher getRsaCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("RSA/ECB/PKCS1Padding");
    }

    public static PrivateKey rsaPrivateKeyFromPem(String pem) {
        try {
            KeySpec keySpec = null;
            if (pem.contains(PEM_PKCS8_BEGIN)) {
                keySpec = new PKCS8EncodedKeySpec(CryptoUtils.pemToDerPkcs8(pem));
            } else if (pem.contains("-----BEGIN RSA PRIVATE KEY-----")) {
                keySpec = new PKCS1(CryptoUtils.pemToDerPkcs1(pem)).getKeySpec();
            }
            return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new BoxfuseException("Invalid Private Key", e);
        }
    }

    public static KeyPair rsaGenerateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.genKeyPair();
        }
        catch (Exception e) {
            throw new BoxfuseBugException("KeyPair generation failed", e);
        }
    }

    public static KeyPair ecGenerateKeyPair() {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC", "SunEC");
            parameters.init(new ECGenParameterSpec("secp256r1"));
            ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(ecParameters, new SecureRandom());
            return keyPairGenerator.genKeyPair();
        }
        catch (Exception e) {
            throw new BoxfuseBugException("KeyPair generation failed", e);
        }
    }

    public static KeyPair toECKeyPair(byte[] publicKey, byte[] privateKey) {
        try {
            return new KeyPair(KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(publicKey)), KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec(privateKey)));
        }
        catch (Exception e) {
            throw new BoxfuseBugException("KeyPair generation failed", e);
        }
    }

    public static byte[] sha1(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(bytes);
            return digest.digest();
        }
        catch (Exception e) {
            throw new BoxfuseBugException("SHA-1 failed", e);
        }
    }

    public static byte[] pemToDerPkcs8(String pem) {
        String derBase64 = pem.replace(PEM_PKCS8_BEGIN, "").replace(PEM_PKCS8_END, "");
        return CryptoUtils.pemToDer(derBase64);
    }

    public static X509Certificate derToX509(byte[] der) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(der));
        }
        catch (GeneralSecurityException e) {
            throw new BoxfuseBugException("X.509 loading failed", e);
        }
    }

    public static byte[] pemToDerPkcs1(String pem) {
        String derBase64 = pem.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "");
        return CryptoUtils.pemToDer(derBase64.trim());
    }

    public static byte[] aesGenerateKey128() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            return keyGenerator.generateKey().getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BoxfuseBugException("AES key generation failed", e);
        }
    }

    public static List<byte[]> aesEncrypt(byte[] source) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            Cipher aes = CryptoUtils.getAesCbcCipher();
            aes.init(1, secretKey);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy(source, (OutputStream)new CipherOutputStream(output, aes));
            return Arrays.asList(output.toByteArray(), secretKey.getEncoded(), aes.getIV());
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Unable to encrypt " + source.length + " bytes", e);
        }
    }

    public static byte[] aesEncrypt(byte[] clear, byte[] key) {
        try {
            Cipher cipher = CryptoUtils.getAesCbcCipher();
            cipher.init(1, new SecretKeySpec(key, "AES"));
            byte[] iv = cipher.getIV();
            byte[] encrypted = cipher.doFinal(clear);
            byte[] result = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, result, 0, iv.length);
            System.arraycopy(encrypted, 0, result, iv.length, encrypted.length);
            return result;
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Encrypt failed", e);
        }
    }

    public static byte[] aesEcbEncrypt(byte[] clear, byte[] key) {
        try {
            Cipher cipher = CryptoUtils.getAesEcbCipher();
            cipher.init(1, new SecretKeySpec(key, "AES"));
            return cipher.doFinal(clear);
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Encrypt failed", e);
        }
    }

    public static byte[] aesEcbEncryptUtf8(String clear, byte[] key) {
        return CryptoUtils.aesEcbEncrypt(clear.getBytes(StandardCharsets.UTF_8), key);
    }

    public static byte[] aesEncryptUtf8(String clear, byte[] key) {
        return CryptoUtils.aesEncrypt(clear.getBytes(StandardCharsets.UTF_8), key);
    }

    public static String aesEcbDecryptUtf8(byte[] encrypted, byte[] key) {
        return StringUtils.toUtf8String(CryptoUtils.aesEcbDecrypt(encrypted, key));
    }

    public static String aesDecryptUtf8(byte[] encrypted, byte[] key) {
        return StringUtils.toUtf8String(CryptoUtils.aesDecrypt(encrypted, key));
    }

    public static InputStream aesDecrypt(InputStream encrypted, byte[] key) {
        try {
            byte[] iv = new byte[16];
            if (encrypted.read(iv) != 16) {
                throw new BoxfuseBugException("Decrypt failed: Could not read IV");
            }
            Cipher aes = CryptoUtils.getAesCbcCipher();
            aes.init(2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            return new CipherInputStream(encrypted, aes);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new BoxfuseBugException("Decrypt failed", e);
        }
    }

    public static byte[] aesEcbDecrypt(byte[] encrypted, byte[] key) {
        try {
            Cipher aes = CryptoUtils.getAesEcbCipher();
            aes.init(2, new SecretKeySpec(key, "AES"));
            return aes.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Decrypt failed", e);
        }
    }

    public static byte[] aesDecrypt(byte[] encrypted, byte[] key) {
        try {
            byte[] iv = Arrays.copyOfRange(encrypted, 0, 16);
            byte[] payload = Arrays.copyOfRange(encrypted, 16, encrypted.length);
            Cipher aes = CryptoUtils.getAesCbcCipher();
            aes.init(2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            return aes.doFinal(payload);
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Decrypt failed", e);
        }
    }

    private static Cipher getAesCbcCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("AES/CBC/PKCS5Padding");
    }

    private static Cipher getAesEcbCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("AES/ECB/PKCS5Padding");
    }

    public static byte[] hmac(byte[] clear, byte[] key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA512");
            mac.init(new SecretKeySpec(key, "HmacSHA512"));
            return mac.doFinal(clear);
        }
        catch (Exception e) {
            throw new BoxfuseBugException("Hmac failed", e);
        }
    }

    public static byte[] hmacUtf8(String clear, byte[] key) {
        return CryptoUtils.hmac(clear.getBytes(StandardCharsets.UTF_8), key);
    }
}

