/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.enums;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;

public enum LogsType {
    NONE("none", "No centralized logging"),
    CLOUDWATCH_LOGS("cloudwatch-logs", "AWS CloudWatch Logs");

    private final String name;
    private final String description;

    private LogsType(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static LogsType of(String name) {
        if (name == null) {
            return null;
        }
        return LogsType.fromName(name);
    }

    @JsonCreator
    public static LogsType fromName(String name) {
        if (name == null) {
            return NONE;
        }
        for (LogsType logsType : LogsType.values()) {
            if (!logsType.name.equals(name)) continue;
            return logsType;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (LogsType type : LogsType.values()) {
            names.add(type.getName());
        }
        throw new BoxfuseException("Invalid logs type: " + name + " (Possible values: " + StringUtils.collectionToDelimitedString(names, ", ") + ")");
    }
}

