/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.enums;

import com.boxfuse.base.exception.BoxfuseException;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Locale;

public enum PlatformType {
    VIRTUALBOX("VirtualBox"),
    HYPERV("Hyper-V"),
    AWS("AWS");

    private final String name;

    private PlatformType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @JsonCreator
    public static PlatformType of(String name) {
        if (name == null) {
            throw new BoxfuseException("Missing platform");
        }
        for (PlatformType type : PlatformType.values()) {
            if (!type.name().equals(name.toUpperCase(Locale.ENGLISH))) continue;
            return type;
        }
        throw new BoxfuseException("Unsupported platform: " + name);
    }
}

