/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.logs.cloudwatchlogs;

import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.logs.AsyncLogs;
import com.boxfuse.base.logs.LogsListener;
import com.boxfuse.base.logs.cloudwatchlogs.LogsFieldName;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLayout;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLevel;
import com.boxfuse.base.types.EnvName;
import com.boxfuse.base.util.DateUtils;
import com.boxfuse.base.util.JsonUtils;
import com.boxfuse.base.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudwatchLogsLogs
extends AsyncLogs {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudwatchLogsLogs.class);
    private static final List<LogsFieldName> NON_PATTERN_FILTERS = Arrays.asList(LogsFieldName.APP, LogsFieldName.LIMIT, LogsFieldName.START, LogsFieldName.END);
    private final Owner owner;
    protected final EnvName env;
    protected final Map<LogsFieldName, Object> filters;
    private final LogsLayout logsLayout;
    protected final String filterPattern;
    private long threadStartTimestamp;
    private boolean first;
    private Long limit;
    Long startTime;
    private Long endTime;
    private String nextToken;

    public CloudwatchLogsLogs(Owner owner, EnvName env, Map<LogsFieldName, Object> filters, LogsLayout logsLayout) {
        super("CloudwatchLogs " + env + " T" + System.currentTimeMillis());
        this.owner = owner;
        this.env = env;
        this.filters = filters;
        this.logsLayout = logsLayout;
        this.filterPattern = CloudwatchLogsLogs.toFilterPattern(this.filters);
    }

    static String toFilterPattern(Map<LogsFieldName, Object> filters) {
        String filterPattern = "";
        boolean first = true;
        for (Map.Entry<LogsFieldName, Object> entry : filters.entrySet()) {
            LogsFieldName filterName = entry.getKey();
            if (!first && !NON_PATTERN_FILTERS.contains((Object)filterName)) {
                filterPattern = filterPattern + " && ";
            }
            if (LogsFieldName.LEVEL == filterName) {
                LogsLevel level = (LogsLevel)((Object)entry.getValue());
                filterPattern = filterPattern + level.toFilterPattern();
                first = false;
                continue;
            }
            if (NON_PATTERN_FILTERS.contains((Object)filterName)) continue;
            filterPattern = filterPattern + "($." + (Object)((Object)filterName) + " = \"" + entry.getValue() + "\")";
            first = false;
        }
        if (!StringUtils.hasLength(filterPattern)) {
            return null;
        }
        filterPattern = "{ " + filterPattern + " }";
        return filterPattern;
    }

    @Override
    protected void init(boolean tail, LogsListener logsListener) {
        this.threadStartTimestamp = new Date().getTime();
        this.first = true;
        this.limit = null;
        this.startTime = (Long)this.filters.get((Object)LogsFieldName.START);
        this.endTime = (Long)this.filters.get((Object)LogsFieldName.END);
        this.nextToken = null;
        LOGGER.debug((tail ? "Tailing" : "Retrieving") + " logs for the " + this.env + " environment" + (this.startTime == null ? "" : " from " + DateUtils.formatAsUtcDateTimeWithSeconds(new Date(this.startTime))) + (this.endTime == null ? "" : " until " + DateUtils.formatAsUtcDateTimeWithSeconds(new Date(this.endTime))) + " with filter " + this.filterPattern + " ...");
    }

    @Override
    protected void poll(boolean tail, LogsListener logsListener) {
        try {
            if (this.first) {
                this.limit = (Long)this.filters.get((Object)LogsFieldName.LIMIT);
                this.first = false;
            } else {
                this.limit = null;
            }
            Map<String, Object> result = this.filterLogEvents(this.startTime, this.endTime, this.limit, this.nextToken);
            List events = (List)result.get("events");
            for (Map logEvent : events) {
                HashMap<LogsFieldName, String> logsFieldValues = new HashMap<LogsFieldName, String>();
                String app = (String)logEvent.get("logStreamName");
                if (app.startsWith(this.owner.getOwner() + "/")) {
                    app = app.substring((this.owner.getOwner() + "/").length());
                }
                logsFieldValues.put(LogsFieldName.APP, app);
                Long logEventTimestamp = (Long)logEvent.get("timestamp");
                if (!tail && logEventTimestamp > this.threadStartTimestamp) {
                    this.stop();
                    return;
                }
                String timestamp = DateUtils.toLocalDateTimeMillisString(new Date(logEventTimestamp));
                logsFieldValues.put(LogsFieldName.TIMESTAMP, timestamp);
                Map<String, Object> jsonMessage = JsonUtils.jsonToMap((String)logEvent.get("message"));
                for (Map.Entry<String, Object> entry : jsonMessage.entrySet()) {
                    LogsFieldName logsFieldName = LogsFieldName.fromFilterName(entry.getKey());
                    if (logsFieldName == null) continue;
                    String value = (String)entry.getValue();
                    if (LogsFieldName.IMAGE == logsFieldName && value != null && value.startsWith(this.owner.getOwner() + "/")) {
                        value = value.substring((this.owner.getOwner() + "/").length());
                    }
                    logsFieldValues.put(logsFieldName, value);
                }
                String msg = this.logsLayout.render(logsFieldValues, this.filters);
                switch (LogsLevel.valueOf((String)logsFieldValues.get((Object)LogsFieldName.LEVEL))) {
                    case ERROR: {
                        logsListener.onErrorLine(msg);
                        break;
                    }
                    case WARN: {
                        logsListener.onWarnLine(msg);
                        break;
                    }
                    case INFO: {
                        logsListener.onInfoLine(msg);
                        break;
                    }
                    case DEBUG: {
                        logsListener.onDebugLine(msg);
                        break;
                    }
                    case TRACE: {
                        logsListener.onTraceLine(msg);
                    }
                }
            }
            this.nextToken = (String)result.get("nextToken");
            boolean hasNextToken = StringUtils.hasLength(this.nextToken);
            if (events.isEmpty()) {
                if (!tail && !hasNextToken) {
                    this.stop();
                }
            } else {
                this.startTime = (Long)((Map)events.get(events.size() - 1)).get("timestamp");
                if (!hasNextToken) {
                    Long l = this.startTime;
                    Long l2 = this.startTime = Long.valueOf(this.startTime + 1L);
                }
            }
        }
        catch (Exception e) {
            logsListener.onException(e);
        }
        if (tail) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.stop();
            }
        }
    }

    protected abstract Map<String, Object> filterLogEvents(Long var1, Long var2, Long var3, String var4) throws IOException;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudwatchLogsLogs that = (CloudwatchLogsLogs)o;
        if (this.threadStartTimestamp != that.threadStartTimestamp) {
            return false;
        }
        if (this.first != that.first) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) {
            return false;
        }
        if (this.logsLayout != null ? !this.logsLayout.equals(that.logsLayout) : that.logsLayout != null) {
            return false;
        }
        if (this.filterPattern != null ? !this.filterPattern.equals(that.filterPattern) : that.filterPattern != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) {
            return false;
        }
        return this.nextToken != null ? this.nextToken.equals(that.nextToken) : that.nextToken == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
        result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
        result = 31 * result + (this.logsLayout != null ? this.logsLayout.hashCode() : 0);
        result = 31 * result + (this.filterPattern != null ? this.filterPattern.hashCode() : 0);
        result = 31 * result + (int)(this.threadStartTimestamp ^ this.threadStartTimestamp >>> 32);
        result = 31 * result + (this.first ? 1 : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.nextToken != null ? this.nextToken.hashCode() : 0);
        return result;
    }
}

