/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.port;

import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.types.IpAddress;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Restriction {
    private static final Logger LOGGER = LoggerFactory.getLogger(Restriction.class);
    public static final Restriction UNRESTRICTED = new Restriction("0.0.0.0/0");
    public static final Restriction OWN_IP = new Restriction("@/32");
    private final String restriction;

    private Restriction(String restriction) {
        this.restriction = restriction;
    }

    @JsonCreator
    public static Restriction of(String spec) {
        int cidrBlock;
        String addressSpec;
        if (spec == null || Restriction.UNRESTRICTED.restriction.equals(spec)) {
            return UNRESTRICTED;
        }
        if (Restriction.OWN_IP.restriction.equals(spec) || "@".equals(spec)) {
            return OWN_IP;
        }
        if (spec.contains("/")) {
            addressSpec = spec.substring(0, spec.indexOf("/"));
            String blockSpec = spec.substring(spec.indexOf("/") + 1);
            try {
                cidrBlock = Integer.parseInt(blockSpec);
            }
            catch (NumberFormatException e) {
                throw new BoxfuseException("Invalid CIDR block: " + blockSpec + " => must be between /0 and /32");
            }
            if (cidrBlock < 0 || cidrBlock > 32) {
                throw new BoxfuseException("Invalid CIDR block: " + blockSpec + " => must be between /0 and /32");
            }
        } else {
            addressSpec = spec;
            cidrBlock = 32;
        }
        if ("@".equals(addressSpec)) {
            return new Restriction(addressSpec + "/" + cidrBlock);
        }
        IpAddress original = IpAddress.of(addressSpec);
        IpAddress afterBlockMask = original.applyCidrMask(cidrBlock);
        String result = afterBlockMask + "/" + cidrBlock;
        if (!original.equals(afterBlockMask)) {
            LOGGER.warn("Normalized " + original + "/" + cidrBlock + " to " + result);
        }
        return new Restriction(result);
    }

    @JsonValue
    public String getRestriction() {
        return this.restriction;
    }

    public String toString() {
        return this.restriction.endsWith("/32") ? this.restriction.substring(0, this.restriction.lastIndexOf("/32")) : this.restriction;
    }

    public Restriction adjust(IpAddress ownIp) {
        return Restriction.of(this.toAdjustedString(ownIp));
    }

    public String toAdjustedString(IpAddress ownIp) {
        return this.toString().replace("@", ownIp.getIpAddress());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Restriction that = (Restriction)o;
        return this.restriction.equals(that.restriction);
    }

    public int hashCode() {
        return this.restriction.hashCode();
    }
}

