/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.exception.BoxfuseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class ChecksumUtils {
    private ChecksumUtils() {
    }

    public static long crc32(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return crc32.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long crc32(InputStream in) {
        try (BufferedInputStream bufIn = new BufferedInputStream(in, 16384);){
            int read;
            CRC32 crc32 = new CRC32();
            byte[] buf = new byte[16384];
            while ((read = bufIn.read(buf)) > -1) {
                crc32.update(buf, 0, read);
            }
            long l = crc32.getValue();
            return l;
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to calculate checksum: " + e.getMessage(), e);
        }
    }
}

