/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class DateUtils {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private DateUtils() {
    }

    public static Date toDate(int year, int month, int day) {
        return new GregorianCalendar(year, month - 1, day).getTime();
    }

    public static int minutesDiff(Date dateStart, Date dateEnd) {
        return (int)((dateEnd.getTime() - dateStart.getTime()) / 60000L);
    }

    public static short daysDiff(Date dateStart, Date dateEnd) {
        return (short)((dateEnd.getTime() - dateStart.getTime()) / 86400000L);
    }

    public static Date addMillis(Date date, int millis) {
        return new Date(date.getTime() + (long)millis);
    }

    public static Date addSeconds(Date date, int secs) {
        return new Date(date.getTime() + (long)secs * 1000L);
    }

    public static Date addMinutes(Date date, int mins) {
        return new Date(date.getTime() + (long)mins * 60000L);
    }

    public static Date addHours(Date date, int hours) {
        return new Date(date.getTime() + (long)hours * 3600000L);
    }

    public static Date addDays(Date date, int days) {
        return new Date(date.getTime() + (long)days * 86400000L);
    }

    public static Date addMonths(Date date, int months) {
        Calendar cal = Calendar.getInstance(UTC);
        cal.setTime(date);
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date addYears(Date date, int years) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        return cal.getTime();
    }

    public static String toDateString(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        String year = "" + calendar.get(1);
        String month = StringUtils.trimOrLeftPad("" + (calendar.get(2) + 1), 2, '0');
        String day = StringUtils.trimOrLeftPad("" + calendar.get(5), 2, '0');
        return year + "-" + month + "-" + day;
    }

    public static String toUtcDateTimeString(Date date) {
        return DateUtils.toDateTimeMillisString(date, UTC, false);
    }

    public static String toUtcDateTimeMillisString(Date date) {
        return DateUtils.toDateTimeMillisString(date, UTC, true);
    }

    private static String toDateTimeMillisString(Date date, TimeZone timeZone, boolean includeMillis) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTime(date);
        String year = "" + calendar.get(1);
        String month = StringUtils.trimOrLeftPad("" + (calendar.get(2) + 1), 2, '0');
        String day = StringUtils.trimOrLeftPad("" + calendar.get(5), 2, '0');
        String hour = StringUtils.trimOrLeftPad("" + calendar.get(11), 2, '0');
        String minute = StringUtils.trimOrLeftPad("" + calendar.get(12), 2, '0');
        String second = StringUtils.trimOrLeftPad("" + calendar.get(13), 2, '0');
        String result = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
        if (includeMillis) {
            String millis = StringUtils.trimOrLeftPad("" + calendar.get(14), 3, '0');
            result = result + "." + millis;
        }
        return result;
    }

    public static Date toUtcDateTime(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.set(year, month - 1, day, hour, minute, second);
        return DateUtils.zeroMillis(calendar.getTime());
    }

    public static Date toDateTime(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(year, month - 1, day, hour, minute, second);
        return DateUtils.zeroMillis(calendar.getTime());
    }

    public static Date toUtcDateTime(String dateStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(UTC);
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            throw new BoxfuseBugException("Unable to parse date and time: " + dateStr);
        }
    }

    public static Date toDateTime(String dateStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            throw new BoxfuseBugException("Unable to parse date and time: " + dateStr);
        }
    }

    public static Date toDateTimeFlexible(String dateStr) {
        return DateUtils.toDateTimeFlexible(new Date(), dateStr);
    }

    static Date toDateTimeFlexible(Date reference, String dateStr) {
        List<String> patterns = Arrays.asList("yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm", "yyyy-MM-ddZ", "yyyy-MM-dd", "HH:mm:ssZ", "HH:mm:ss", "HH:mmZ", "HH:mm");
        try {
            long delta = Long.parseLong(dateStr);
            return new Date(reference.getTime() + delta * 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            for (String pattern : patterns) {
                Date date = DateUtils.attemptParsing(reference, dateStr, pattern);
                if (date == null) continue;
                return date;
            }
            throw new BoxfuseException("Unparseable date: " + dateStr + " => ensure it is in one of the following formats: " + StringUtils.collectionToDelimitedString(patterns, ", "));
        }
    }

    public static Date zeroMillis(Date date) {
        return new Date(date.getTime() / 1000L * 1000L);
    }

    private static Date attemptParsing(Date now, String dateStr, String pattern) {
        boolean utc = false;
        if (dateStr.endsWith("Z") && pattern.endsWith("Z")) {
            dateStr = dateStr.substring(0, dateStr.lastIndexOf("Z"));
            pattern = pattern.substring(0, pattern.lastIndexOf("Z"));
            utc = true;
        }
        if (pattern.startsWith("HH")) {
            pattern = "yyyy-MM-dd " + pattern;
            Date date = DateUtils.zeroMillis(now);
            dateStr = utc ? DateUtils.getYearUTC(date) + "-" + DateUtils.getMonthUTC(date) + "-" + DateUtils.getDayUTC(date) + " " + dateStr : DateUtils.getYear(date) + "-" + DateUtils.getMonth(date) + "-" + DateUtils.getDay(date) + " " + dateStr;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        if (utc) {
            format.setTimeZone(UTC);
        }
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date toUtcDateTimeMillis(String dateStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            throw new BoxfuseBugException("Unable to parse date and time: " + dateStr);
        }
    }

    public static String toLocalDateTimeString(Date date) {
        return DateUtils.toDateTimeMillisString(date, TimeZone.getDefault(), false);
    }

    public static String toLocalDateTimeMillisString(Date date) {
        return DateUtils.toDateTimeMillisString(date, TimeZone.getDefault(), true);
    }

    public static Date startOfMinute(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date startOfHourUtc(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date startOfDayUtc(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date startOfMonthUtc(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String formatAsUtcTimeHM(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return String.format("%02d:%02d", calendar.get(11), calendar.get(12));
    }

    public static String formatAsUtcDateTime(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return String.format("%04d-%02d-%02d %02d:%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12));
    }

    public static String formatAsUtcDateTimeWithSeconds(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return String.format("%04d-%02d-%02d %02d:%02d:%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static String formatAsUtcDateTimeFull(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return String.format("%04d-%02d-%02d %02d:%02d:%02d.%03d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static String formatAsIsoDateTime(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static String formatAsDateTimeFull(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return String.format("%04d-%02d-%02d %02d:%02d:%02d.%03d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static String formatAsUtcDateTimeCompact(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return String.format("%04d%02d%02d%02d%02d%02d%03d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static String formatAsUtcDate(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return String.format("%04d-%02d-%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static String formatAsUtcMonths(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return String.format("%04d-%02d", calendar.get(1), calendar.get(2) + 1);
    }

    public static int getYear() {
        return DateUtils.getYear(new Date());
    }

    public static int getYear(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getYearUTC(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth() {
        return DateUtils.getMonth(new Date());
    }

    public static int getMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getMonthUTC(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDayUTC(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getHour(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static Date nowUtc() {
        return new GregorianCalendar(UTC).getTime();
    }

    public static int getDaysInMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }
}

