/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.base.util;

import com.boxfuse.base.exception.BoxfuseBugException;
import com.boxfuse.base.exception.BoxfuseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\fH\u0007J\u0018\u0010\n\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0013H\u0003J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\fH\u0007J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\fH\u0007J\u0018\u0010\n\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000fH\u0007J\"\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u0011H\u0007J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u0011H\u0007J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0017H\u0007J\u001a\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u0011H\u0007J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u0011H\u0007J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0012H\u0007J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/boxfuse/base/util/IOUtils;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "close", "", "c", "Ljava/io/Closeable;", "copy", "in", "Ljava/io/File;", "out", "file", "Ljava/io/OutputStream;", "Ljava/io/InputStream;", "", "Ljava/io/Reader;", "Ljava/io/Writer;", "bytes", "", "str", "", "copyNoClose", "bufferSize", "copyToByteArray", "size", "resource", "copyToByteArrayNoClose", "copyToString", "boxfuse-base-core"})
public final class IOUtils {
    @NotNull
    public static final IOUtils INSTANCE = new IOUtils();
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    @JvmStatic
    @Nullable
    public static final byte[] copyToByteArray(@Nullable File in) {
        if (in == null || !in.isFile()) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)in.length());
        try {
            IOUtils.copy((InputStream)new FileInputStream(in), (OutputStream)out);
        }
        catch (IOException e) {
            throw new BoxfuseException(Intrinsics.stringPlus("Unable to read file: ", in.getAbsolutePath()), e);
        }
        return out.toByteArray();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final byte[] copyToByteArray(@NotNull InputStream in, int size) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        ByteArrayOutputStream out = new ByteArrayOutputStream(size);
        IOUtils.copy(in, (OutputStream)out);
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "out.toByteArray()");
        return byArray;
    }

    public static /* synthetic */ byte[] copyToByteArray$default(InputStream inputStream, int n, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            n = 4096;
        }
        return IOUtils.copyToByteArray(inputStream, n);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final byte[] copyToByteArrayNoClose(@NotNull InputStream in, int size) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        ByteArrayOutputStream out = new ByteArrayOutputStream(size);
        IOUtils.copyNoClose$default(in, out, 0, 4, null);
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "out.toByteArray()");
        return byArray;
    }

    public static /* synthetic */ byte[] copyToByteArrayNoClose$default(InputStream inputStream, int n, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            n = 4096;
        }
        return IOUtils.copyToByteArrayNoClose(inputStream, n);
    }

    @JvmStatic
    @NotNull
    public static final byte[] copyToByteArray(@NotNull String resource) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(resource, "resource");
        String res = StringsKt.startsWith$default(resource, "/", false, 2, null) ? resource : Intrinsics.stringPlus("/", resource);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            InputStream inputStream = INSTANCE.getClass().getResourceAsStream(res);
            Intrinsics.checkNotNull(inputStream);
            IOUtils.copy(inputStream, (OutputStream)out);
            byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "{\n            val out = ByteArrayOutputStream(4096)\n            copy(javaClass.getResourceAsStream(res)!!, out)\n            out.toByteArray()\n        }");
        }
        catch (IOException e) {
            throw new BoxfuseBugException(Intrinsics.stringPlus("Unable to load resource: ", res), e);
        }
        return byArray;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String copyToString(@NotNull InputStream in, int size) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        byte[] byArray = IOUtils.copyToByteArray(in, size);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        boolean bl = false;
        String $this$trim$iv = new String(byArray, charset);
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl2 = false;
            boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    public static /* synthetic */ String copyToString$default(InputStream inputStream, int n, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            n = 4096;
        }
        return IOUtils.copyToString(inputStream, n);
    }

    @JvmStatic
    @Nullable
    public static final String copyToString(@Nullable File file) {
        Object object;
        if (file == null || !file.isFile()) {
            object = null;
        } else {
            Object object2;
            try {
                object2 = IOUtils.copyToByteArray(file);
                Intrinsics.checkNotNull(object2);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
                boolean bl = false;
                String $this$trim$iv = new String((byte[])object2, charset);
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                object2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }
            catch (Exception e) {
                throw new BoxfuseException(Intrinsics.stringPlus("Unable to read file: ", file.getAbsolutePath()), e);
            }
            object = object2;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final String copyToString(@NotNull String resource) {
        Object object;
        Intrinsics.checkNotNullParameter(resource, "resource");
        try {
            object = IOUtils.copyToByteArray(resource);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            boolean bl = false;
            String $this$trim$iv = new String((byte[])object, charset);
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            object = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }
        catch (IOException e) {
            throw new BoxfuseBugException(Intrinsics.stringPlus("Unable to load classpath resource: ", resource), e);
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final String copyToString(@NotNull Reader in) throws IOException {
        String string;
        Intrinsics.checkNotNullParameter(in, "in");
        StringWriter out = new StringWriter();
        IOUtils.copy(in, out);
        String string2 = out.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "out.toString()");
        String str = string2;
        if (StringsKt.startsWith$default(str, "\ufeff", false, 2, null)) {
            string2 = str;
            int n = 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
            string2 = string3;
            n = 0;
            String string4 = string2;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string2 = str;
            boolean bl = false;
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final void copy(Reader in, Writer out) throws IOException {
        try {
            char[] buffer = new char[4096];
            int bytesRead = 0;
            while (true) {
                int n = in.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                bytesRead = it;
                if (n == -1) break;
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        finally {
            IOUtils.close(in);
            IOUtils.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final int copy(@NotNull InputStream in, @NotNull OutputStream out) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(out, "out");
        try {
            n = IOUtils.copyNoClose$default(in, out, 0, 4, null);
        }
        finally {
            IOUtils.close(in);
            IOUtils.close(out);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final int copy(@NotNull String in, @NotNull OutputStream out) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(out, "out");
        try {
            String string = in;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            n = IOUtils.copyNoClose$default(new ByteArrayInputStream(byArray), out, 0, 4, null);
        }
        finally {
            IOUtils.close(out);
        }
        return n;
    }

    @JvmStatic
    @JvmOverloads
    public static final int copyNoClose(@NotNull InputStream in, @NotNull OutputStream out, int bufferSize) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(out, "out");
        int byteCount = 0;
        byte[] buffer = new byte[bufferSize];
        int bytesRead = 0;
        while (true) {
            int n = in.read(buffer);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            bytesRead = it;
            if (n == -1) break;
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }

    public static /* synthetic */ int copyNoClose$default(InputStream inputStream, OutputStream outputStream, int n, int n2, Object object) throws IOException {
        if ((n2 & 4) != 0) {
            n = 4096;
        }
        return IOUtils.copyNoClose(inputStream, outputStream, n);
    }

    @JvmStatic
    public static final void copyNoClose(@NotNull byte[] bytes, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        Intrinsics.checkNotNullParameter(out, "out");
        IOUtils.copyNoClose(new ByteArrayInputStream(bytes), out, bytes.length);
    }

    @JvmStatic
    public static final void copyNoClose(@NotNull String in, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(out, "out");
        String string = in;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        IOUtils.copyNoClose$default(new ByteArrayInputStream(byArray), out, 0, 4, null);
    }

    @JvmStatic
    public static final void copy(@NotNull byte[] bytes, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        Intrinsics.checkNotNullParameter(out, "out");
        IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), out);
    }

    @JvmStatic
    public static final void copy(@NotNull byte[] bytes, @NotNull File file) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new BoxfuseException(Intrinsics.stringPlus("Unable to write to ", file.getAbsolutePath()), e);
        }
    }

    @JvmStatic
    public static final void copy(@NotNull String str, @NotNull File file) {
        Intrinsics.checkNotNullParameter(str, "str");
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            IOUtils.copy(new StringReader(str), new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new BoxfuseException(Intrinsics.stringPlus("Unable to write to ", file.getAbsolutePath()), e);
        }
    }

    @JvmStatic
    public static final void copy(@NotNull InputStream in, @NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(file, "file");
        IOUtils.copy(in, (OutputStream)new FileOutputStream(file));
    }

    @JvmStatic
    public static final void copy(@NotNull File file, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(out, "out");
        IOUtils.copy((InputStream)new FileInputStream(file), out);
    }

    @JvmStatic
    public static final void copy(@NotNull File in, @NotNull File out) {
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(out, "out");
        try {
            IOUtils.copy((InputStream)new FileInputStream(in), (OutputStream)new FileOutputStream(out));
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to copy " + in.getAbsolutePath() + " to " + out.getAbsolutePath() + ": " + e.getMessage());
        }
    }

    @JvmStatic
    public static final void close(@Nullable Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error while closing resource", (Throwable)e);
            }
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final byte[] copyToByteArray(@NotNull InputStream in) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        return IOUtils.copyToByteArray$default(in, 0, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final byte[] copyToByteArrayNoClose(@NotNull InputStream in) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        return IOUtils.copyToByteArrayNoClose$default(in, 0, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String copyToString(@NotNull InputStream in) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        return IOUtils.copyToString$default(in, 0, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final int copyNoClose(@NotNull InputStream in, @NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(out, "out");
        return IOUtils.copyNoClose$default(in, out, 0, 4, null);
    }
}

