/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.client.core.internal.platform.local.hyperv;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.PlatformType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.env.EnvironmentScript;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.logs.Logs;
import com.boxfuse.base.logs.cloudwatchlogs.LogsLayout;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.types.IpAddress;
import com.boxfuse.base.types.MacAddress;
import com.boxfuse.base.types.TmpGB;
import com.boxfuse.base.util.IOUtils;
import com.boxfuse.base.util.IdUtils;
import com.boxfuse.base.util.JsonUtils;
import com.boxfuse.base.util.ServerUtils;
import com.boxfuse.base.util.ShellUtils;
import com.boxfuse.base.util.Template;
import com.boxfuse.base.util.ThreadUtils;
import com.boxfuse.client.core.internal.dev.DevAgent;
import com.boxfuse.client.core.internal.diskimage.DiskImage;
import com.boxfuse.client.core.internal.diskimage.Vhd;
import com.boxfuse.client.core.internal.platform.BootLogsListener;
import com.boxfuse.client.core.internal.platform.DevVM;
import com.boxfuse.client.core.internal.platform.Instance;
import com.boxfuse.client.core.internal.platform.LaunchSettings;
import com.boxfuse.client.core.internal.platform.local.LocalPlatform;
import com.boxfuse.client.core.internal.platform.local.LocalPlatformHealth;
import com.boxfuse.client.core.internal.platform.local.NoOpLogs;
import com.boxfuse.client.core.internal.platform.local.SerialPortFileLogs;
import com.boxfuse.client.core.internal.platform.local.hyperv.HyperVInstallation;
import com.boxfuse.client.core.internal.platform.local.hyperv.HyperVInstance;
import com.boxfuse.client.core.internal.platform.local.hyperv.HyperVSwitch;
import com.boxfuse.generator.config.CpuCount;
import com.boxfuse.generator.config.InstanceId;
import com.boxfuse.generator.config.LogsFilters;
import com.boxfuse.generator.config.RamMB;
import com.boxfuse.generator.image.Image;
import com.boxfuse.generator.inventory.Component;
import com.boxfuse.generator.repository.Repository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperVPlatform
extends LocalPlatform<HyperVInstance> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HyperVPlatform.class);
    private static final String UNSUPPORTED_OS_MSG = "Ensure your are running Windows 10 Pro or higher";
    private static final String SWITCH_NAME = "Boxfuse";
    private static final List<String> RETRY_OUTPUTS = Collections.singletonList("ObjectNotFound,Microsoft.HyperV.PowerShell.Commands.GetVM");
    private final String windowsUser;
    private final String windowsPassword;
    private HyperVSwitch boxfuseSwitch;

    public HyperVPlatform(File workDir, Repository repository, DevAgent devAgent, LogsLayout logsLayout, String windowsUser, String windowsPassword) {
        super(PlatformType.HYPERV, workDir, repository, devAgent, logsLayout, true);
        this.windowsUser = windowsUser;
        this.windowsPassword = windowsPassword;
    }

    @Override
    public List<Instance> runningInstances() {
        ArrayList<Instance> runningInstances = new ArrayList<Instance>();
        String vms = HyperVPlatform.execHyperVPowerShellCommand("Get-VM | Where-Object {$_.State -eq 'Running'} | Select-Object -Property Name,Notes,ProcessorCount,MemoryAssigned | ConvertTo-Csv -NoTypeInformation");
        try {
            boolean first = true;
            for (CSVRecord record : CSVParser.parse(vms, CSVFormat.DEFAULT)) {
                ImageCoordinates coordinates;
                Image image;
                if (first) {
                    first = false;
                    continue;
                }
                String vmName = record.get(0);
                if (!InstanceId.isValid(vmName) || (image = this.repository.findLocally(coordinates = ImageCoordinates.of(record.get(1), null))) == null) continue;
                InstanceId instanceId = new InstanceId(vmName);
                File instanceDir = this.getInstanceDir(instanceId);
                Logs bootLogs = this.getBootLogs(instanceId, instanceDir, true);
                Logs appLogs = this.getAppLogs(image, new LogsFilters(image.getMetadata().owner));
                Date launchTime = new Date();
                CpuCount cpuCount = CpuCount.of(record.get(2));
                RamMB ramMB = RamMB.of(Long.valueOf(record.get(3)) / 0x100000L);
                runningInstances.add(new HyperVInstance(this, image, this.createOrGetDiskImage(image, instanceDir), instanceId, cpuCount, ramMB, launchTime, this.getIp(instanceId), bootLogs, appLogs, instanceDir, image.getPorts(), null));
            }
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to parse list of running instances: " + vms);
        }
        return runningInstances;
    }

    @Override
    public List<Instance> getInstances(Collection<InstanceId> instanceIds) {
        List<Instance> instances = this.runningInstances();
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (Instance instance : instances) {
            if (!instanceIds.contains(instance.getId())) continue;
            result.add(instance);
        }
        return result;
    }

    @Override
    public boolean supportsDevVM() {
        return false;
    }

    @Override
    public DevVM getDevVM(Component devHddComponent, AppCoordinates appCoordinates, DbType dbType) {
        throw new BoxfuseException("Local database testing is not supported on Hyper-V yet. Switch to VirtualBox instead.");
    }

    @Override
    protected HyperVInstance startAndTagInstance(InstanceId instanceId, File instanceDir, Image image, DiskImage diskImage, LaunchSettings launchSettings, Map<PortName, Port> ports, Map<EnvVarName, EnvVarValue> envVars, Logs appLogs, Date launchTime) {
        HyperVSwitch boxfuseSwitch = this.getHyperVSwitch();
        try {
            IpAddress ip;
            TmpGB effectiveTmp;
            HyperVPlatform.execHyperVPowerShellCommand("New-VM -Name " + instanceId + " -Path '" + instanceDir.getAbsolutePath() + "' -MemoryStartupBytes " + launchSettings.getRamInMB().getValue() + "MB -VHDPath '" + diskImage.getMainFile().getAbsolutePath() + "' -BootDevice IDE -SwitchName " + boxfuseSwitch.getName());
            HyperVPlatform.execHyperVPowerShellCommand("Set-VM " + instanceId + " -CheckpointType Disabled -StaticMemory -ProcessorCount " + launchSettings.getCpus().getValue() + " -Notes " + image.getCoordinates());
            HyperVPlatform.execHyperVPowerShellCommand("Set-VMBios " + instanceId + " -EnableNumLock");
            try {
                HyperVPlatform.execHyperVPowerShellCommand("Disable-VMIntegrationService -Name 'Time Synchronization' -VMName " + instanceId);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to disable HyperV Time Synchronization for " + instanceId + ": VM timezone will probably be incorrect", (Throwable)e);
            }
            TmpGB tmpGB = effectiveTmp = launchSettings.getTmp() == null ? image.getTmp() : launchSettings.getTmp();
            if (effectiveTmp.getValue() > 0) {
                File tmpDiskFile = this.getTmpDiskFile(instanceDir);
                int tmpInGB = effectiveTmp.getValue();
                HyperVPlatform.execHyperVPowerShellCommand("New-VHD -Path '" + tmpDiskFile.getAbsolutePath() + "' -SizeBytes " + tmpInGB + "GB");
                HyperVPlatform.execHyperVPowerShellCommand("Add-VMHardDiskDrive -VMName " + instanceId + " -Path '" + tmpDiskFile.getAbsolutePath() + "'");
            }
            if (image.isLive()) {
                File liveDir = new File(this.workDir, "Live");
                if (!liveDir.exists()) {
                    ShellUtils.mkdir(liveDir);
                }
                if (!this.hasBoxfuseShare()) {
                    throw new BoxfuseException("Boxfuse Live Image support for Hyper-V is not set up yet => Execute powershell \"" + this.extractLiveScript(liveDir) + "\" to fix");
                }
                ShellUtils.createDirHardLink(new File(liveDir, instanceId.getId()), image.getPayload().getFile());
                envVars.put(EnvVarName.BOXFUSE_WINDOWS_USER, EnvVarValue.asIs(this.windowsUser));
                envVars.put(EnvVarName.BOXFUSE_WINDOWS_PASSWORD, EnvVarValue.asIs(this.windowsPassword));
            }
            int offset = TimeZone.getDefault().getOffset(new Date().getTime()) / 3600000;
            envVars.put(EnvVarName.of("TZ"), EnvVarValue.asIs("UTC" + (offset >= 0 ? "+" : "") + offset));
            File environmentIso = this.createEnvironmentIso(instanceDir, new EnvironmentScript(envVars));
            HyperVPlatform.execHyperVPowerShellCommand("Set-VMDvdDrive -VMName " + instanceId + " -Path '" + environmentIso.getAbsolutePath() + "'");
            Logs bootLogs = this.getBootLogs(instanceId, instanceDir, launchSettings.isLogsBoot());
            if (launchSettings.isLogsAuto()) {
                bootLogs.start(true, new BootLogsListener(instanceId));
            }
            this.startVM(instanceId.getId());
            do {
                ThreadUtils.sleep(500L);
            } while ((ip = this.getIp(instanceId)) == null);
            return new HyperVInstance(this, image, diskImage, instanceId, launchSettings.getCpus(), launchSettings.getRamInMB(), launchTime, ip, bootLogs, appLogs, instanceDir, ports, image.getMetadata().payload.path);
        }
        catch (Exception e) {
            throw new BoxfuseException("Unable to create Hyper-V VM: " + e.getMessage(), e);
        }
    }

    private boolean hasBoxfuseShare() {
        String shares = HyperVPlatform.execHyperVPowerShellCommand("Get-SmbShare | Select-Object -Property Name | ConvertTo-Csv -NoTypeInformation");
        try {
            boolean first = true;
            for (CSVRecord record : CSVParser.parse(shares, CSVFormat.DEFAULT)) {
                if (first) {
                    first = false;
                    continue;
                }
                if (!SWITCH_NAME.equals(record.get(0))) continue;
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to parse list of network shares: " + shares);
        }
        return false;
    }

    private String startVM(String vmName) {
        return HyperVPlatform.execHyperVPowerShellCommand("Start-VM -Name " + vmName);
    }

    private HyperVSwitch getHyperVSwitch() {
        if (this.boxfuseSwitch == null) {
            this.boxfuseSwitch = HyperVPlatform.findSwitch(SWITCH_NAME);
            if (this.boxfuseSwitch == null) {
                this.boxfuseSwitch = HyperVPlatform.createSwitch(SWITCH_NAME);
            }
        }
        return this.boxfuseSwitch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logs getBootLogs(InstanceId instanceId, File instanceDir, boolean logsBoot) {
        if (!logsBoot) return NoOpLogs.INSTANCE;
        this.devAgent.start();
        String namedPipe = "\\\\.\\pipe\\boxfuse_" + instanceId;
        HyperVPlatform.execHyperVPowerShellCommand("Set-VMComPort " + instanceId + " 1 " + namedPipe);
        SerialPortFileLogs serialPortFileLogs2 = SerialPortFileLogs.createInDir(instanceDir, instanceId);
        try {
            HttpPost request = new HttpPost("http://localhost:" + this.devAgent.getPort() + "/namedpipes");
            TreeMap<String, Object> json = new TreeMap<String, Object>();
            json.put("namedPipe", namedPipe);
            json.put("destination", serialPortFileLogs2.getLogsFilePath());
            request.setEntity((HttpEntity)new StringEntity(JsonUtils.mapToJson(json), ContentType.APPLICATION_JSON));
            try (CloseableHttpResponse response = HttpClientBuilder.create().build().execute((HttpUriRequest)request);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    LOGGER.warn("Unable to obtain instance boot logs for " + instanceId + " (HTTP " + statusCode + ")");
                    NoOpLogs noOpLogs = NoOpLogs.INSTANCE;
                    return noOpLogs;
                }
                SerialPortFileLogs serialPortFileLogs = serialPortFileLogs2;
                return serialPortFileLogs;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to obtain instance boot logs for " + instanceId + " (" + e.getMessage() + ")");
            return NoOpLogs.INSTANCE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IpAddress getIp(InstanceId instanceId) {
        try {
            HttpGet request = new HttpGet("http://localhost:" + this.devAgent.getPort() + "/ips?q=" + instanceId);
            try (CloseableHttpResponse response = HttpClientBuilder.create().build().execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    IpAddress ipAddress2 = null;
                    return ipAddress2;
                }
                IpAddress ipAddress = IpAddress.of(IOUtils.copyToString(response.getEntity().getContent()));
                return ipAddress;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    static HyperVSwitch createSwitch(String name) {
        String adapterName = HyperVPlatform.getAdapterNameForSwitch();
        try {
            HyperVPlatform.execHyperVPowerShellCommand("New-VMSwitch -Name " + name + " -NetAdapterName '" + adapterName + "'");
        }
        catch (Exception e) {
            throw new BoxfuseException("Unable to create Hyper-V Switch: " + e.getMessage());
        }
        LOGGER.debug("Created Hyper-V Switch " + name + " on " + adapterName);
        return new HyperVSwitch(name);
    }

    static String execHyperVPowerShellCommand(String cmd) {
        return ShellUtils.execCommandWithRetries(3, RETRY_OUTPUTS, new HashMap<String, Integer>(), "powershell", cmd);
    }

    private static String getAdapterNameForSwitch() {
        MacAddress preferredMacAddress = ServerUtils.getMacAddress();
        String adapters = HyperVPlatform.execHyperVPowerShellCommand("Get-NetAdapter -Physical | Select-Object -Property Name,MacAddress,Status | ConvertTo-Csv -NoTypeInformation");
        try {
            boolean first = true;
            for (CSVRecord record : CSVParser.parse(adapters, CSVFormat.DEFAULT)) {
                if (first) {
                    first = false;
                    continue;
                }
                if (!preferredMacAddress.equals(MacAddress.of(record.get(1)))) continue;
                return record.get(0);
            }
        }
        catch (Exception e) {
            throw new BoxfuseException("Unable to parse list of network adapters: " + adapters);
        }
        throw new BoxfuseException("Unable to detect network adapter with MAC address " + preferredMacAddress + ": " + adapters);
    }

    static HyperVSwitch findSwitch(String name) {
        boolean exists = HyperVPlatform.execHyperVPowerShellCommand("Get-VMSwitch").contains(name);
        if (exists) {
            LOGGER.debug("Found Hyper-V Switch " + name);
            return new HyperVSwitch(name);
        }
        return null;
    }

    @Override
    protected File getTmpDiskFile(File instanceDir) {
        return new File(instanceDir.getAbsolutePath() + "/tmp.vhd");
    }

    @Override
    protected DiskImage createOrGetDiskImage(Image image, File instanceDir) {
        return new Vhd(image, instanceDir);
    }

    @Override
    protected InstanceId generateInstanceId() {
        return new InstanceId(IdUtils.generateLocallyUniqueId("hv"));
    }

    @Override
    public boolean isHealthy() {
        return HyperVInstallation.get().getHealth().equals((Object)LocalPlatformHealth.OK);
    }

    @Override
    public void ensureHealthy() {
        HyperVInstallation installationDetails = HyperVInstallation.get();
        switch (installationDetails.getHealth()) {
            case UNSUPPORTED_OS: {
                throw new BoxfuseException("Hyper-V is not supported on your OS => Ensure your are running Windows 10 Pro or higher");
            }
            case NOT_INSTALLED: {
                throw new BoxfuseException("Hyper-V is not installed => Execute powershell \"" + this.extractInstallScript().getAbsolutePath() + "\" to fix");
            }
            case NOT_ADMIN: {
                throw new BoxfuseException("You are currently not an authorized Hyper-V administrator => Execute powershell \"" + this.extractAdminScript().getAbsolutePath() + "\" to fix");
            }
        }
    }

    @Override
    public boolean needsDevAgent() {
        return true;
    }

    private File extractAdminScript() {
        File adminScript = new File(this.workDir, "becomeHyperVAdmin.ps1");
        IOUtils.copy(IOUtils.copyToByteArray("hyperv/becomeHyperVAdmin.ps1"), adminScript);
        return adminScript;
    }

    private File extractInstallScript() {
        File installScript = new File(this.workDir, "installHyperV.ps1");
        IOUtils.copy(IOUtils.copyToByteArray("hyperv/installHyperV.ps1"), installScript);
        return installScript;
    }

    private File extractLiveScript(File liveDir) {
        File installScript = new File(this.workDir, "installHyperVLiveImageSupport.ps1");
        IOUtils.copy(Template.process("hyperv/installHyperVLiveImageSupport.ps1.template", liveDir.getAbsolutePath()), installScript);
        return installScript;
    }

    @Override
    protected boolean vmExists(String vmName) {
        String vms = HyperVPlatform.execHyperVPowerShellCommand("Get-VM | Select-Object -Property Name | ConvertTo-Csv -NoTypeInformation");
        try {
            boolean first = true;
            for (CSVRecord record : CSVParser.parse(vms, CSVFormat.DEFAULT)) {
                if (first) {
                    first = false;
                    continue;
                }
                if (!vmName.equals(record.get(0))) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new BoxfuseException("Unable to parse list of running instances: " + vms);
        }
    }
}

